/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.dialog;

import android.app.Dialog;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.view.View;
import android.view.Window;
import android.widget.TextView;
import com.yy.mobile.ui.utils.dialog.BaseDialog;
import com.yy.mobile.ui.utils.dialog.OkDialogListener;
import com.yymobile.baseapi.R;

public class TitleMessageClickableOkDialog
implements BaseDialog {
    private final CharSequence title;
    private boolean isTitleCenter;
    private boolean messageCenter;
    private final CharSequence message;
    private boolean messageClickable;
    private final CharSequence okLabel;
    private boolean outsideCancelable;
    private boolean backCancelable;
    private final OkDialogListener listener;

    public TitleMessageClickableOkDialog(CharSequence title, boolean isTitleCenter, boolean messageCenter, CharSequence message, boolean messageClickable, CharSequence okLabel, boolean outsideCancelable, boolean backCancelable, OkDialogListener listener) {
        this.title = title;
        this.isTitleCenter = isTitleCenter;
        this.messageCenter = messageCenter;
        this.message = message;
        this.messageClickable = messageClickable;
        this.okLabel = okLabel;
        this.outsideCancelable = outsideCancelable;
        this.backCancelable = backCancelable;
        this.listener = listener;
    }

    @Override
    public void init(Dialog dialog) {
        dialog.setCancelable(this.backCancelable);
        dialog.setCanceledOnTouchOutside(this.outsideCancelable);
        dialog.show();
        Window window = dialog.getWindow();
        window.setContentView(this.getLayoutResId());
        TextView titleTv = (TextView)window.findViewById(R.id.message);
        if (this.isTitleCenter) {
            titleTv.setGravity(17);
        } else {
            titleTv.setGravity(19);
        }
        if (!TextUtils.isEmpty((CharSequence)this.title)) {
            titleTv.setText(this.title);
        }
        TextView messageTv = (TextView)window.findViewById(R.id.message_content);
        if (this.messageCenter) {
            messageTv.setGravity(17);
        } else {
            messageTv.setGravity(3);
        }
        if (!TextUtils.isEmpty((CharSequence)this.message)) {
            messageTv.setText(this.message);
        }
        if (this.messageClickable) {
            messageTv.setMovementMethod(LinkMovementMethod.getInstance());
        }
        TextView ok = (TextView)window.findViewById(R.id.btn_ok);
        ok.setText(this.okLabel);
        if (this.okLabel.length() > 4) {
            if (dialog.getContext().getResources().getDisplayMetrics().widthPixels <= 480) {
                ok.setTextSize(2, 14.0f);
            } else {
                ok.setTextSize(2, 16.0f);
            }
        }
        ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (TitleMessageClickableOkDialog.this.listener != null) {
                    TitleMessageClickableOkDialog.this.listener.onOk();
                }
            }
        });
    }

    @Override
    public int getLayoutResId() {
        return R.layout.layout_title_ok_dialog;
    }
}

