/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.dialog;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Handler;
import android.os.Looper;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.ui.utils.dialog.DialogLinkManager;
import com.yy.mobile.ui.utils.dialog.ProgressDialog;
import com.yymobile.baseapi.R;

public class TimeOutProgressDialog
implements DialogInterface.OnDismissListener {
    private static final String TAG = "TimeOutProgressDialog";
    private String msg;
    private long time;
    private DialogLinkManager dialogManager;
    private DialogInterface.OnDismissListener mOnDismissListener;
    private Handler handler = new Handler(Looper.myLooper());
    private Runnable processProgressTimeoutTask = new Runnable(){

        @Override
        public void run() {
            if (TimeOutProgressDialog.this.dialogManager != null) {
                TimeOutProgressDialog.this.dialogManager.dismissDialog();
            }
            SingleToastUtil.showToast((int)R.string.str_network_not_capable);
        }
    };

    public TimeOutProgressDialog(Context context, String msg, long time) {
        this.msg = msg;
        this.time = time;
        this.dialogManager = new DialogLinkManager(context);
    }

    public void setOnDismissListener(DialogInterface.OnDismissListener listener) {
        this.mOnDismissListener = listener;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public void showProcessProgress() {
        if (this.dialogManager != null) {
            this.hideProcessProgress();
            this.dialogManager.showDialog(new ProgressDialog(this.msg, false, false, 0, this));
            this.handler.postDelayed(this.processProgressTimeoutTask, this.time);
        }
    }

    public void hideProcessProgress() {
        this.handler.removeCallbacks(this.processProgressTimeoutTask);
        if (this.dialogManager != null) {
            this.dialogManager.dismissDialog();
        }
    }

    public void onDismiss(DialogInterface dialog) {
        this.handler.removeCallbacks(this.processProgressTimeoutTask);
        if (this.mOnDismissListener != null) {
            this.mOnDismissListener.onDismiss(dialog);
        }
    }
}

