/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.autoscrollviewpager;

import android.os.Build;
import android.util.SparseArray;
import android.view.View;

public class RecycleBin {
    private View[] activeViews = new View[0];
    private int[] activeViewTypes = new int[0];
    private SparseArray<View>[] scrapViews;
    private int viewTypeCount;
    private SparseArray<View> currentScrapViews;

    public void setViewTypeCount(int viewTypeCount) {
        if (viewTypeCount < 1) {
            throw new IllegalArgumentException("Can't have a viewTypeCount < 1");
        }
        SparseArray[] scrapViews = new SparseArray[viewTypeCount];
        for (int i2 = 0; i2 < viewTypeCount; ++i2) {
            scrapViews[i2] = new SparseArray();
        }
        this.viewTypeCount = viewTypeCount;
        this.currentScrapViews = scrapViews[0];
        this.scrapViews = scrapViews;
    }

    protected boolean shouldRecycleViewType(int viewType) {
        return viewType >= 0;
    }

    View getScrapView(int position, int viewType) {
        if (this.viewTypeCount == 1) {
            return RecycleBin.retrieveFromScrap(this.currentScrapViews, position);
        }
        if (viewType >= 0 && viewType < this.scrapViews.length) {
            return RecycleBin.retrieveFromScrap(this.scrapViews[viewType], position);
        }
        return null;
    }

    void addScrapView(View scrap, int position, int viewType) {
        if (this.viewTypeCount == 1) {
            this.currentScrapViews.put(position, (Object)scrap);
        } else {
            this.scrapViews[viewType].put(position, (Object)scrap);
        }
        if (Build.VERSION.SDK_INT >= 14) {
            scrap.setAccessibilityDelegate(null);
        }
    }

    void scrapActiveViews() {
        View[] activeViews = this.activeViews;
        int[] activeViewTypes = this.activeViewTypes;
        boolean multipleScraps = this.viewTypeCount > 1;
        SparseArray<View> scrapViews = this.currentScrapViews;
        int count = activeViews.length;
        for (int i2 = count - 1; i2 >= 0; --i2) {
            View victim = activeViews[i2];
            if (victim == null) continue;
            int whichScrap = activeViewTypes[i2];
            activeViews[i2] = null;
            activeViewTypes[i2] = -1;
            if (!this.shouldRecycleViewType(whichScrap)) continue;
            if (multipleScraps) {
                scrapViews = this.scrapViews[whichScrap];
            }
            scrapViews.put(i2, (Object)victim);
            if (Build.VERSION.SDK_INT < 14) continue;
            victim.setAccessibilityDelegate(null);
        }
        this.pruneScrapViews();
    }

    private void pruneScrapViews() {
        int maxViews = this.activeViews.length;
        int viewTypeCount = this.viewTypeCount;
        SparseArray<View>[] scrapViews = this.scrapViews;
        for (int i2 = 0; i2 < viewTypeCount; ++i2) {
            SparseArray<View> scrapPile = scrapViews[i2];
            int size = scrapPile.size();
            int extras = size - maxViews;
            --size;
            for (int j = 0; j < extras; ++j) {
                scrapPile.remove(scrapPile.keyAt(size--));
            }
        }
    }

    static View retrieveFromScrap(SparseArray<View> scrapViews, int position) {
        int size = scrapViews.size();
        if (size > 0) {
            for (int i2 = 0; i2 < size; ++i2) {
                int fromPosition = scrapViews.keyAt(i2);
                View view = (View)scrapViews.get(fromPosition);
                if (fromPosition != position) continue;
                scrapViews.remove(fromPosition);
                return view;
            }
            int index = size - 1;
            View r = (View)scrapViews.valueAt(index);
            scrapViews.remove(scrapViews.keyAt(index));
            return r;
        }
        return null;
    }
}

