/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.widget.RelativeLayout;
import com.yy.mobile.util.log.MLog;
import com.yymobile.baseapi.R;

public class RoundRectRelativeLayout
extends RelativeLayout {
    private static final String TAG = "RoundRectRelativeLayout";
    private float[] rect;
    private Path path;
    private Paint paint;

    public RoundRectRelativeLayout(Context context) {
        this(context, null);
    }

    public RoundRectRelativeLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RoundRectRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    @RequiresApi(api=21)
    public RoundRectRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        if (attrs == null) {
            return;
        }
        TypedArray attr = context.obtainStyledAttributes(attrs, R.styleable.OnepieceRoundRectRelativeLayout, defStyleAttr, defStyleRes);
        if (attr == null) {
            return;
        }
        try {
            int radius = (int)attr.getDimension(R.styleable.OnepieceRoundRectRelativeLayout_round_radius, 5.0f);
            MLog.debug((Object)TAG, (String)("radius:" + radius), (Object[])new Object[0]);
            if (this.rect == null) {
                this.rect = new float[]{radius, radius, radius, radius, radius, radius, radius, radius};
            }
        }
        catch (Resources.NotFoundException e2) {
            MLog.error((Object)TAG, (Throwable)e2);
        }
        finally {
            attr.recycle();
        }
    }

    public void setRadius(int radius) {
        MLog.debug((Object)TAG, (String)("radius:" + radius), (Object[])new Object[0]);
        this.rect = (float[])(radius <= 0 ? null : new float[]{radius, radius, radius, radius, radius, radius, radius, radius});
    }

    protected void dispatchDraw(Canvas canvas) {
        canvas.saveLayer(new RectF(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight()), null, 31);
        super.dispatchDraw(canvas);
        if (this.rect != null) {
            if (this.path == null) {
                int width = this.getWidth();
                int height = this.getHeight();
                this.path = new Path();
                RectF bound = new RectF(0.0f, 0.0f, (float)width, (float)height);
                this.path.addRoundRect(bound, this.rect, Path.Direction.CW);
            }
            if (this.paint == null) {
                this.paint = new Paint();
                this.paint.setAntiAlias(true);
                this.paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
            }
            canvas.drawPath(this.path, this.paint);
        }
        canvas.restore();
    }
}

