/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.os.HandlerThread;
import android.os.Message;
import android.support.v4.widget.ScrollerCompat;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.log.MLog;
import com.yymobile.baseapi.R;

public class NumberPickerView
extends View {
    private static final int DEFAULT_TEXT_COLOR_NORMAL = -13421773;
    private static final int DEFAULT_TEXT_COLOR_SELECTED = -695533;
    private static final int DEFAULT_TEXT_SIZE_NORMAL_SP = 14;
    private static final int DEFAULT_TEXT_SIZE_SELECTED_SP = 16;
    private static final int DEFAULT_TEXT_SIZE_HINT_SP = 14;
    private static final int DEFAULT_MARGIN_START_OF_HINT_DP = 8;
    private static final int DEFAULT_MARGIN_END_OF_HINT_DP = 8;
    private static final int DEFAULT_DIVIDER_COLOR = -695533;
    private static final int DEFAULT_DIVIDER_HEIGHT = 2;
    private static final int DEFAULT_DIVIDER_MARGIN_HORIZONTAL = 0;
    private static final int DEFAULT_SHOW_COUNT = 3;
    private static final int DEFAULT_ITEM_PADDING_DP_H = 5;
    private static final int DEFAULT_ITEM_PADDING_DP_V = 2;
    private static final int HANDLER_WHAT_REFRESH = 1;
    private static final int HANDLER_WHAT_LISTENER_VALUE_CHANGED = 2;
    private static final int HANDLER_WHAT_REQUEST_LAYOUT = 3;
    private static final int HANDLER_INTERVAL_REFRESH = 32;
    private static final int DEFAULT_INTERVAL_REVISE_DURATION = 300;
    private static final int DEFAULT_MIN_SCROLL_BY_INDEX_DURATION = 300;
    private static final int DEFAULT_MAX_SCROLL_BY_INDEX_DURATION = 600;
    private static final String TEXT_ELLIPSIZE_START = "start";
    private static final String TEXT_ELLIPSIZE_MIDDLE = "middle";
    private static final String TEXT_ELLIPSIZE_END = "end";
    private static final boolean DEFAULT_SHOW_DIVIDER = true;
    private static final boolean DEFAULT_WRAP_SELECTOR_WHEEL = true;
    private static final boolean DEFAULT_CURRENT_ITEM_INDEX_EFFECT = false;
    private static final boolean DEFAULT_RESPOND_CHANGE_ON_DETACH = false;
    private static final boolean DEFAULT_RESPOND_CHANGE_IN_MAIN_THREAD = true;
    private static final String TAG = "NumberPickerView";
    private int mTextColorNormal = -13421773;
    private int mTextColorSelected = -695533;
    private int mTextColorHint = -695533;
    private int mTextSizeNormal = 0;
    private int mTextSizeSelected = 0;
    private int mTextSizeHint = 0;
    private int mWidthOfHintText = 0;
    private int mWidthOfAlterHint = 0;
    private int mMarginStartOfHint = 0;
    private int mMarginEndOfHint = 0;
    private int mItemPaddingVertical = 0;
    private int mItemPaddingHorizontal = 0;
    private int mDividerColor = -695533;
    private int mDividerHeight = 2;
    private int mDividerMarginL = 0;
    private int mDividerMarginR = 0;
    private int mShowCount = 3;
    private int mDividerIndex0 = 0;
    private int mDividerIndex1 = 0;
    private int mMinShowIndex = -1;
    private int mMaxShowIndex = -1;
    private int mMinValue = 0;
    private int mMaxValue = 0;
    private int mMaxWidthOfDisplayedValues = 0;
    private int mMaxHeightOfDisplayedValues = 0;
    private int mMaxWidthOfAlterArrayWithMeasureHint = 0;
    private int mMaxWidthOfAlterArrayWithoutMeasureHint = 0;
    private int mPrevPickedIndex = 0;
    private int mMiniVelocityFling = 150;
    private int mScaledTouchSlop = 8;
    private String mHintText;
    private String mTextEllipsize;
    private String mEmptyItemHint;
    private String mAlterHint;
    private float mFriction = 1.0f;
    private float mTextSizeNormalCenterYOffset = 0.0f;
    private float mTextSizeSelectedCenterYOffset = 0.0f;
    private float mTextSizeHintCenterYOffset = 0.0f;
    private boolean mShowDivider = true;
    private boolean mWrapSelectorWheel = true;
    private boolean mCurrentItemIndexEffect = false;
    private boolean mHasInit = false;
    private boolean mWrapSelectorWheelCheck = true;
    private boolean mPendingWrapToLinear = false;
    private boolean mRespondChangeOnDetach = false;
    private boolean mRespondChangeInMainThread = true;
    private ScrollerCompat mScroller;
    private VelocityTracker mVelocityTracker;
    private Paint mPaintDivider = new Paint();
    private TextPaint mPaintText = new TextPaint();
    private Paint mPaintHint = new Paint();
    private String[] mDisplayedValues;
    private CharSequence[] mAlterTextArrayWithMeasureHint;
    private CharSequence[] mAlterTextArrayWithoutMeasureHint;
    private HandlerThread mHandlerThread;
    private SafeDispatchHandler mHandlerInNewThread;
    private SafeDispatchHandler mHandlerInMainThread;
    private OnValueChangeListenerRelativeToRaw mOnValueChangeListenerRaw;
    private OnValueChangeListener mOnValueChangeListener;
    private OnScrollListener mOnScrollListener;
    private OnValueChangeListenerInScrolling mOnValueChangeListenerInScrolling;
    private int mScrollState = 0;
    private int mInScrollingPickedOldValue;
    private int mInScrollingPickedNewValue;
    private int mNotWrapLimitYTop;
    private int mNotWrapLimitYBottom;
    private float downYGlobal = 0.0f;
    private float downY = 0.0f;
    private float currY = 0.0f;
    private boolean mFlagMayPress = false;
    private int mViewWidth;
    private int mViewHeight;
    private int mItemHeight;
    private float dividerY0;
    private float dividerY1;
    private float mViewCenterX;
    private int mCurrDrawFirstItemIndex = 0;
    private int mCurrDrawFirstItemY = 0;
    private int mCurrDrawGlobalY = 0;
    private int mSpecModeW = 0;
    private int mSpecModeH = 0;

    public NumberPickerView(Context context) {
        super(context);
        this.init(context);
    }

    public NumberPickerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttr(context, attrs);
        this.init(context);
    }

    public NumberPickerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttr(context, attrs);
        this.init(context);
    }

    private void initAttr(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.NumberPickerView);
        int n = a.getIndexCount();
        for (int i2 = 0; i2 < n; ++i2) {
            int attr = a.getIndex(i2);
            if (attr == R.styleable.NumberPickerView_npv_ShowCount) {
                this.mShowCount = a.getInt(attr, 3);
                continue;
            }
            if (attr == R.styleable.NumberPickerView_npv_DividerColor) {
                this.mDividerColor = a.getColor(attr, -695533);
                continue;
            }
            if (attr == R.styleable.NumberPickerView_npv_DividerHeight) {
                this.mDividerHeight = a.getDimensionPixelSize(attr, 2);
                continue;
            }
            if (attr == R.styleable.NumberPickerView_npv_DividerMarginLeft) {
                this.mDividerMarginL = a.getDimensionPixelSize(attr, 0);
                continue;
            }
            if (attr == R.styleable.NumberPickerView_npv_DividerMarginRight) {
                this.mDividerMarginR = a.getDimensionPixelSize(attr, 0);
                continue;
            }
            if (attr == R.styleable.NumberPickerView_npv_TextArray) {
                this.mDisplayedValues = this.convertCharSequenceArrayToStringArray(a.getTextArray(attr));
                continue;
            }
            if (attr == R.styleable.NumberPickerView_npv_TextColorNormal) {
                this.mTextColorNormal = a.getColor(attr, -13421773);
                continue;
            }
            if (attr == R.styleable.NumberPickerView_npv_TextColorSelected) {
                this.mTextColorSelected = a.getColor(attr, -695533);
                continue;
            }
            if (attr == R.styleable.NumberPickerView_npv_TextColorHint) {
                this.mTextColorHint = a.getColor(attr, -695533);
                continue;
            }
            if (attr == R.styleable.NumberPickerView_npv_TextSizeNormal) {
                this.mTextSizeNormal = a.getDimensionPixelSize(attr, this.sp2px(context, 14.0f));
                continue;
            }
            if (attr == R.styleable.NumberPickerView_npv_TextSizeSelected) {
                this.mTextSizeSelected = a.getDimensionPixelSize(attr, this.sp2px(context, 16.0f));
                continue;
            }
            if (attr == R.styleable.NumberPickerView_npv_TextSizeHint) {
                this.mTextSizeHint = a.getDimensionPixelSize(attr, this.sp2px(context, 14.0f));
                continue;
            }
            if (attr == R.styleable.NumberPickerView_npv_MinValue) {
                this.mMinShowIndex = a.getInteger(attr, 0);
                continue;
            }
            if (attr == R.styleable.NumberPickerView_npv_MaxValue) {
                this.mMaxShowIndex = a.getInteger(attr, 0);
                continue;
            }
            if (attr == R.styleable.NumberPickerView_npv_WrapSelectorWheel) {
                this.mWrapSelectorWheel = a.getBoolean(attr, true);
                continue;
            }
            if (attr == R.styleable.NumberPickerView_npv_ShowDivider) {
                this.mShowDivider = a.getBoolean(attr, true);
                continue;
            }
            if (attr == R.styleable.NumberPickerView_npv_HintText) {
                this.mHintText = a.getString(attr);
                continue;
            }
            if (attr == R.styleable.NumberPickerView_npv_AlternativeHint) {
                this.mAlterHint = a.getString(attr);
                continue;
            }
            if (attr == R.styleable.NumberPickerView_npv_EmptyItemHint) {
                this.mEmptyItemHint = a.getString(attr);
                continue;
            }
            if (attr == R.styleable.NumberPickerView_npv_MarginStartOfHint) {
                this.mMarginStartOfHint = a.getDimensionPixelSize(attr, this.dp2px(context, 8.0f));
                continue;
            }
            if (attr == R.styleable.NumberPickerView_npv_MarginEndOfHint) {
                this.mMarginEndOfHint = a.getDimensionPixelSize(attr, this.dp2px(context, 8.0f));
                continue;
            }
            if (attr == R.styleable.NumberPickerView_npv_ItemPaddingVertical) {
                this.mItemPaddingVertical = a.getDimensionPixelSize(attr, this.dp2px(context, 2.0f));
                continue;
            }
            if (attr == R.styleable.NumberPickerView_npv_ItemPaddingHorizontal) {
                this.mItemPaddingHorizontal = a.getDimensionPixelSize(attr, this.dp2px(context, 5.0f));
                continue;
            }
            if (attr == R.styleable.NumberPickerView_npv_AlternativeTextArrayWithMeasureHint) {
                this.mAlterTextArrayWithMeasureHint = a.getTextArray(attr);
                continue;
            }
            if (attr == R.styleable.NumberPickerView_npv_AlternativeTextArrayWithoutMeasureHint) {
                this.mAlterTextArrayWithoutMeasureHint = a.getTextArray(attr);
                continue;
            }
            if (attr == R.styleable.NumberPickerView_npv_RespondChangeOnDetached) {
                this.mRespondChangeOnDetach = a.getBoolean(attr, false);
                continue;
            }
            if (attr == R.styleable.NumberPickerView_npv_RespondChangeInMainThread) {
                this.mRespondChangeInMainThread = a.getBoolean(attr, true);
                continue;
            }
            if (attr != R.styleable.NumberPickerView_npv_TextEllipsize) continue;
            this.mTextEllipsize = a.getString(attr);
        }
        a.recycle();
    }

    private void init(Context context) {
        this.mScroller = ScrollerCompat.create((Context)context);
        this.mMiniVelocityFling = ViewConfiguration.get((Context)this.getContext()).getScaledMinimumFlingVelocity();
        this.mScaledTouchSlop = ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop();
        if (this.mTextSizeNormal == 0) {
            this.mTextSizeNormal = this.sp2px(context, 14.0f);
        }
        if (this.mTextSizeSelected == 0) {
            this.mTextSizeSelected = this.sp2px(context, 16.0f);
        }
        if (this.mTextSizeHint == 0) {
            this.mTextSizeHint = this.sp2px(context, 14.0f);
        }
        if (this.mMarginStartOfHint == 0) {
            this.mMarginStartOfHint = this.dp2px(context, 8.0f);
        }
        if (this.mMarginEndOfHint == 0) {
            this.mMarginEndOfHint = this.dp2px(context, 8.0f);
        }
        this.mPaintDivider.setColor(this.mDividerColor);
        this.mPaintDivider.setAntiAlias(true);
        this.mPaintDivider.setStyle(Paint.Style.STROKE);
        this.mPaintDivider.setStrokeWidth((float)this.mDividerHeight);
        this.mPaintText.setColor(this.mTextColorNormal);
        this.mPaintText.setAntiAlias(true);
        this.mPaintText.setTextAlign(Paint.Align.CENTER);
        this.mPaintHint.setColor(this.mTextColorHint);
        this.mPaintHint.setAntiAlias(true);
        this.mPaintHint.setTextAlign(Paint.Align.CENTER);
        this.mPaintHint.setTextSize((float)this.mTextSizeHint);
        if (this.mShowCount % 2 == 0) {
            ++this.mShowCount;
        }
        if (this.mMinShowIndex == -1 || this.mMaxShowIndex == -1) {
            this.updateValueForInit();
        }
        this.initHandler();
    }

    @SuppressLint(value={"HandlerLeak"})
    private void initHandler() {
        this.mHandlerThread = new HandlerThread("HandlerThread-For-Refreshing");
        this.mHandlerThread.start();
        this.mHandlerInNewThread = new SafeDispatchHandler(this.mHandlerThread.getLooper()){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        int willPickIndex;
                        if (!NumberPickerView.this.mScroller.isFinished()) {
                            if (NumberPickerView.this.mScrollState == 0) {
                                NumberPickerView.this.onScrollStateChange(1);
                            }
                            NumberPickerView.this.mHandlerInNewThread.sendMessageDelayed(NumberPickerView.this.getMsg(1, 0, 0, msg.obj), 32L);
                            break;
                        }
                        int duration = 0;
                        if (NumberPickerView.this.mCurrDrawFirstItemY != 0) {
                            if (NumberPickerView.this.mScrollState == 0) {
                                NumberPickerView.this.onScrollStateChange(1);
                            }
                            if (NumberPickerView.this.mCurrDrawFirstItemY < -NumberPickerView.this.mItemHeight / 2) {
                                duration = (int)(300.0f * (float)(NumberPickerView.this.mItemHeight + NumberPickerView.this.mCurrDrawFirstItemY) / (float)NumberPickerView.this.mItemHeight);
                                NumberPickerView.this.mScroller.startScroll(0, NumberPickerView.this.mCurrDrawGlobalY, 0, NumberPickerView.this.mItemHeight + NumberPickerView.this.mCurrDrawFirstItemY, duration * 3);
                                willPickIndex = NumberPickerView.this.getWillPickIndexByGlobalY(NumberPickerView.this.mCurrDrawGlobalY + NumberPickerView.this.mItemHeight + NumberPickerView.this.mCurrDrawFirstItemY);
                            } else {
                                duration = (int)(300.0f * (float)(-NumberPickerView.this.mCurrDrawFirstItemY) / (float)NumberPickerView.this.mItemHeight);
                                NumberPickerView.this.mScroller.startScroll(0, NumberPickerView.this.mCurrDrawGlobalY, 0, NumberPickerView.this.mCurrDrawFirstItemY, duration * 3);
                                willPickIndex = NumberPickerView.this.getWillPickIndexByGlobalY(NumberPickerView.this.mCurrDrawGlobalY + NumberPickerView.this.mCurrDrawFirstItemY);
                            }
                            NumberPickerView.this.postInvalidate();
                        } else {
                            NumberPickerView.this.onScrollStateChange(0);
                            willPickIndex = NumberPickerView.this.getWillPickIndexByGlobalY(NumberPickerView.this.mCurrDrawGlobalY);
                        }
                        Message changeMsg = NumberPickerView.this.getMsg(2, NumberPickerView.this.mPrevPickedIndex, willPickIndex, msg.obj);
                        if (NumberPickerView.this.mRespondChangeInMainThread) {
                            NumberPickerView.this.mHandlerInMainThread.sendMessageDelayed(changeMsg, (long)(duration * 2));
                            break;
                        }
                        NumberPickerView.this.mHandlerInNewThread.sendMessageDelayed(changeMsg, (long)(duration * 2));
                        break;
                    }
                    case 2: {
                        NumberPickerView.this.respondPickedValueChanged(msg.arg1, msg.arg2, msg.obj);
                        break;
                    }
                }
            }
        };
        this.mHandlerInMainThread = new SafeDispatchHandler(){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                switch (msg.what) {
                    case 3: {
                        NumberPickerView.this.requestLayout();
                        break;
                    }
                    case 2: {
                        NumberPickerView.this.respondPickedValueChanged(msg.arg1, msg.arg2, msg.obj);
                        break;
                    }
                }
            }
        };
    }

    private void respondPickedValueChangedInScrolling(int oldVal, int newVal) {
        this.mOnValueChangeListenerInScrolling.onValueChangeInScrolling(this, oldVal, newVal);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.updateMaxWHOfDisplayedValues(false);
        this.setMeasuredDimension(this.measureWidth(widthMeasureSpec), this.measureHeight(heightMeasureSpec));
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mViewWidth = w;
        this.mViewHeight = h;
        this.mItemHeight = this.mViewHeight / this.mShowCount;
        this.mViewCenterX = (float)(this.mViewWidth + this.getPaddingLeft() - this.getPaddingRight()) / 2.0f;
        int defaultValue = 0;
        if (this.getOneRecycleSize() > 1) {
            defaultValue = this.mHasInit ? this.getValue() - this.mMinValue : (this.mCurrentItemIndexEffect ? this.mCurrDrawFirstItemIndex + (this.mShowCount - 1) / 2 : 0);
        }
        this.correctPositionByDefaultValue(defaultValue, this.mWrapSelectorWheel && this.mWrapSelectorWheelCheck);
        this.updateFontAttr();
        this.updateNotWrapYLimit();
        this.updateDividerAttr();
        this.mHasInit = true;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mHandlerThread == null || !this.mHandlerThread.isAlive()) {
            this.initHandler();
        }
    }

    protected void onDetachedFromWindow() {
        int currPickedIndex;
        super.onDetachedFromWindow();
        this.mHandlerThread.quit();
        if (this.mItemHeight == 0) {
            return;
        }
        if (!this.mScroller.isFinished()) {
            this.mScroller.abortAnimation();
            this.mCurrDrawGlobalY = this.mScroller.getCurrY();
            this.calculateFirstItemParameterByGlobalY();
            if (this.mCurrDrawFirstItemY != 0) {
                this.mCurrDrawGlobalY = this.mCurrDrawFirstItemY < -this.mItemHeight / 2 ? this.mCurrDrawGlobalY + this.mItemHeight + this.mCurrDrawFirstItemY : (this.mCurrDrawGlobalY += this.mCurrDrawFirstItemY);
                this.calculateFirstItemParameterByGlobalY();
            }
            this.onScrollStateChange(0);
        }
        if ((currPickedIndex = this.getWillPickIndexByGlobalY(this.mCurrDrawGlobalY)) != this.mPrevPickedIndex && this.mRespondChangeOnDetach) {
            try {
                if (this.mOnValueChangeListener != null) {
                    this.mOnValueChangeListener.onValueChange(this, this.mPrevPickedIndex + this.mMinValue, currPickedIndex + this.mMinValue);
                }
                if (this.mOnValueChangeListenerRaw != null) {
                    this.mOnValueChangeListenerRaw.onValueChangeRelativeToRaw(this, this.mPrevPickedIndex, currPickedIndex, this.mDisplayedValues);
                }
            }
            catch (Exception e2) {
                MLog.error((Object)TAG, (Throwable)e2);
            }
        }
        this.mPrevPickedIndex = currPickedIndex;
    }

    public int getOneRecycleSize() {
        return this.mMaxShowIndex - this.mMinShowIndex + 1;
    }

    public int getRawContentSize() {
        if (this.mDisplayedValues != null) {
            return this.mDisplayedValues.length;
        }
        return 0;
    }

    public void setDisplayedValuesAndPickedIndex(String[] newDisplayedValues, int pickedIndex, boolean needRefresh) {
        this.stopScrolling();
        if (newDisplayedValues == null) {
            throw new IllegalArgumentException("newDisplayedValues should not be null.");
        }
        if (pickedIndex < 0) {
            throw new IllegalArgumentException("pickedIndex should not be negative, now pickedIndex is " + pickedIndex);
        }
        this.updateContent(newDisplayedValues);
        this.updateMaxWHOfDisplayedValues(true);
        this.updateNotWrapYLimit();
        this.updateValue();
        this.mPrevPickedIndex = pickedIndex + this.mMinShowIndex;
        this.correctPositionByDefaultValue(pickedIndex, this.mWrapSelectorWheel && this.mWrapSelectorWheelCheck);
        if (needRefresh) {
            this.mHandlerInNewThread.sendMessageDelayed(this.getMsg(1), 0L);
            this.postInvalidate();
        }
    }

    public void setDisplayedValues(String[] newDisplayedValues, boolean needRefresh) {
        this.setDisplayedValuesAndPickedIndex(newDisplayedValues, 0, needRefresh);
    }

    public String[] getDisplayedValues() {
        return this.mDisplayedValues;
    }

    public void setDisplayedValues(String[] newDisplayedValues) {
        this.stopRefreshing();
        this.stopScrolling();
        if (newDisplayedValues == null) {
            throw new IllegalArgumentException("newDisplayedValues should not be null.");
        }
        if (this.mMaxValue - this.mMinValue + 1 > newDisplayedValues.length) {
            throw new IllegalArgumentException("mMaxValue - mMinValue + 1 should not be greater than mDisplayedValues.length, now ((mMaxValue - mMinValue + 1) is " + (this.mMaxValue - this.mMinValue + 1) + " newDisplayedValues.length is " + newDisplayedValues.length + ", you need to set MaxValue and MinValue before setDisplayedValues(String[])");
        }
        this.updateContent(newDisplayedValues);
        this.updateMaxWHOfDisplayedValues(true);
        this.mPrevPickedIndex = 0 + this.mMinShowIndex;
        this.correctPositionByDefaultValue(0, this.mWrapSelectorWheel && this.mWrapSelectorWheelCheck);
        this.postInvalidate();
        this.mHandlerInMainThread.sendEmptyMessage(3);
    }

    public void smoothScrollToValue(int toValue) {
        this.smoothScrollToValue(this.getValue(), toValue, true);
    }

    public void smoothScrollToValue(int toValue, boolean needRespond) {
        this.smoothScrollToValue(this.getValue(), toValue, needRespond);
    }

    public void smoothScrollToValue(int fromValue, int toValue) {
        this.smoothScrollToValue(fromValue, toValue, true);
    }

    public void smoothScrollToValue(int fromValue, int toValue, boolean needRespond) {
        int deltaIndex;
        fromValue = this.refineValueByLimit(fromValue, this.mMinValue, this.mMaxValue, this.mWrapSelectorWheel && this.mWrapSelectorWheelCheck);
        toValue = this.refineValueByLimit(toValue, this.mMinValue, this.mMaxValue, this.mWrapSelectorWheel && this.mWrapSelectorWheelCheck);
        if (this.mWrapSelectorWheel && this.mWrapSelectorWheelCheck) {
            deltaIndex = toValue - fromValue;
            int halfOneRecycleSize = this.getOneRecycleSize() / 2;
            if (deltaIndex < -halfOneRecycleSize || halfOneRecycleSize < deltaIndex) {
                deltaIndex = deltaIndex > 0 ? deltaIndex - this.getOneRecycleSize() : deltaIndex + this.getOneRecycleSize();
            }
        } else {
            deltaIndex = toValue - fromValue;
        }
        this.setValue(fromValue);
        if (fromValue == toValue) {
            return;
        }
        this.scrollByIndexSmoothly(deltaIndex, needRespond);
    }

    public void refreshByNewDisplayedValues(String[] display) {
        int oldMaxValue;
        int oldSpan;
        int newMaxValue = display.length - 1;
        int minValue = this.getMinValue();
        int newSpan = newMaxValue - minValue + 1;
        if (newSpan > (oldSpan = (oldMaxValue = this.getMaxValue()) - minValue + 1)) {
            this.setDisplayedValues(display);
            this.setMaxValue(newMaxValue);
        } else {
            this.setMaxValue(newMaxValue);
            this.setDisplayedValues(display);
        }
    }

    private void respondPickedValueChanged(int oldVal, int newVal, Object respondChange) {
        this.onScrollStateChange(0);
        if (oldVal != newVal && (respondChange == null || !(respondChange instanceof Boolean) || ((Boolean)respondChange).booleanValue())) {
            if (this.mOnValueChangeListener != null) {
                this.mOnValueChangeListener.onValueChange(this, oldVal + this.mMinValue, newVal + this.mMinValue);
            }
            if (this.mOnValueChangeListenerRaw != null) {
                this.mOnValueChangeListenerRaw.onValueChangeRelativeToRaw(this, oldVal, newVal, this.mDisplayedValues);
            }
        }
        this.mPrevPickedIndex = newVal;
        if (this.mPendingWrapToLinear) {
            this.mPendingWrapToLinear = false;
            this.internalSetWrapToLinear();
        }
    }

    private void scrollByIndexSmoothly(int deltaIndex) {
        this.scrollByIndexSmoothly(deltaIndex, true);
    }

    private void scrollByIndexSmoothly(int deltaIndex, boolean needRespond) {
        int duration;
        int dy;
        if (!this.mWrapSelectorWheel || !this.mWrapSelectorWheelCheck) {
            int willPickRawIndex = this.getPickedIndexRelativeToRaw();
            if (willPickRawIndex + deltaIndex > this.mMaxShowIndex) {
                deltaIndex = this.mMaxShowIndex - willPickRawIndex;
            } else if (willPickRawIndex + deltaIndex < this.mMinShowIndex) {
                deltaIndex = this.mMinShowIndex - willPickRawIndex;
            }
        }
        if (this.mCurrDrawFirstItemY < -this.mItemHeight / 2) {
            dy = this.mItemHeight + this.mCurrDrawFirstItemY;
            duration = (int)(300.0f * (float)(this.mItemHeight + this.mCurrDrawFirstItemY) / (float)this.mItemHeight);
            duration = deltaIndex < 0 ? -duration - deltaIndex * 300 : (duration += deltaIndex * 300);
        } else {
            dy = this.mCurrDrawFirstItemY;
            duration = (int)(300.0f * (float)(-this.mCurrDrawFirstItemY) / (float)this.mItemHeight);
            duration = deltaIndex < 0 ? (duration -= deltaIndex * 300) : (duration += deltaIndex * 300);
        }
        dy += deltaIndex * this.mItemHeight;
        if (duration < 300) {
            duration = 300;
        }
        if (duration > 600) {
            duration = 600;
        }
        this.mScroller.startScroll(0, this.mCurrDrawGlobalY, 0, dy, duration);
        if (needRespond) {
            this.mHandlerInNewThread.sendMessageDelayed(this.getMsg(1), (long)(duration / 4));
        } else {
            this.mHandlerInNewThread.sendMessageDelayed(this.getMsg(1, 0, 0, new Boolean(needRespond)), (long)(duration / 4));
        }
        this.postInvalidate();
    }

    public int getMinValue() {
        return this.mMinValue;
    }

    public void setMinValue(int minValue) {
        this.mMinValue = minValue;
        this.mMinShowIndex = 0;
        this.updateNotWrapYLimit();
    }

    public int getMaxValue() {
        return this.mMaxValue;
    }

    public void setMaxValue(int maxValue) {
        if (this.mDisplayedValues == null) {
            throw new NullPointerException("mDisplayedValues should not be null");
        }
        if (maxValue - this.mMinValue + 1 > this.mDisplayedValues.length) {
            throw new IllegalArgumentException("(maxValue - mMinValue + 1) should not be greater than mDisplayedValues.length now  (maxValue - mMinValue + 1) is " + (maxValue - this.mMinValue + 1) + " and mDisplayedValues.length is " + this.mDisplayedValues.length);
        }
        this.mMaxValue = maxValue;
        this.mMaxShowIndex = this.mMaxValue - this.mMinValue + this.mMinShowIndex;
        this.setMinAndMaxShowIndex(this.mMinShowIndex, this.mMaxShowIndex);
        this.updateNotWrapYLimit();
    }

    public int getValue() {
        return this.getPickedIndexRelativeToRaw() + this.mMinValue;
    }

    public void setValue(int value) {
        if (value < this.mMinValue) {
            throw new IllegalArgumentException("should not set a value less than mMinValue, value is " + value);
        }
        if (value > this.mMaxValue) {
            throw new IllegalArgumentException("should not set a value greater than mMaxValue, value is " + value);
        }
        this.setPickedIndexRelativeToRaw(value - this.mMinValue);
    }

    public String getContentByCurrValue() {
        return this.mDisplayedValues[this.getValue() - this.mMinValue];
    }

    public boolean getWrapSelectorWheel() {
        return this.mWrapSelectorWheel;
    }

    public void setWrapSelectorWheel(boolean wrapSelectorWheel) {
        if (this.mWrapSelectorWheel != wrapSelectorWheel) {
            if (!wrapSelectorWheel) {
                if (this.mScrollState == 0) {
                    this.internalSetWrapToLinear();
                } else {
                    this.mPendingWrapToLinear = true;
                }
            } else {
                this.mWrapSelectorWheel = wrapSelectorWheel;
                this.updateWrapStateByContent();
                this.postInvalidate();
            }
        }
    }

    public boolean getWrapSelectorWheelAbsolutely() {
        return this.mWrapSelectorWheel && this.mWrapSelectorWheelCheck;
    }

    public void setHintText(String hintText) {
        if (this.isStringEqual(this.mHintText, hintText)) {
            return;
        }
        this.mHintText = hintText;
        this.mTextSizeHintCenterYOffset = this.getTextCenterYOffset(this.mPaintHint.getFontMetrics());
        this.mWidthOfHintText = this.getTextWidth(this.mHintText, this.mPaintHint);
        this.mHandlerInMainThread.sendEmptyMessage(3);
    }

    public void setPickedIndexRelativeToMin(int pickedIndexToMin) {
        if (0 <= pickedIndexToMin && pickedIndexToMin < this.getOneRecycleSize()) {
            this.mPrevPickedIndex = pickedIndexToMin + this.mMinShowIndex;
            this.correctPositionByDefaultValue(pickedIndexToMin, this.mWrapSelectorWheel && this.mWrapSelectorWheelCheck);
            this.postInvalidate();
        }
    }

    public void setNormalTextColor(int normalTextColor) {
        if (this.mTextColorNormal == normalTextColor) {
            return;
        }
        this.mTextColorNormal = normalTextColor;
        this.postInvalidate();
    }

    public void setSelectedTextColor(int selectedTextColor) {
        if (this.mTextColorSelected == selectedTextColor) {
            return;
        }
        this.mTextColorSelected = selectedTextColor;
        this.postInvalidate();
    }

    public void setHintTextColor(int hintTextColor) {
        if (this.mTextColorHint == hintTextColor) {
            return;
        }
        this.mTextColorHint = hintTextColor;
        this.mPaintHint.setColor(this.mTextColorHint);
        this.postInvalidate();
    }

    public void setDividerColor(int dividerColor) {
        if (this.mDividerColor == dividerColor) {
            return;
        }
        this.mDividerColor = dividerColor;
        this.mPaintDivider.setColor(this.mDividerColor);
        this.postInvalidate();
    }

    public int getPickedIndexRelativeToRaw() {
        int willPickIndex = this.mCurrDrawFirstItemY != 0 ? (this.mCurrDrawFirstItemY < -this.mItemHeight / 2 ? this.getWillPickIndexByGlobalY(this.mCurrDrawGlobalY + this.mItemHeight + this.mCurrDrawFirstItemY) : this.getWillPickIndexByGlobalY(this.mCurrDrawGlobalY + this.mCurrDrawFirstItemY)) : this.getWillPickIndexByGlobalY(this.mCurrDrawGlobalY);
        return willPickIndex;
    }

    public void setPickedIndexRelativeToRaw(int pickedIndexToRaw) {
        if (this.mMinShowIndex > -1 && this.mMinShowIndex <= pickedIndexToRaw && pickedIndexToRaw <= this.mMaxShowIndex) {
            this.mPrevPickedIndex = pickedIndexToRaw;
            this.correctPositionByDefaultValue(pickedIndexToRaw - this.mMinShowIndex, this.mWrapSelectorWheel && this.mWrapSelectorWheelCheck);
            this.postInvalidate();
        }
    }

    public void setMinAndMaxShowIndex(int minShowIndex, int maxShowIndex) {
        this.setMinAndMaxShowIndex(minShowIndex, maxShowIndex, true);
    }

    public void setMinAndMaxShowIndex(int minShowIndex, int maxShowIndex, boolean needRefresh) {
        if (minShowIndex > maxShowIndex) {
            throw new IllegalArgumentException("minShowIndex should be less than maxShowIndex, minShowIndex is " + minShowIndex + ", maxShowIndex is " + maxShowIndex + ".");
        }
        if (this.mDisplayedValues == null) {
            throw new IllegalArgumentException("mDisplayedValues should not be null, you need to set mDisplayedValues first.");
        }
        if (minShowIndex < 0) {
            throw new IllegalArgumentException("minShowIndex should not be less than 0, now minShowIndex is " + minShowIndex);
        }
        if (minShowIndex > this.mDisplayedValues.length - 1) {
            throw new IllegalArgumentException("minShowIndex should not be greater than (mDisplayedValues.length - 1), now (mDisplayedValues.length - 1) is " + (this.mDisplayedValues.length - 1) + " minShowIndex is " + minShowIndex);
        }
        if (maxShowIndex < 0) {
            throw new IllegalArgumentException("maxShowIndex should not be less than 0, now maxShowIndex is " + maxShowIndex);
        }
        if (maxShowIndex > this.mDisplayedValues.length - 1) {
            throw new IllegalArgumentException("maxShowIndex should not be greater than (mDisplayedValues.length - 1), now (mDisplayedValues.length - 1) is " + (this.mDisplayedValues.length - 1) + " maxShowIndex is " + maxShowIndex);
        }
        this.mMinShowIndex = minShowIndex;
        this.mMaxShowIndex = maxShowIndex;
        if (needRefresh) {
            this.mPrevPickedIndex = 0 + this.mMinShowIndex;
            this.correctPositionByDefaultValue(0, this.mWrapSelectorWheel && this.mWrapSelectorWheelCheck);
            this.postInvalidate();
        }
    }

    public void setFriction(float friction) {
        if (friction <= 0.0f) {
            throw new IllegalArgumentException("you should set a a positive float friction, now friction is " + friction);
        }
        ViewConfiguration.get((Context)this.getContext());
        this.mFriction = ViewConfiguration.getScrollFriction() / friction;
    }

    private void onScrollStateChange(int scrollState) {
        if (this.mScrollState == scrollState) {
            return;
        }
        this.mScrollState = scrollState;
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScrollStateChange(this, scrollState);
        }
    }

    public void setOnScrollListener(OnScrollListener listener) {
        this.mOnScrollListener = listener;
    }

    public void setOnValueChangedListener(OnValueChangeListener listener) {
        this.mOnValueChangeListener = listener;
    }

    public void setOnValueChangedListenerRelativeToRaw(OnValueChangeListenerRelativeToRaw listener) {
        this.mOnValueChangeListenerRaw = listener;
    }

    public void setOnValueChangeListenerInScrolling(OnValueChangeListenerInScrolling listener) {
        this.mOnValueChangeListenerInScrolling = listener;
    }

    public void setContentTextTypeface(Typeface typeface) {
        this.mPaintText.setTypeface(typeface);
    }

    public void setHintTextTypeface(Typeface typeface) {
        this.mPaintHint.setTypeface(typeface);
    }

    private int getWillPickIndexByGlobalY(int globalY) {
        if (this.mItemHeight == 0) {
            return 0;
        }
        int willPickIndex = globalY / this.mItemHeight + this.mShowCount / 2;
        int index = this.getIndexByRawIndex(willPickIndex, this.getOneRecycleSize(), this.mWrapSelectorWheel && this.mWrapSelectorWheelCheck);
        if (0 <= index && index < this.getOneRecycleSize()) {
            return index + this.mMinShowIndex;
        }
        throw new IllegalArgumentException("getWillPickIndexByGlobalY illegal index : " + index + " getOneRecycleSize() : " + this.getOneRecycleSize() + " mWrapSelectorWheel : " + this.mWrapSelectorWheel);
    }

    private int getIndexByRawIndex(int index, int size, boolean wrap) {
        if (size <= 0) {
            return 0;
        }
        if (wrap) {
            if ((index %= size) < 0) {
                index += size;
            }
            return index;
        }
        return index;
    }

    private void internalSetWrapToLinear() {
        int rawIndex = this.getPickedIndexRelativeToRaw();
        this.correctPositionByDefaultValue(rawIndex - this.mMinShowIndex, false);
        this.mWrapSelectorWheel = false;
        this.postInvalidate();
    }

    private void updateDividerAttr() {
        this.mDividerIndex0 = this.mShowCount / 2;
        this.mDividerIndex1 = this.mDividerIndex0 + 1;
        this.dividerY0 = this.mDividerIndex0 * this.mViewHeight / this.mShowCount;
        this.dividerY1 = this.mDividerIndex1 * this.mViewHeight / this.mShowCount;
        if (this.mDividerMarginL < 0) {
            this.mDividerMarginL = 0;
        }
        if (this.mDividerMarginR < 0) {
            this.mDividerMarginR = 0;
        }
        if (this.mDividerMarginL + this.mDividerMarginR == 0) {
            return;
        }
        if (this.getPaddingLeft() + this.mDividerMarginL >= this.mViewWidth - this.getPaddingRight() - this.mDividerMarginR) {
            int surplusMargin = this.getPaddingLeft() + this.mDividerMarginL + this.getPaddingRight() + this.mDividerMarginR - this.mViewWidth;
            this.mDividerMarginL = (int)((float)this.mDividerMarginL - (float)surplusMargin * (float)this.mDividerMarginL / (float)(this.mDividerMarginL + this.mDividerMarginR));
            this.mDividerMarginR = (int)((float)this.mDividerMarginR - (float)surplusMargin * (float)this.mDividerMarginR / (float)(this.mDividerMarginL + this.mDividerMarginR));
        }
    }

    private void updateFontAttr() {
        if (this.mTextSizeNormal > this.mItemHeight) {
            this.mTextSizeNormal = this.mItemHeight;
        }
        if (this.mTextSizeSelected > this.mItemHeight) {
            this.mTextSizeSelected = this.mItemHeight;
        }
        if (this.mPaintHint == null) {
            throw new IllegalArgumentException("mPaintHint should not be null.");
        }
        this.mPaintHint.setTextSize((float)this.mTextSizeHint);
        this.mTextSizeHintCenterYOffset = this.getTextCenterYOffset(this.mPaintHint.getFontMetrics());
        this.mWidthOfHintText = this.getTextWidth(this.mHintText, this.mPaintHint);
        if (this.mPaintText == null) {
            throw new IllegalArgumentException("mPaintText should not be null.");
        }
        this.mPaintText.setTextSize((float)this.mTextSizeSelected);
        this.mTextSizeSelectedCenterYOffset = this.getTextCenterYOffset(this.mPaintText.getFontMetrics());
        this.mPaintText.setTextSize((float)this.mTextSizeNormal);
        this.mTextSizeNormalCenterYOffset = this.getTextCenterYOffset(this.mPaintText.getFontMetrics());
    }

    private void updateNotWrapYLimit() {
        this.mNotWrapLimitYTop = 0;
        this.mNotWrapLimitYBottom = -this.mShowCount * this.mItemHeight;
        if (this.mDisplayedValues != null) {
            this.mNotWrapLimitYTop = (this.getOneRecycleSize() - this.mShowCount / 2 - 1) * this.mItemHeight;
            this.mNotWrapLimitYBottom = -(this.mShowCount / 2) * this.mItemHeight;
        }
    }

    private int limitY(int currDrawGlobalYPreferred) {
        if (this.mWrapSelectorWheel && this.mWrapSelectorWheelCheck) {
            return currDrawGlobalYPreferred;
        }
        if (currDrawGlobalYPreferred < this.mNotWrapLimitYBottom) {
            currDrawGlobalYPreferred = this.mNotWrapLimitYBottom;
        } else if (currDrawGlobalYPreferred > this.mNotWrapLimitYTop) {
            currDrawGlobalYPreferred = this.mNotWrapLimitYTop;
        }
        return currDrawGlobalYPreferred;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mItemHeight == 0) {
            return true;
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
        this.currY = event.getY();
        switch (event.getAction()) {
            case 0: {
                this.mFlagMayPress = true;
                this.mHandlerInNewThread.removeMessages(1);
                this.stopScrolling();
                this.downY = this.currY;
                this.downYGlobal = this.mCurrDrawGlobalY;
                this.onScrollStateChange(0);
                this.getParent().requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 2: {
                float spanY = this.downY - this.currY;
                if (!(this.mFlagMayPress && (float)(-this.mScaledTouchSlop) < spanY && spanY < (float)this.mScaledTouchSlop)) {
                    this.mFlagMayPress = false;
                    this.mCurrDrawGlobalY = this.limitY((int)(this.downYGlobal + spanY));
                    this.calculateFirstItemParameterByGlobalY();
                    this.invalidate();
                }
                this.onScrollStateChange(1);
                break;
            }
            case 1: {
                if (this.mFlagMayPress) {
                    this.click(event);
                    break;
                }
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000);
                int velocityY = (int)(velocityTracker.getYVelocity() * this.mFriction);
                if (Math.abs(velocityY) > this.mMiniVelocityFling) {
                    this.mScroller.fling(0, this.mCurrDrawGlobalY, 0, -velocityY, Integer.MIN_VALUE, Integer.MAX_VALUE, this.limitY(Integer.MIN_VALUE), this.limitY(Integer.MAX_VALUE));
                    this.invalidate();
                    this.onScrollStateChange(2);
                }
                this.mHandlerInNewThread.sendMessageDelayed(this.getMsg(1), 0L);
                this.releaseVelocityTracker();
                break;
            }
            case 3: {
                this.downYGlobal = this.mCurrDrawGlobalY;
                this.stopScrolling();
                this.mHandlerInNewThread.sendMessageDelayed(this.getMsg(1), 0L);
                break;
            }
        }
        return true;
    }

    private void click(MotionEvent event) {
        float y = event.getY();
        for (int i2 = 0; i2 < this.mShowCount; ++i2) {
            if (!((float)(this.mItemHeight * i2) <= y) || !(y < (float)(this.mItemHeight * (i2 + 1)))) continue;
            this.clickItem(i2);
            break;
        }
    }

    private void clickItem(int showCountIndex) {
        if (0 <= showCountIndex && showCountIndex < this.mShowCount) {
            this.scrollByIndexSmoothly(showCountIndex - this.mShowCount / 2);
        }
    }

    private float getTextCenterYOffset(Paint.FontMetrics fontMetrics) {
        if (fontMetrics == null) {
            return 0.0f;
        }
        return Math.abs(fontMetrics.top + fontMetrics.bottom) / 2.0f;
    }

    private void correctPositionByDefaultValue(int defaultPickedIndex, boolean wrap) {
        this.mCurrDrawFirstItemIndex = defaultPickedIndex - (this.mShowCount - 1) / 2;
        this.mCurrDrawFirstItemIndex = this.getIndexByRawIndex(this.mCurrDrawFirstItemIndex, this.getOneRecycleSize(), wrap);
        if (this.mItemHeight == 0) {
            this.mCurrentItemIndexEffect = true;
        } else {
            this.mCurrDrawGlobalY = this.mCurrDrawFirstItemIndex * this.mItemHeight;
            this.mInScrollingPickedOldValue = this.mCurrDrawFirstItemIndex + this.mShowCount / 2;
            this.mInScrollingPickedOldValue %= this.getOneRecycleSize();
            if (this.mInScrollingPickedOldValue < 0) {
                this.mInScrollingPickedOldValue += this.getOneRecycleSize();
            }
            this.mInScrollingPickedNewValue = this.mInScrollingPickedOldValue;
            this.calculateFirstItemParameterByGlobalY();
        }
    }

    public void computeScroll() {
        if (this.mItemHeight == 0) {
            return;
        }
        if (this.mScroller.computeScrollOffset()) {
            this.mCurrDrawGlobalY = this.mScroller.getCurrY();
            this.calculateFirstItemParameterByGlobalY();
            this.postInvalidate();
        }
    }

    private void calculateFirstItemParameterByGlobalY() {
        this.mCurrDrawFirstItemIndex = (int)Math.floor((float)this.mCurrDrawGlobalY / (float)this.mItemHeight);
        this.mCurrDrawFirstItemY = -(this.mCurrDrawGlobalY - this.mCurrDrawFirstItemIndex * this.mItemHeight);
        if (this.mOnValueChangeListenerInScrolling != null) {
            this.mInScrollingPickedNewValue = -this.mCurrDrawFirstItemY > this.mItemHeight / 2 ? this.mCurrDrawFirstItemIndex + 1 + this.mShowCount / 2 : this.mCurrDrawFirstItemIndex + this.mShowCount / 2;
            this.mInScrollingPickedNewValue %= this.getOneRecycleSize();
            if (this.mInScrollingPickedNewValue < 0) {
                this.mInScrollingPickedNewValue += this.getOneRecycleSize();
            }
            if (this.mInScrollingPickedOldValue != this.mInScrollingPickedNewValue) {
                this.respondPickedValueChangedInScrolling(this.mInScrollingPickedNewValue, this.mInScrollingPickedOldValue);
            }
            this.mInScrollingPickedOldValue = this.mInScrollingPickedNewValue;
        }
    }

    private void releaseVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.clear();
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private void updateMaxWHOfDisplayedValues(boolean needRequestLayout) {
        this.updateMaxWidthOfDisplayedValues();
        this.updateMaxHeightOfDisplayedValues();
        if (needRequestLayout && (this.mSpecModeW == Integer.MIN_VALUE || this.mSpecModeH == Integer.MIN_VALUE)) {
            this.mHandlerInMainThread.sendEmptyMessage(3);
        }
    }

    private int measureWidth(int measureSpec) {
        int result;
        int specMode = this.mSpecModeW = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000) {
            result = specSize;
        } else {
            int marginOfHint = Math.max(this.mWidthOfHintText, this.mWidthOfAlterHint) == 0 ? 0 : this.mMarginEndOfHint;
            int gapOfHint = Math.max(this.mWidthOfHintText, this.mWidthOfAlterHint) == 0 ? 0 : this.mMarginStartOfHint;
            int maxWidth = Math.max(this.mMaxWidthOfAlterArrayWithMeasureHint, Math.max(this.mMaxWidthOfDisplayedValues, this.mMaxWidthOfAlterArrayWithoutMeasureHint) + 2 * (gapOfHint + Math.max(this.mWidthOfHintText, this.mWidthOfAlterHint) + marginOfHint + 2 * this.mItemPaddingHorizontal));
            result = this.getPaddingLeft() + this.getPaddingRight() + maxWidth;
            if (specMode == Integer.MIN_VALUE) {
                result = Math.min(result, specSize);
            }
        }
        return result;
    }

    private int measureHeight(int measureSpec) {
        int result;
        int specMode = this.mSpecModeH = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000) {
            result = specSize;
        } else {
            int maxHeight = this.mShowCount * (this.mMaxHeightOfDisplayedValues + 2 * this.mItemPaddingVertical);
            result = this.getPaddingTop() + this.getPaddingBottom() + maxHeight;
            if (specMode == Integer.MIN_VALUE) {
                result = Math.min(result, specSize);
            }
        }
        return result;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawContent(canvas);
        this.drawLine(canvas);
        this.drawHint(canvas);
    }

    private void drawContent(Canvas canvas) {
        float fraction = 0.0f;
        for (int i2 = 0; i2 < this.mShowCount + 1; ++i2) {
            float textSizeCenterYOffset;
            float textSize;
            int textColor;
            float y = this.mCurrDrawFirstItemY + this.mItemHeight * i2;
            int index = this.getIndexByRawIndex(this.mCurrDrawFirstItemIndex + i2, this.getOneRecycleSize(), this.mWrapSelectorWheel && this.mWrapSelectorWheelCheck);
            if (i2 == this.mShowCount / 2) {
                fraction = (float)(this.mItemHeight + this.mCurrDrawFirstItemY) / (float)this.mItemHeight;
                textColor = this.getEvaluateColor(fraction, this.mTextColorNormal, this.mTextColorSelected);
                textSize = this.getEvaluateSize(fraction, this.mTextSizeNormal, this.mTextSizeSelected);
                textSizeCenterYOffset = this.getEvaluateSize(fraction, this.mTextSizeNormalCenterYOffset, this.mTextSizeSelectedCenterYOffset);
            } else if (i2 == this.mShowCount / 2 + 1) {
                textColor = this.getEvaluateColor(1.0f - fraction, this.mTextColorNormal, this.mTextColorSelected);
                textSize = this.getEvaluateSize(1.0f - fraction, this.mTextSizeNormal, this.mTextSizeSelected);
                textSizeCenterYOffset = this.getEvaluateSize(1.0f - fraction, this.mTextSizeNormalCenterYOffset, this.mTextSizeSelectedCenterYOffset);
            } else {
                textColor = this.mTextColorNormal;
                textSize = this.mTextSizeNormal;
                textSizeCenterYOffset = this.mTextSizeNormalCenterYOffset;
            }
            this.mPaintText.setColor(textColor);
            this.mPaintText.setTextSize(textSize);
            if (0 <= index && index < this.getOneRecycleSize()) {
                CharSequence str = this.mDisplayedValues[index + this.mMinShowIndex];
                if (this.mTextEllipsize != null) {
                    str = TextUtils.ellipsize((CharSequence)str, (TextPaint)this.mPaintText, (float)(this.getWidth() - 2 * this.mItemPaddingHorizontal), (TextUtils.TruncateAt)this.getEllipsizeType());
                }
                canvas.drawText(str.toString(), this.mViewCenterX, y + (float)(this.mItemHeight / 2) + textSizeCenterYOffset, (Paint)this.mPaintText);
                continue;
            }
            if (TextUtils.isEmpty((CharSequence)this.mEmptyItemHint)) continue;
            canvas.drawText(this.mEmptyItemHint, this.mViewCenterX, y + (float)(this.mItemHeight / 2) + textSizeCenterYOffset, (Paint)this.mPaintText);
        }
    }

    private TextUtils.TruncateAt getEllipsizeType() {
        switch (this.mTextEllipsize) {
            case "start": {
                return TextUtils.TruncateAt.START;
            }
            case "middle": {
                return TextUtils.TruncateAt.MIDDLE;
            }
            case "end": {
                return TextUtils.TruncateAt.END;
            }
        }
        throw new IllegalArgumentException("Illegal text ellipsize type.");
    }

    private void drawLine(Canvas canvas) {
        if (this.mShowDivider) {
            canvas.drawLine((float)(this.getPaddingLeft() + this.mDividerMarginL), this.dividerY0, (float)(this.mViewWidth - this.getPaddingRight() - this.mDividerMarginR), this.dividerY0, this.mPaintDivider);
            canvas.drawLine((float)(this.getPaddingLeft() + this.mDividerMarginL), this.dividerY1, (float)(this.mViewWidth - this.getPaddingRight() - this.mDividerMarginR), this.dividerY1, this.mPaintDivider);
        }
    }

    private void drawHint(Canvas canvas) {
        if (TextUtils.isEmpty((CharSequence)this.mHintText)) {
            return;
        }
        canvas.drawText(this.mHintText, this.mViewCenterX + (float)((this.mMaxWidthOfDisplayedValues + this.mWidthOfHintText) / 2) + (float)this.mMarginStartOfHint, (this.dividerY0 + this.dividerY1) / 2.0f + this.mTextSizeHintCenterYOffset, this.mPaintHint);
    }

    private void updateMaxWidthOfDisplayedValues() {
        float savedTextSize = this.mPaintText.getTextSize();
        this.mPaintText.setTextSize((float)this.mTextSizeSelected);
        this.mMaxWidthOfDisplayedValues = this.getMaxWidthOfTextArray(this.mDisplayedValues, (Paint)this.mPaintText);
        this.mMaxWidthOfAlterArrayWithMeasureHint = this.getMaxWidthOfTextArray(this.mAlterTextArrayWithMeasureHint, (Paint)this.mPaintText);
        this.mMaxWidthOfAlterArrayWithoutMeasureHint = this.getMaxWidthOfTextArray(this.mAlterTextArrayWithoutMeasureHint, (Paint)this.mPaintText);
        this.mPaintText.setTextSize((float)this.mTextSizeHint);
        this.mWidthOfAlterHint = this.getTextWidth(this.mAlterHint, (Paint)this.mPaintText);
        this.mPaintText.setTextSize(savedTextSize);
    }

    private int getMaxWidthOfTextArray(CharSequence[] array, Paint paint) {
        if (array == null) {
            return 0;
        }
        int maxWidth = 0;
        for (CharSequence item : array) {
            if (item == null) continue;
            int itemWidth = this.getTextWidth(item, paint);
            maxWidth = Math.max(itemWidth, maxWidth);
        }
        return maxWidth;
    }

    private int getTextWidth(CharSequence text, Paint paint) {
        if (!TextUtils.isEmpty((CharSequence)text)) {
            return (int)(paint.measureText(text.toString()) + 0.5f);
        }
        return 0;
    }

    private void updateMaxHeightOfDisplayedValues() {
        float savedTextSize = this.mPaintText.getTextSize();
        this.mPaintText.setTextSize((float)this.mTextSizeSelected);
        this.mMaxHeightOfDisplayedValues = (int)((double)(this.mPaintText.getFontMetrics().bottom - this.mPaintText.getFontMetrics().top) + 0.5);
        this.mPaintText.setTextSize(savedTextSize);
    }

    private void updateContentAndIndex(String[] newDisplayedValues) {
        this.mMinShowIndex = 0;
        this.mMaxShowIndex = newDisplayedValues.length - 1;
        this.mDisplayedValues = newDisplayedValues;
        this.updateWrapStateByContent();
    }

    private void updateContent(String[] newDisplayedValues) {
        this.mDisplayedValues = newDisplayedValues;
        this.updateWrapStateByContent();
    }

    private void updateValue() {
        this.inflateDisplayedValuesIfNull();
        this.updateWrapStateByContent();
        this.mMinShowIndex = 0;
        this.mMaxShowIndex = this.mDisplayedValues.length - 1;
    }

    private void updateValueForInit() {
        this.inflateDisplayedValuesIfNull();
        this.updateWrapStateByContent();
        if (this.mMinShowIndex == -1) {
            this.mMinShowIndex = 0;
        }
        if (this.mMaxShowIndex == -1) {
            this.mMaxShowIndex = this.mDisplayedValues.length - 1;
        }
        this.setMinAndMaxShowIndex(this.mMinShowIndex, this.mMaxShowIndex, false);
    }

    private void inflateDisplayedValuesIfNull() {
        if (this.mDisplayedValues == null) {
            this.mDisplayedValues = new String[1];
            this.mDisplayedValues[0] = "";
        }
    }

    private void updateWrapStateByContent() {
        this.mWrapSelectorWheelCheck = this.mDisplayedValues.length > this.mShowCount;
    }

    private int refineValueByLimit(int value, int minValue, int maxValue, boolean wrap) {
        if (wrap) {
            if (value > maxValue) {
                value = (value - maxValue) % this.getOneRecycleSize() + minValue - 1;
            } else if (value < minValue) {
                value = (value - minValue) % this.getOneRecycleSize() + maxValue + 1;
            }
            return value;
        }
        if (value > maxValue) {
            value = maxValue;
        } else if (value < minValue) {
            value = minValue;
        }
        return value;
    }

    private void stopRefreshing() {
        if (this.mHandlerInNewThread != null) {
            this.mHandlerInNewThread.removeMessages(1);
        }
    }

    private void stopScrolling() {
        if (this.mScroller != null && !this.mScroller.isFinished()) {
            this.mScroller.startScroll(0, this.mScroller.getCurrY(), 0, 0, 1);
            this.mScroller.abortAnimation();
            this.postInvalidate();
        }
    }

    private Message getMsg(int what) {
        return this.getMsg(what, 0, 0, null);
    }

    private Message getMsg(int what, int arg1, int arg2, Object obj) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = arg1;
        msg.arg2 = arg2;
        msg.obj = obj;
        return msg;
    }

    private boolean isStringEqual(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    private int sp2px(Context context, float spValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    private int dp2px(Context context, float dpValue) {
        float densityScale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * densityScale + 0.5f);
    }

    private int getEvaluateColor(float fraction, int startColor, int endColor) {
        int sA = (startColor & 0xFF000000) >>> 24;
        int sR = (startColor & 0xFF0000) >>> 16;
        int sG = (startColor & 0xFF00) >>> 8;
        int sB = (startColor & 0xFF) >>> 0;
        int eA = (endColor & 0xFF000000) >>> 24;
        int eR = (endColor & 0xFF0000) >>> 16;
        int eG = (endColor & 0xFF00) >>> 8;
        int eB = (endColor & 0xFF) >>> 0;
        int a = (int)((float)sA + (float)(eA - sA) * fraction);
        int r = (int)((float)sR + (float)(eR - sR) * fraction);
        int g = (int)((float)sG + (float)(eG - sG) * fraction);
        int b = (int)((float)sB + (float)(eB - sB) * fraction);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private float getEvaluateSize(float fraction, float startSize, float endSize) {
        return startSize + (endSize - startSize) * fraction;
    }

    private String[] convertCharSequenceArrayToStringArray(CharSequence[] charSequences) {
        if (charSequences == null) {
            return null;
        }
        String[] ret = new String[charSequences.length];
        for (int i2 = 0; i2 < charSequences.length; ++i2) {
            ret[i2] = charSequences[i2].toString();
        }
        return ret;
    }

    public static interface OnScrollListener {
        public static final int SCROLL_STATE_IDLE = 0;
        public static final int SCROLL_STATE_TOUCH_SCROLL = 1;
        public static final int SCROLL_STATE_FLING = 2;

        public void onScrollStateChange(NumberPickerView var1, int var2);
    }

    public static interface OnValueChangeListenerInScrolling {
        public void onValueChangeInScrolling(NumberPickerView var1, int var2, int var3);
    }

    public static interface OnValueChangeListenerRelativeToRaw {
        public void onValueChangeRelativeToRaw(NumberPickerView var1, int var2, int var3, String[] var4);
    }

    public static interface OnValueChangeListener {
        public void onValueChange(NumberPickerView var1, int var2, int var3);
    }
}

