/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.widget.RelativeLayout;
import com.yy.mobile.RxBus;
import com.yy.mobile.plugin.main.events.IChatEmotionClient_onChatPluginSwitch_EventArgs;
import com.yy.mobile.util.log.MLog;

public class CustomTouchRelativeLayout
extends RelativeLayout
implements GestureDetector.OnGestureListener {
    private static final String TAG = "CustomTouchRelativeLayout";
    private GestureDetector mGestureDetector;
    private OnTouchClick onTouchClick;

    public CustomTouchRelativeLayout(Context context) {
        this(context, null);
    }

    public CustomTouchRelativeLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CustomTouchRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this);
    }

    private void notifyChatInputSwitch(boolean chatPluginSwitch) {
        RxBus.getDefault().post((Object)new IChatEmotionClient_onChatPluginSwitch_EventArgs(chatPluginSwitch));
    }

    public boolean onDown(MotionEvent motionEvent) {
        return false;
    }

    public void onShowPress(MotionEvent motionEvent) {
    }

    public boolean onSingleTapUp(MotionEvent motionEvent) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("CustomTouchRelativeLayout --onSingleTapUp " + motionEvent + motionEvent.getAction()), (Object[])new Object[0]);
        }
        this.notifyChatInputSwitch(true);
        if (this.onTouchClick != null) {
            this.onTouchClick.onTouchclick();
        }
        return false;
    }

    public boolean onScroll(MotionEvent motionEvent, MotionEvent motionEvent1, float v, float v1) {
        return false;
    }

    public void onLongPress(MotionEvent motionEvent) {
    }

    public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent1, float v, float v1) {
        return false;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        this.mGestureDetector.onTouchEvent(ev);
        return super.dispatchTouchEvent(ev);
    }

    public void setOnTouchClick(OnTouchClick onTouchclick) {
        this.onTouchClick = onTouchclick;
    }

    public static interface OnTouchClick {
        public void onTouchclick();
    }
}

