/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils.multiPicker;

import com.yy.mobile.util.log.MLog;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class MultiPickerControl {
    private static final String TAG = "MultiPickerControl";
    public Map<String, String[]> pickerInfo = new HashMap<String, String[]>();
    public String[] topString;
    public boolean needListenVauleChange = true;

    public MultiPickerControl(String str) {
        this.parseData(str);
    }

    private void parseData(String str) {
        try {
            JSONObject jsonObject = new JSONObject(str);
            JSONArray jsonArray = jsonObject.optJSONArray("content");
            boolean bl = this.needListenVauleChange = jsonObject.optInt("mode", 1) == 1;
            if (this.needListenVauleChange) {
                this.parseSubJson(jsonArray, null);
            } else {
                this.parseArraySubJson(jsonArray);
            }
        }
        catch (Exception e2) {
            MLog.error((Object)TAG, (Throwable)e2);
        }
    }

    private void parseSubJson(JSONArray jsonArray, String title) {
        String[] subString = new String[jsonArray.length()];
        for (int i2 = 0; i2 < jsonArray.length(); ++i2) {
            JSONObject subJsonObject = jsonArray.optJSONObject(i2);
            subString[i2] = subJsonObject.optString("title", "");
            Object content = subJsonObject.opt("content");
            if (content == null || !(content instanceof JSONArray)) continue;
            this.parseSubJson((JSONArray)content, subString[i2]);
        }
        if (title == null) {
            this.topString = subString;
        } else {
            this.pickerInfo.put(title, subString);
        }
    }

    private void parseArraySubJson(JSONArray jsonArray) {
        for (int i2 = 0; i2 < jsonArray.length(); ++i2) {
            JSONArray subString = jsonArray.optJSONArray(i2);
            if (subString == null || subString.length() == 0) continue;
            String[] subStringArray = new String[subString.length()];
            for (int j = 0; j < subString.length(); ++j) {
                subStringArray[j] = subString.optString(j);
            }
            this.pickerInfo.put(i2 + "", subStringArray);
        }
    }
}

