/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.widget.TextView;
import com.yy.mobile.ui.utils.dialog.BaseDialog;
import com.yymobile.baseapi.R;

public class ProgressDialog
implements BaseDialog {
    private final String mMsg;
    private final boolean mCancelable;
    private final boolean mOutSideCancelable;
    private final DialogInterface.OnDismissListener mListener;
    private final int mWindowBackGroundColor;
    private final int mDialogBackGroundColor;
    private Dialog mDialog;
    private int mProgressMax = 0;
    private String mTip;
    private TextView mTvTip;

    public ProgressDialog() {
        this(null, false);
    }

    public ProgressDialog(CharSequence msg) {
        this(msg, false);
    }

    public ProgressDialog(CharSequence msg, boolean cancelable) {
        this(msg, cancelable, null);
    }

    public ProgressDialog(CharSequence msg, boolean cancelable, boolean outSideCancelable) {
        this(msg != null ? String.valueOf(msg) : null, cancelable, outSideCancelable, null);
    }

    public ProgressDialog(CharSequence msg, boolean cancelable, DialogInterface.OnDismissListener listener) {
        this(msg != null ? String.valueOf(msg) : null, cancelable, false, listener);
    }

    public ProgressDialog(String msg, boolean cancelable, boolean outSideCancelable, DialogInterface.OnDismissListener listener) {
        this(msg, cancelable, outSideCancelable, -1, 0, listener);
    }

    public ProgressDialog(String msg, boolean cancelable, boolean outSideCancelable, int windowBackGroundColor, DialogInterface.OnDismissListener listener) {
        this(msg, cancelable, outSideCancelable, windowBackGroundColor, 0, listener);
    }

    public ProgressDialog(String msg, boolean cancelable, boolean outSideCancelable, int windowBackGroundColor, int dialogBackGround, DialogInterface.OnDismissListener listener) {
        this.mMsg = msg;
        this.mCancelable = cancelable;
        this.mOutSideCancelable = outSideCancelable;
        this.mListener = listener;
        this.mWindowBackGroundColor = windowBackGroundColor;
        this.mDialogBackGroundColor = dialogBackGround;
    }

    @Override
    public void init(Dialog mDialog) {
        this.mDialog = mDialog;
        this.setBackgroundTransparent(mDialog);
        mDialog.setCancelable(this.mCancelable);
        mDialog.setCanceledOnTouchOutside(this.mOutSideCancelable);
        View rootView = LayoutInflater.from((Context)mDialog.getContext()).inflate(this.getLayoutResId(), null);
        if (this.mDialogBackGroundColor > -1) {
            rootView.setBackgroundColor(this.mDialogBackGroundColor);
        }
        mDialog.setContentView(rootView);
        this.mTvTip = (TextView)mDialog.findViewById(R.id.tv_tip);
        if (!TextUtils.isEmpty((CharSequence)this.mMsg)) {
            this.mTvTip.setText((CharSequence)this.mMsg);
        }
        if (this.mListener != null) {
            mDialog.setOnDismissListener(this.mListener);
        }
    }

    @Override
    public int getLayoutResId() {
        return R.layout.layout_progress_dialog;
    }

    public void setText(String text) {
        this.mTip = text;
    }

    public void setMax(int max) {
        this.mProgressMax = max;
    }

    public void setProgress(int progress) {
        if (this.mDialog != null && this.mDialog.isShowing() && this.mProgressMax > 0 && this.mTvTip != null) {
            this.mTvTip.setText((CharSequence)(this.mTip + progress * 100 / this.mProgressMax + "%"));
        }
    }

    private void setBackgroundTransparent(Dialog dialog) {
        Window window;
        if (this.mWindowBackGroundColor > -1 && (window = dialog.getWindow()) != null) {
            View decorView = window.getDecorView();
            decorView.setBackgroundColor(this.mWindowBackGroundColor);
        }
    }
}

