/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils.dialog;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.DialogInterface;
import android.graphics.Color;
import android.os.Build;
import android.support.annotation.LayoutRes;
import android.text.Editable;
import android.text.Html;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.LinkMovementMethod;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.widget.EditText;
import android.widget.TextView;
import com.unionyy.mobile.spdt.Spdt;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.ui.utils.SpannableUtils;
import com.yy.mobile.ui.utils.dialog.BaseDialog;
import com.yy.mobile.ui.utils.dialog.ExBaseDialog;
import com.yy.mobile.ui.utils.dialog.SpdtDialogStyle;
import com.yy.mobile.ui.utils.multiPicker.MultiPickerControl;
import com.yy.mobile.ui.widget.NumberPickerView;
import com.yy.mobile.ui.widget.dialog.ButtonItem;
import com.yy.mobile.ui.widget.dialog.CommonPopupDialog;
import com.yy.mobile.util.ImeUtil;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.log.PerfLog;
import com.yy.mobile.util.valid.BlankUtil;
import com.yymobile.baseapi.R;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class DialogLinkManager {
    private static final String TAG = "DialogLinkManager";
    public Dialog mDialog;
    public WeakReference<Context> mContext;
    public AlertDialog.Builder mBuilder;
    private String mStackTraceString;
    public static final String OkButtonColorKey = "OkButtonColorKey";
    public static final String CancelButtonColorKey = "CancelButtonColorKey";

    public DialogLinkManager(Context context) {
        if (context == null) {
            this.mStackTraceString = Log.getStackTraceString((Throwable)new Throwable());
            MLog.error((Object)TAG, (String)this.mStackTraceString, (Object[])new Object[0]);
            PerfLog.webLog((String)"Hensen", (String)this.mStackTraceString);
        }
        this.mContext = new WeakReference<Context>(context);
        this.mBuilder = new AlertDialog.Builder(context);
        this.mDialog = this.mBuilder.create();
    }

    @TargetApi(value=17)
    public boolean checkActivityValid() {
        Context context = this.getContext(this.mContext);
        if (this.mContext == null || context == null) {
            MLog.warn((Object)TAG, (String)("Fragment " + this + " not attached to Activity"), (Object[])new Object[0]);
            return false;
        }
        if (this.mDialog != null && this.mDialog.getWindow() == null) {
            MLog.warn((Object)TAG, (String)"window null", (Object[])new Object[0]);
            return false;
        }
        if (context instanceof Activity && ((Activity)context).isFinishing()) {
            MLog.warn((Object)TAG, (String)"activity is finishing", (Object[])new Object[0]);
            return false;
        }
        if (Build.VERSION.SDK_INT >= 17 && context instanceof Activity && ((Activity)context).isDestroyed()) {
            MLog.warn((Object)TAG, (String)"activity is isDestroyed", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    public boolean isDialogShowing() {
        return this.mDialog != null && this.mDialog.isShowing();
    }

    public int getShowingDialogId() {
        if (this.mDialog.isShowing() && this.mDialog instanceof CommonPopupDialog) {
            return ((CommonPopupDialog)this.mDialog).getId();
        }
        return 0;
    }

    public void hideProgressDialog() {
        if (this.mDialog != null && this.mDialog.isShowing()) {
            this.mDialog.dismiss();
        }
    }

    public void dismissDialog() {
        if (this.mContext != null && this.mContext.get() != null && this.mDialog != null && this.mDialog.getWindow() != null) {
            if (this.mContext.get() instanceof Activity) {
                Activity activity = (Activity)this.mContext.get();
                if (activity != null && !activity.isFinishing()) {
                    this.mDialog.dismiss();
                }
            } else {
                this.mDialog.dismiss();
            }
        }
    }

    public void showOkCancelFollowDialog(CharSequence title, CharSequence message, CharSequence okLabel, CharSequence cancelLabel, boolean cancelable, boolean isHideOk, final OkCancelDialogListener l) {
        if (!this.checkActivityValid()) {
            MLog.info((Object)TAG, (String)"showOkCancelDialog ActivityInvalid....", (Object[])new Object[0]);
            return;
        }
        if (this.mDialog.isShowing()) {
            this.mDialog.dismiss();
        }
        this.mDialog = this.mBuilder.create();
        this.mDialog.setCancelable(cancelable);
        this.mDialog.setCanceledOnTouchOutside(cancelable);
        this.mDialog.show();
        Window window = this.mDialog.getWindow();
        window.setContentView(R.layout.layout_ok_cancel_double_text_link_dialog);
        window.setBackgroundDrawableResource(17170445);
        TextView titleView = (TextView)window.findViewById(R.id.message);
        titleView.setText(title);
        TextView tip = (TextView)window.findViewById(R.id.message_content);
        tip.setText(message);
        TextView ok = (TextView)window.findViewById(R.id.btn_ok);
        ok.setText(okLabel);
        ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DialogLinkManager.this.mDialog.dismiss();
                if (l != null) {
                    l.onOk();
                }
            }
        });
        TextView cancel = (TextView)window.findViewById(R.id.btn_cancel);
        cancel.setText(cancelLabel);
        cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DialogLinkManager.this.mDialog.dismiss();
                if (l != null) {
                    l.onCancel();
                }
            }
        });
        if (isHideOk) {
            ok.setVisibility(8);
            cancel.setVisibility(0);
            cancel.setBackgroundResource(R.drawable.dialog_btn_color_2bottom_corner);
        } else {
            ok.setVisibility(0);
            ok.setBackgroundResource(R.drawable.dialog_btn_color_ok_rb_corner);
            cancel.setVisibility(0);
            cancel.setBackgroundResource(R.drawable.dialog_btn_color_cancel_lb_corner);
        }
    }

    public void showTitleMessageOkCancelDialog(CharSequence title, CharSequence message, CharSequence okLabel, CharSequence cancelLabel, boolean outsideCancelable, boolean backCancelable, OkCancelDialogListener listener) {
        this.showTitleMessageClickableOkCancelDialog(title, true, message, false, okLabel, cancelLabel, outsideCancelable, backCancelable, null, listener);
    }

    public void showTitleMessageOkCancelDialog(CharSequence title, CharSequence message, CharSequence okLabel, CharSequence cancelLabel, boolean outsideCancelable, boolean backCancelable, Map<String, String> colorMap, OkCancelDialogListener listener) {
        this.showTitleMessageClickableOkCancelDialog(title, true, message, false, okLabel, cancelLabel, outsideCancelable, backCancelable, colorMap, listener);
    }

    public void showTitleMessageClickableOkCancelDialog(CharSequence title, boolean isTitleCenter, CharSequence message, boolean messageClickable, CharSequence okLabel, CharSequence cancelLabel, boolean outsideCancelable, boolean backCancelable, Map<String, String> colorMap, final OkCancelDialogListener listener) {
        String cancelColorKey;
        if (!this.checkActivityValid()) {
            MLog.info((Object)TAG, (String)"showTitleMessageClickableOkCancelDialog ActivityInvalid....", (Object[])new Object[0]);
            return;
        }
        if (this.mDialog.isShowing()) {
            this.mDialog.dismiss();
        }
        this.mDialog = this.mBuilder.create();
        this.mDialog.setCancelable(backCancelable);
        this.mDialog.setCanceledOnTouchOutside(outsideCancelable);
        this.mDialog.show();
        Window window = this.mDialog.getWindow();
        window.setContentView(R.layout.layout_ok_cancel_double_text_link_dialog);
        window.setBackgroundDrawableResource(17170445);
        TextView titleTv = (TextView)window.findViewById(R.id.message);
        if (title.toString().isEmpty()) {
            titleTv.setVisibility(8);
        } else {
            if (isTitleCenter) {
                titleTv.setGravity(17);
            } else {
                titleTv.setGravity(19);
            }
            titleTv.setText(title);
        }
        TextView messageTv = (TextView)window.findViewById(R.id.message_content);
        messageTv.setText(message);
        if (messageClickable) {
            messageTv.setMovementMethod(LinkMovementMethod.getInstance());
        }
        Context context = this.getContext(this.mContext);
        TextView ok = (TextView)window.findViewById(R.id.btn_ok);
        ok.setText(okLabel);
        if (colorMap != null && colorMap.containsKey(OkButtonColorKey)) {
            String okColorKey = colorMap.get(OkButtonColorKey);
            if (!StringUtils.isEmpty((String)okColorKey).booleanValue()) {
                ok.setTextColor(Color.parseColor((String)okColorKey));
            }
        } else {
            ok.setTextColor(((SpdtDialogStyle)Spdt.of(SpdtDialogStyle.class)).getOkButtonColor());
        }
        if (okLabel.length() > 4) {
            if (this.mContext != null && context != null) {
                if (context.getResources().getDisplayMetrics().widthPixels <= 480) {
                    ok.setTextSize(2, 14.0f);
                } else {
                    ok.setTextSize(2, 16.0f);
                }
            } else {
                ok.setTextSize(2, 16.0f);
            }
        }
        ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DialogLinkManager.this.mDialog.dismiss();
                if (listener != null) {
                    listener.onOk();
                }
            }
        });
        TextView cancel = (TextView)window.findViewById(R.id.btn_cancel);
        cancel.setText(cancelLabel);
        if (colorMap != null && colorMap.containsKey(CancelButtonColorKey) && !StringUtils.isEmpty((String)(cancelColorKey = colorMap.get(CancelButtonColorKey))).booleanValue()) {
            cancel.setTextColor(Color.parseColor((String)cancelColorKey));
        }
        if (cancelLabel.length() > 4) {
            if (this.mContext != null && context != null) {
                if (context.getResources().getDisplayMetrics().widthPixels <= 480) {
                    cancel.setTextSize(2, 14.0f);
                } else {
                    cancel.setTextSize(2, 16.0f);
                }
            } else {
                cancel.setTextSize(2, 16.0f);
            }
        }
        cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DialogLinkManager.this.mDialog.dismiss();
                if (listener != null) {
                    listener.onCancel();
                }
            }
        });
    }

    public void showInputDialog(@LayoutRes int layoutResID, CharSequence message, CharSequence desc, CharSequence defaultInput, CharSequence inputHint, String okBtnText, boolean cancelable, boolean autoShowIme, final boolean autoHideIme, final InputDialogListener listener, boolean showClose) {
        if (!this.checkActivityValid()) {
            MLog.info((Object)TAG, (String)"showInputDialog ActivityInvalid....", (Object[])new Object[0]);
            return;
        }
        if (this.mDialog.isShowing()) {
            this.mDialog.dismiss();
        }
        this.mDialog = this.mBuilder.create();
        this.mDialog.setCancelable(cancelable);
        this.mDialog.show();
        Window window = this.mDialog.getWindow();
        window.setContentView(layoutResID == 0 ? R.layout.layout_link_input_dialog : layoutResID);
        window.clearFlags(131072);
        window.setSoftInputMode(4);
        TextView tvTitle = (TextView)window.findViewById(R.id.tv_title);
        if (!TextUtils.isEmpty((CharSequence)message)) {
            tvTitle.setText(message);
        }
        final EditText etInput = (EditText)window.findViewById(R.id.et_input_text);
        if (autoShowIme) {
            etInput.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    if (etInput.isFocused()) {
                        if (DialogLinkManager.this.mContext != null && DialogLinkManager.this.mContext.get() != null && DialogLinkManager.this.mContext.get() instanceof Activity) {
                            ImeUtil.showIME((Activity)((Activity)DialogLinkManager.this.mContext.get()), (View)etInput);
                        }
                        if (Build.VERSION.SDK_INT >= 16) {
                            etInput.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        } else {
                            etInput.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        }
                    }
                }
            });
        }
        if (!TextUtils.isEmpty((CharSequence)inputHint)) {
            etInput.setHint(inputHint);
        }
        if (!TextUtils.isEmpty((CharSequence)desc)) {
            TextView tvDesc = (TextView)window.findViewById(R.id.tv_description);
            tvDesc.setText(desc);
            tvDesc.setVisibility(0);
        }
        View closeView = window.findViewById(R.id.exit_dismiss);
        if (showClose) {
            closeView.setVisibility(0);
            closeView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (listener != null) {
                        listener.onExit();
                    }
                    if (autoHideIme && DialogLinkManager.this.mContext != null && DialogLinkManager.this.mContext.get() != null) {
                        ImeUtil.hideIME((Context)((Context)DialogLinkManager.this.mContext.get()), (View)etInput);
                    }
                    DialogLinkManager.this.dismissDialog();
                }
            });
        } else if (closeView != null) {
            closeView.setVisibility(8);
        }
        final TextView btnOk = (TextView)window.findViewById(R.id.btn_ok);
        if (okBtnText != null) {
            btnOk.setText((CharSequence)okBtnText);
        }
        if (defaultInput != null) {
            etInput.setText(defaultInput);
            btnOk.setEnabled(true);
        }
        etInput.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (BlankUtil.isBlank((String)s.toString())) {
                    btnOk.setEnabled(false);
                } else {
                    btnOk.setEnabled(true);
                }
            }
        });
        btnOk.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                boolean confirmResult = true;
                if (listener != null) {
                    String input = etInput.getText().toString();
                    confirmResult = listener.confirm(input);
                }
                if (autoHideIme && DialogLinkManager.this.mContext != null && DialogLinkManager.this.mContext.get() != null) {
                    ImeUtil.hideIME((Context)((Context)DialogLinkManager.this.mContext.get()), (View)etInput);
                }
                if (confirmResult) {
                    DialogLinkManager.this.dismissDialog();
                }
            }
        });
        window.findViewById(R.id.btn_cancel).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (listener != null) {
                    listener.cancel();
                }
                if (autoHideIme && DialogLinkManager.this.mContext != null && DialogLinkManager.this.mContext.get() != null) {
                    ImeUtil.hideIME((Context)((Context)DialogLinkManager.this.mContext.get()), (View)etInput);
                }
                DialogLinkManager.this.dismissDialog();
            }
        });
    }

    public void showInputDialog(CharSequence message, CharSequence desc, CharSequence defaultInput, CharSequence inputHint, String okBtnText, boolean cancelable, boolean autoShowIme, boolean autoHideIme, InputDialogListener listener, boolean showClose) {
        this.showInputDialog(0, message, desc, defaultInput, inputHint, okBtnText, cancelable, autoShowIme, autoHideIme, listener, showClose);
    }

    public void showInputDialog(String message, String desc, String defaultInput, String inputHint, boolean cancelable, boolean autoShowIme, boolean autoHideIme, InputDialogListener listener, boolean showClose) {
        this.showInputDialog(message, desc, defaultInput, inputHint, null, cancelable, autoShowIme, autoHideIme, listener, showClose);
    }

    public void showInputDialog(String message, String desc, String inputHint, boolean cancelable, boolean autoShowIme, boolean autoHideIme, InputDialogListener listener, boolean showClose) {
        this.showInputDialog(message, desc, null, inputHint, cancelable, autoShowIme, autoHideIme, listener, showClose);
    }

    public void showInputDialog(String message, String desc, boolean cancelable, boolean autoShowIme, boolean autoHideIme, InputDialogListener listener, boolean showClose) {
        this.showInputDialog(message, desc, null, cancelable, autoShowIme, autoHideIme, listener, showClose);
    }

    public void showInputDialog(String message, boolean cancelable, boolean autoShowIme, boolean autoHideIme, InputDialogListener listener) {
        this.showInputDialog(message, null, cancelable, autoShowIme, autoHideIme, listener, false);
    }

    public void showTitleAndMessageOkDialog(CharSequence message, CharSequence content, boolean cancelable, boolean canceledOnClickOutside, OkDialogListener l) {
        this.showTitleAndMessageOkDialog(message, content, "", cancelable, canceledOnClickOutside, l);
    }

    public void showTitleAndMessageOkDialog(CharSequence message, CharSequence content, CharSequence okLable, boolean cancelable, boolean canceledOnClickOutside, OkDialogListener l) {
        this.showTitleAndMessageOkDialog(message, content, okLable, cancelable, canceledOnClickOutside, l, false);
    }

    public void showTitleAndMessageOkDialog(CharSequence message, CharSequence content, CharSequence okLable, boolean cancelable, boolean canceledOnClickOutside, OkDialogListener l, boolean isHtmlText) {
        this.showTitleAndMessageOkDialog(message, content, okLable, cancelable, canceledOnClickOutside, l, null, isHtmlText);
    }

    public void showTitleAndMessageOkDialog(CharSequence message, CharSequence content, CharSequence okLable, boolean cancelable, boolean canceledOnClickOutside, final OkDialogListener l, final TipTextListener textListener, boolean isHtmlText) {
        if (!this.checkActivityValid()) {
            MLog.info((Object)TAG, (String)"showOkDialog ActivityInvalid..", (Object[])new Object[0]);
            return;
        }
        if (this.mDialog.isShowing()) {
            this.mDialog.dismiss();
        }
        this.mDialog = this.mBuilder.create();
        this.mDialog.setCancelable(cancelable);
        this.mDialog.setCanceledOnTouchOutside(canceledOnClickOutside);
        this.mDialog.show();
        Window window = this.mDialog.getWindow();
        window.setContentView(R.layout.layout_ok_double_text_link_dialog);
        TextView msg = (TextView)window.findViewById(R.id.message);
        TextView tip = (TextView)window.findViewById(R.id.message_content);
        if (isHtmlText) {
            if (!TextUtils.isEmpty((CharSequence)message) && message instanceof String) {
                msg.setText((CharSequence)Html.fromHtml((String)((String)message)));
            }
            if (!TextUtils.isEmpty((CharSequence)content) && content instanceof String) {
                tip.setText((CharSequence)Html.fromHtml((String)((String)content)));
            }
            msg.setMovementMethod(LinkMovementMethod.getInstance());
            SpannableUtils.setUrlSpans(msg);
            SpannableUtils.setUrlSpans(tip);
        } else {
            if (!TextUtils.isEmpty((CharSequence)message)) {
                msg.setText(message);
            }
            if (!TextUtils.isEmpty((CharSequence)content)) {
                tip.setText(content);
            }
        }
        tip.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DialogLinkManager.this.mDialog.cancel();
                if (textListener != null) {
                    textListener.onClick();
                }
            }
        });
        TextView ok = (TextView)window.findViewById(R.id.btn_ok);
        if (!TextUtils.isEmpty((CharSequence)okLable)) {
            ok.setText(okLable);
        }
        ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DialogLinkManager.this.mDialog.cancel();
                if (l != null) {
                    l.onOk();
                }
            }
        });
    }

    public void showTitleAndMessageOkDialog(CharSequence message, CharSequence content, CharSequence okLable, boolean cancelable, boolean canceledOnClickOutside, final OkDialogListener l, final TipTextListener textListener, boolean isHtmlText, boolean tilteIsCenter, boolean contenIsCenter) {
        if (!this.checkActivityValid()) {
            MLog.info((Object)TAG, (String)"showOkDialog ActivityInvalid..", (Object[])new Object[0]);
            return;
        }
        if (this.mDialog.isShowing()) {
            this.mDialog.dismiss();
        }
        this.mDialog = this.mBuilder.create();
        this.mDialog.setCancelable(cancelable);
        this.mDialog.setCanceledOnTouchOutside(canceledOnClickOutside);
        this.mDialog.show();
        Window window = this.mDialog.getWindow();
        window.setContentView(R.layout.layout_ok_double_text_link_dialog);
        TextView msg = (TextView)window.findViewById(R.id.message);
        if (tilteIsCenter) {
            msg.setGravity(17);
        } else {
            msg.setGravity(19);
        }
        TextView tip = (TextView)window.findViewById(R.id.message_content);
        if (contenIsCenter) {
            tip.setGravity(17);
        } else {
            tip.setGravity(19);
        }
        if (isHtmlText) {
            if (!TextUtils.isEmpty((CharSequence)message) && message instanceof String) {
                msg.setText((CharSequence)Html.fromHtml((String)((String)message)));
            }
            if (!TextUtils.isEmpty((CharSequence)content) && content instanceof String) {
                tip.setText((CharSequence)Html.fromHtml((String)((String)content)));
            }
            msg.setMovementMethod(LinkMovementMethod.getInstance());
            SpannableUtils.setUrlSpans(msg);
            SpannableUtils.setUrlSpans(tip);
        } else {
            if (!TextUtils.isEmpty((CharSequence)message)) {
                msg.setText(message);
            }
            if (!TextUtils.isEmpty((CharSequence)content)) {
                tip.setText(content);
            }
        }
        tip.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DialogLinkManager.this.mDialog.cancel();
                if (textListener != null) {
                    textListener.onClick();
                }
            }
        });
        TextView ok = (TextView)window.findViewById(R.id.btn_ok);
        if (!TextUtils.isEmpty((CharSequence)okLable)) {
            ok.setText(okLable);
        }
        ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DialogLinkManager.this.mDialog.cancel();
                if (l != null) {
                    l.onOk();
                }
            }
        });
    }

    public void showContentOkDialog(CharSequence content, CharSequence okLable, boolean cancelable, boolean canceledOnClickOutside, OkDialogListener l) {
        this.showContentOkDialog(content, okLable, cancelable, canceledOnClickOutside, l, null, false, true);
    }

    public void showContentOkDialog(CharSequence content, CharSequence okLable, boolean cancelable, boolean canceledOnClickOutside, final OkDialogListener l, final TipTextListener textListener, boolean isHtmlText, boolean isNeedCenter) {
        if (!this.checkActivityValid()) {
            MLog.info((Object)TAG, (String)"showOkDialog ActivityInvalid..", (Object[])new Object[0]);
            return;
        }
        if (this.mDialog.isShowing()) {
            this.mDialog.dismiss();
        }
        this.mDialog = this.mBuilder.create();
        this.mDialog.setCancelable(cancelable);
        this.mDialog.setCanceledOnTouchOutside(canceledOnClickOutside);
        this.mDialog.show();
        Window window = this.mDialog.getWindow();
        window.setContentView(R.layout.layout_ok_content_text_link_dialog);
        window.setBackgroundDrawableResource(17170445);
        TextView tip = (TextView)window.findViewById(R.id.message_content);
        if (isHtmlText) {
            if (!TextUtils.isEmpty((CharSequence)content) && content instanceof String) {
                tip.setText((CharSequence)Html.fromHtml((String)((String)content)));
            }
            SpannableUtils.setUrlSpans(tip);
        } else if (!TextUtils.isEmpty((CharSequence)content)) {
            tip.setText(content);
        }
        if (isNeedCenter) {
            tip.setGravity(17);
        } else {
            tip.setGravity(19);
        }
        tip.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DialogLinkManager.this.mDialog.cancel();
                if (textListener != null) {
                    textListener.onClick();
                }
            }
        });
        TextView ok = (TextView)window.findViewById(R.id.btn_ok);
        ok.setTextColor(((SpdtDialogStyle)Spdt.of(SpdtDialogStyle.class)).getOkButtonColor());
        if (!TextUtils.isEmpty((CharSequence)okLable)) {
            ok.setText(okLable);
        }
        ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DialogLinkManager.this.mDialog.cancel();
                if (l != null) {
                    l.onOk();
                }
            }
        });
    }

    public void showSimpleNumberInputDialog(String message, boolean backCancelable, boolean outsideCancelable, int maxLength, final InputDialogListener listener) {
        if (!this.checkActivityValid()) {
            MLog.info((Object)TAG, (String)"showSimpleNumberInputDialog ActivityInvalid....", (Object[])new Object[0]);
            return;
        }
        Context context = this.getContext(this.mContext);
        if (this.mDialog.isShowing()) {
            this.mDialog.dismiss();
        }
        if (this.mContext == null || context == null) {
            return;
        }
        this.mDialog = new Dialog(context, R.style.Dialog_Simple_Number_Input);
        this.mDialog.setCancelable(backCancelable);
        this.mDialog.setCanceledOnTouchOutside(outsideCancelable);
        this.mDialog.show();
        Window window = this.mDialog.getWindow();
        window.setContentView(R.layout.layout_link_input_number);
        if (context != null && 2 == context.getResources().getConfiguration().orientation) {
            window.setFlags(1024, 1024);
        }
        window.clearFlags(131072);
        window.setSoftInputMode(21);
        window.findViewById(R.id.rl_root).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (listener != null) {
                    listener.cancel();
                }
            }
        });
        final EditText etInput = (EditText)window.findViewById(R.id.et_input_text);
        if (!TextUtils.isEmpty((CharSequence)message)) {
            etInput.setHint((CharSequence)message);
        }
        etInput.setFilters(new InputFilter[]{new InputFilter.LengthFilter(maxLength)});
        etInput.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == 6 && listener != null) {
                    String input = etInput.getText().toString();
                    listener.confirm(input);
                }
                return false;
            }
        });
        etInput.postDelayed(new Runnable(){

            @Override
            public void run() {
                ImeUtil.showIME((Activity)((Activity)DialogLinkManager.this.mContext.get()), (View)etInput);
            }
        }, 100L);
        window.findViewById(R.id.btn_ok).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (listener != null) {
                    String input = etInput.getText().toString();
                    listener.confirm(input);
                }
            }
        });
        this.mDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                if (listener != null) {
                    listener.cancel();
                }
            }
        });
    }

    public void dismissDialogHideIME() {
        if (this.mContext != null && this.mContext.get() != null && this.mDialog != null && this.mDialog.getWindow() != null && this.mContext.get() instanceof Activity) {
            Activity activity = (Activity)this.mContext.get();
            ImeUtil.hideIME((Context)activity, (View)this.mDialog.getCurrentFocus());
            this.dismissDialog();
        }
    }

    public void showCommonPopupDialog(String title, List<ButtonItem> btnItems, boolean cancelable, boolean outsideCancelable) {
        this.showCommonPopupDialog(title, btnItems, "", cancelable, outsideCancelable);
    }

    public void showCommonPopupDialog(List<ButtonItem> btnItems, String cancelBtnText, boolean cancelable, boolean outsideCancelable) {
        this.showCommonPopupDialog(null, btnItems, cancelBtnText, cancelable, outsideCancelable);
    }

    public void showCommonPopupDialog(int id2, String title, List<ButtonItem> btnItems, ButtonItem bottomButton, boolean cancelable, boolean outsideCancelable) {
        if (!this.checkActivityValid()) {
            MLog.info((Object)TAG, (String)"showCommonPopupDialog ActivityInvalid....", (Object[])new Object[0]);
            return;
        }
        if (this.mDialog.isShowing()) {
            this.mDialog.dismiss();
        }
        this.mDialog = new CommonPopupDialog(id2, (Context)this.mContext.get(), title, btnItems, bottomButton);
        this.mDialog.setCancelable(cancelable);
        this.mDialog.setCanceledOnTouchOutside(outsideCancelable);
        this.mDialog.show();
    }

    public void showCommonPopupDialog(String title, List<ButtonItem> btnItems, String cancelBtnText, boolean cancelable, boolean outsideCancelable) {
        if (!this.checkActivityValid()) {
            MLog.info((Object)TAG, (String)"showCommonPopupDialog ActivityInvalid..", (Object[])new Object[0]);
            return;
        }
        if (this.mDialog.isShowing()) {
            this.mDialog.dismiss();
        }
        if (this.mContext == null || this.mContext.get() == null) {
            return;
        }
        this.mDialog = new CommonPopupDialog((Context)this.mContext.get(), title, btnItems, cancelBtnText);
        this.mDialog.setCancelable(cancelable);
        this.mDialog.setCanceledOnTouchOutside(outsideCancelable);
        this.mDialog.show();
    }

    public void showDialog(BaseDialog baseDialog) {
        if (!this.checkActivityValid()) {
            MLog.info((Object)TAG, (String)"showTitleMessageClickableOkCancelDialog ActivityInvalid....", (Object[])new Object[0]);
            return;
        }
        if (this.mDialog.isShowing()) {
            this.mDialog.dismiss();
        }
        this.mDialog = new NormalDialog((Context)this.mContext.get(), baseDialog);
        this.mDialog.show();
        baseDialog.init(this.mDialog);
    }

    public void showLoadingDialog(String stateMsg, Boolean cancelable) {
        if (!this.checkActivityValid()) {
            return;
        }
        if (this.mDialog.isShowing()) {
            this.mDialog.hide();
        }
        this.mBuilder = new AlertDialog.Builder((Context)this.mContext.get(), R.style.MyLoadingDialogStyle);
        this.mDialog = this.mBuilder.create();
        this.mDialog.setCancelable(cancelable.booleanValue());
        this.mDialog.setCanceledOnTouchOutside(cancelable.booleanValue());
        this.mDialog.show();
        Window window = this.mDialog.getWindow();
        window.setContentView(R.layout.layout_dialog_state);
        TextView tvStateMessage = (TextView)window.findViewById(R.id.state_text);
        tvStateMessage.setText((CharSequence)stateMsg);
    }

    public void showMultiPickerDialog(String str, final OnMultiPickerCallback listener) {
        if (!this.checkActivityValid()) {
            MLog.info((Object)TAG, (String)"showUpdateDialog ActivityInvalid....", (Object[])new Object[0]);
            return;
        }
        if (this.mDialog.isShowing()) {
            this.mDialog.dismiss();
        }
        this.mDialog = this.mBuilder.create();
        this.mDialog.setCancelable(true);
        this.mDialog.setCanceledOnTouchOutside(true);
        this.mDialog.show();
        Window window = this.mDialog.getWindow();
        window.setLayout(-1, -2);
        window.setGravity(80);
        window.setContentView(R.layout.multi_picker);
        final NumberPickerView picker1 = (NumberPickerView)window.findViewById(R.id.picker1);
        final NumberPickerView picker2 = (NumberPickerView)window.findViewById(R.id.picker2);
        final NumberPickerView picker3 = (NumberPickerView)window.findViewById(R.id.picker3);
        final MultiPickerControl multiPickerControl = new MultiPickerControl(str);
        if (multiPickerControl.pickerInfo == null || multiPickerControl.pickerInfo.size() == 0) {
            SingleToastUtil.showToast((String)"\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5");
            this.mDialog.dismiss();
            return;
        }
        if (multiPickerControl.needListenVauleChange) {
            picker1.setDisplayedValues(multiPickerControl.topString);
            picker1.setMinValue(0);
            picker1.setMaxValue(multiPickerControl.topString.length - 1);
            picker1.setValue((multiPickerControl.topString.length - 1) / 2);
            picker1.setOnValueChangedListener(new NumberPickerView.OnValueChangeListener(){

                @Override
                public void onValueChange(NumberPickerView picker, int oldVal, int newVal) {
                    DialogLinkManager.this.updatePickersState(picker1, picker2, picker3, multiPickerControl);
                }
            });
            this.updatePickersState(picker1, picker2, picker3, multiPickerControl);
        } else {
            if (multiPickerControl.pickerInfo.get("0") != null) {
                this.updatePickerStringArray(multiPickerControl.pickerInfo.get("0"), picker1);
            }
            if (multiPickerControl.pickerInfo.get("1") != null) {
                this.updatePickerStringArray(multiPickerControl.pickerInfo.get("1"), picker2);
            } else {
                picker2.setVisibility(8);
            }
            if (multiPickerControl.pickerInfo.get("2") != null) {
                this.updatePickerStringArray(multiPickerControl.pickerInfo.get("2"), picker3);
            } else {
                picker3.setVisibility(8);
            }
        }
        TextView cancel = (TextView)window.findViewById(R.id.tv_cancel);
        cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DialogLinkManager.this.mDialog.dismiss();
            }
        });
        TextView ok = (TextView)window.findViewById(R.id.tv_ok);
        ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DialogLinkManager.this.mDialog.dismiss();
                if (listener != null) {
                    try {
                        JSONObject result = new JSONObject();
                        JSONArray stringArray = new JSONArray();
                        JSONArray indexArray = new JSONArray();
                        stringArray.put((Object)picker1.getContentByCurrValue());
                        indexArray.put(picker1.getPickedIndexRelativeToRaw());
                        if (picker2.getVisibility() == 0) {
                            stringArray.put((Object)picker2.getContentByCurrValue());
                            indexArray.put(picker2.getPickedIndexRelativeToRaw());
                        }
                        if (picker3.getVisibility() == 0) {
                            stringArray.put((Object)picker3.getContentByCurrValue());
                            indexArray.put(picker3.getPickedIndexRelativeToRaw());
                        }
                        result.put("title", (Object)stringArray);
                        result.put("index", (Object)indexArray);
                        listener.onOk(result.toString());
                    }
                    catch (Exception e2) {
                        MLog.error((Object)DialogLinkManager.TAG, (Throwable)e2);
                    }
                }
            }
        });
    }

    private void updatePickersState(NumberPickerView picker1, final NumberPickerView picker2, final NumberPickerView picker3, final MultiPickerControl multiPickerControl) {
        String[] picker2String = multiPickerControl.pickerInfo.get(picker1.getContentByCurrValue());
        if (picker2String == null || picker2String.length == 0) {
            picker2.setVisibility(8);
            picker3.setVisibility(8);
        } else {
            this.updatePickerStringArray(picker2String, picker2);
            picker2.setOnValueChangedListener(new NumberPickerView.OnValueChangeListener(){

                @Override
                public void onValueChange(NumberPickerView picker, int oldVal, int newVal) {
                    String[] picker3String = multiPickerControl.pickerInfo.get(picker2.getContentByCurrValue());
                    if (picker3String == null || picker3String.length == 0) {
                        picker3.setVisibility(8);
                        return;
                    }
                    DialogLinkManager.this.updatePickerStringArray(picker3String, picker3);
                }
            });
            String[] picker3String = multiPickerControl.pickerInfo.get(picker2.getContentByCurrValue());
            if (picker3String == null || picker3String.length == 0) {
                picker3.setVisibility(8);
            } else {
                this.updatePickerStringArray(picker3String, picker3);
            }
        }
    }

    private void updatePickerStringArray(String[] strings, NumberPickerView picker) {
        picker.setVisibility(0);
        picker.setDisplayedValuesAndPickedIndex(strings, 0, false);
        picker.setMinValue(0);
        picker.setMaxValue(strings.length - 1);
        picker.setValue((strings.length - 1) / 2);
    }

    public Context getContext(WeakReference<Context> mContext) {
        Context context = null;
        if (mContext != null) {
            context = (Context)mContext.get();
        }
        return context;
    }

    public static interface OnMultiPickerCallback {
        public void onOk(String var1);
    }

    public static class OkExitDialogListenerAdapter
    implements OkExitDialogListener {
        @Override
        public void onExit() {
        }

        @Override
        public void onOk() {
        }

        @Override
        public void onCancel() {
        }

        @Override
        public void onMessageClick() {
        }
    }

    public static interface OkExitDialogListener {
        public void onExit();

        public void onOk();

        public void onCancel();

        public void onMessageClick();
    }

    public static class NoMoreNoticeOkDialogListenerAdapter
    implements NoMoreNoticeOkDialogListener {
        @Override
        public void onOk(boolean isChecked) {
        }

        @Override
        public void onCancel() {
        }
    }

    public static interface NoMoreNoticeOkDialogListener {
        public void onOk(boolean var1);

        public void onCancel();
    }

    public static class TipTextListenerAdapter
    implements TipTextListener {
        @Override
        public void onClick() {
        }
    }

    public static interface TipTextListener {
        public void onClick();
    }

    public static class OkDialogListenerAdapter
    implements OkDialogListener {
        @Override
        public void onOk() {
        }
    }

    public static interface OkDialogListener {
        public void onOk();
    }

    public static class InputDialogAdapter
    implements InputDialogListener {
        @Override
        public void cancel() {
        }

        @Override
        public boolean confirm(String input) {
            return false;
        }

        @Override
        public void onExit() {
        }
    }

    public static interface InputDialogListener {
        public void cancel();

        public boolean confirm(String var1);

        public void onExit();
    }

    public static class OkCancelDialogListenerAdapter
    implements OkCancelDialogListener {
        @Override
        public void onCancel() {
        }

        @Override
        public void onOk() {
        }
    }

    public static interface OkCancelDialogListener {
        public void onCancel();

        public void onOk();
    }

    public static class NormalDialog
    extends AlertDialog {
        private final BaseDialog baseDialog;

        NormalDialog(Context context, BaseDialog baseDialog) {
            super(context);
            this.baseDialog = baseDialog;
        }

        public void show() {
            super.show();
            if (this.baseDialog instanceof ExBaseDialog) {
                ((ExBaseDialog)this.baseDialog).start();
            }
        }

        public BaseDialog getBaseDialog() {
            return this.baseDialog;
        }

        public void dismiss() {
            if (this.baseDialog instanceof ExBaseDialog) {
                ((ExBaseDialog)this.baseDialog).stop();
            }
            if (this.isValidContext(this.getContext())) {
                super.dismiss();
            }
        }

        private boolean isValidContext(Context c) {
            if (null == c) {
                return false;
            }
            if (c instanceof Activity) {
                return this.isValidActivity((Activity)c);
            }
            if (c instanceof ContextWrapper) {
                return this.isValidContextWrapper((ContextWrapper)c);
            }
            return false;
        }

        private boolean isValidContextWrapper(ContextWrapper contextWrapper) {
            Context baseContext = contextWrapper.getBaseContext();
            if (null == baseContext || !(baseContext instanceof Activity)) {
                return false;
            }
            return this.isValidActivity((Activity)baseContext);
        }

        private boolean isValidActivity(Activity activity) {
            if (!activity.isFinishing()) {
                return true;
            }
            if (Build.VERSION.SDK_INT >= 17 && activity.isDestroyed()) {
                return false;
            }
            return false;
        }
    }
}

