/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import com.yy.mobile.util.log.MLog;
import java.util.Hashtable;

public class FontUtil {
    private static final String TAG = "FontUtil";
    private static Hashtable<FontType, Typeface> fontCache = new Hashtable();

    public static Typeface getTypeFace(Context context, FontType fontType) {
        Typeface typeface = fontCache.get((Object)fontType);
        try {
            if (typeface == null) {
                switch (fontType) {
                    case DIN_MITTELSCHRIFT_ALTERNATE: {
                        typeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/DINMittelschrift_Alternate.otf");
                        break;
                    }
                    case REFRIGERATOR_DELUXE_HEAVY: {
                        typeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/Refrigerator_Deluxe_Heavy.ttf");
                        break;
                    }
                    case BEBAS_NEUE: {
                        typeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/Bebas_Neue.otf");
                        break;
                    }
                }
                if (typeface != null) {
                    fontCache.put(fontType, typeface);
                } else {
                    MLog.info((Object)TAG, (String)("[getTypeFace] can not get font from asset,fonttype=" + (Object)((Object)fontType)), (Object[])new Object[0]);
                }
            }
        }
        catch (Throwable e2) {
            MLog.error((Object)TAG, (String)("[getTypeFace] exception=" + e2 + ",fonttype=" + (Object)((Object)fontType)), (Object[])new Object[0]);
            return null;
        }
        return typeface;
    }

    public static enum FontType {
        DIN_MITTELSCHRIFT_ALTERNATE,
        REFRIGERATOR_DELUXE_HEAVY,
        BEBAS_NEUE;

    }
}

