/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils;

import android.content.Context;
import com.yymobile.baseapi.R;

public class DurationUtils {
    public static final int HH = 3600;
    public static final int MM = 60;

    public static int durationStringToInt(String duration) {
        String[] arr = duration.split(":");
        int len = arr.length;
        if (len == 1) {
            return Integer.parseInt(arr[0]);
        }
        if (len == 2) {
            return Integer.parseInt(arr[0]) * 60 + Integer.parseInt(arr[1]);
        }
        if (len > 2) {
            return Integer.parseInt(arr[0]) * 60 + Integer.parseInt(arr[1]) * 60 + Integer.parseInt(arr[2]);
        }
        return 0;
    }

    public static String intToDurationString(int duration) {
        if (duration == 0) {
            return "00:00";
        }
        int h = duration / 3600;
        int left = duration - h * 3600;
        int m = left / 60;
        int s = left - m * 60;
        StringBuilder sb = new StringBuilder();
        if (h > 0) {
            sb.append(DurationUtils.formattedTimeString(h));
            sb.append(":");
        }
        sb.append(DurationUtils.formattedTimeString(m));
        sb.append(":");
        sb.append(DurationUtils.formattedTimeString(s));
        return sb.toString();
    }

    public static String intToDurationString2(int duration) {
        if (duration == 0) {
            return "00 : 00";
        }
        int h = duration / 3600;
        int left = duration - h * 3600;
        int m = left / 60;
        int s = left - m * 60;
        StringBuilder sb = new StringBuilder();
        if (h > 0) {
            sb.append(DurationUtils.formattedTimeString(h));
            sb.append(" : ");
        }
        sb.append(DurationUtils.formattedTimeString(m));
        sb.append(" : ");
        sb.append(DurationUtils.formattedTimeString(s));
        return sb.toString();
    }

    public static String formattedTimeString(int time) {
        if (time < 10) {
            return "0" + String.valueOf(time);
        }
        return String.valueOf(time);
    }

    public static String minToBeforeDurationStr(int duration, Context context) {
        String durationStr = "";
        if (duration > 59) {
            int i2 = duration / 60;
            if (i2 > 23) {
                int j = i2 / 24;
                durationStr = j + context.getString(R.string.time_day_before);
            } else {
                durationStr = i2 + context.getString(R.string.time_hour_before);
            }
        } else {
            durationStr = duration + context.getString(R.string.time_min_before);
        }
        return durationStr;
    }

    public static String beforeDuration(int duration, Context context) {
        String durationStr = "";
        if (duration > 59) {
            int i2 = duration / 60;
            if (i2 > 8760) {
                int j = i2 / 8760;
                durationStr = j + context.getString(R.string.time_year_before);
            } else if (i2 > 720) {
                int j = i2 / 720;
                durationStr = j + context.getString(R.string.time_month_before);
            } else if (i2 > 23) {
                int j = i2 / 24;
                durationStr = j + context.getString(R.string.time_day_before);
            } else {
                durationStr = i2 + context.getString(R.string.time_hour_before);
            }
        } else {
            durationStr = duration <= 0 ? context.getString(R.string.time_just_now) : duration + context.getString(R.string.time_min_before);
        }
        return durationStr;
    }
}

