/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicgunview.danmuopengl.util;

import android.opengl.GLES20;
import com.yy.mobile.ui.basicgunview.danmuopengl.util.ShaderUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class TexturePool {
    private static Set<Integer> mPool = new HashSet<Integer>();
    private static AtomicBoolean mLock = new AtomicBoolean(false);
    private static int mProgram = -1;
    private static int muMVPMatrixHandle = -1;
    private static int maPositionHandle = -1;
    private static int maTexCoorHandle = -1;
    private static int mAlphaHandle = -1;

    public static void uninit() {
        mProgram = -1;
        maPositionHandle = -1;
        maTexCoorHandle = -1;
        muMVPMatrixHandle = -1;
        mAlphaHandle = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int pollTextureId() {
        AtomicBoolean atomicBoolean = mLock;
        synchronized (atomicBoolean) {
            if (mPool.size() > 0) {
                int texureId = mPool.iterator().next();
                mPool.remove(texureId);
                return texureId;
            }
            int[] textures = new int[4];
            GLES20.glGenTextures((int)4, (int[])textures, (int)0);
            for (int i2 = 1; i2 < 4; ++i2) {
                if (textures[i2] <= -1) continue;
                mPool.add(textures[i2]);
            }
            return textures[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void offerTextureId(int textureId) {
        AtomicBoolean atomicBoolean = mLock;
        synchronized (atomicBoolean) {
            if (textureId > -1) {
                mPool.add(textureId);
            }
        }
    }

    public static int getProgram(String mVertexShader, String mFragmentShader) {
        if (mProgram == -1) {
            mProgram = ShaderUtils.createProgram(mVertexShader, mFragmentShader);
        }
        return mProgram;
    }

    public static int getMuMVPMatrixHandle() {
        if (muMVPMatrixHandle == -1) {
            muMVPMatrixHandle = GLES20.glGetUniformLocation((int)mProgram, (String)"uMVPMatrix");
        }
        return muMVPMatrixHandle;
    }

    public static int getMaPositionHandle() {
        if (maPositionHandle == -1) {
            maPositionHandle = GLES20.glGetAttribLocation((int)mProgram, (String)"aPosition");
        }
        return maPositionHandle;
    }

    public static int getAlphaHandle() {
        if (mAlphaHandle == -1) {
            mAlphaHandle = GLES20.glGetUniformLocation((int)mProgram, (String)"alpha");
        }
        return mAlphaHandle;
    }

    public static int getMaTexCoorHandle() {
        if (maTexCoorHandle == -1) {
            maTexCoorHandle = GLES20.glGetAttribLocation((int)mProgram, (String)"aTexCoor");
        }
        return maTexCoorHandle;
    }
}

