/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicgunview.danmuopengl.util;

import android.content.res.Resources;
import android.opengl.GLES20;
import com.yy.mobile.util.log.MLog;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

public class ShaderUtils {
    public static int loadShader(int shaderType, String source) {
        int shader = GLES20.glCreateShader((int)shaderType);
        if (shader != 0) {
            if (source == null) {
                shader = 0;
                return shader;
            }
            GLES20.glShaderSource((int)shader, (String)source);
            GLES20.glCompileShader((int)shader);
            int[] compiled = new int[1];
            GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
            if (compiled[0] == 0) {
                MLog.error((Object)"ES20_ERROR", (String)("Could not compile shader " + shaderType + ":" + GLES20.glGetShaderInfoLog((int)shader)), (Object[])new Object[0]);
                GLES20.glDeleteShader((int)shader);
                shader = 0;
            }
        }
        return shader;
    }

    public static int createProgram(String vertexSource, String fragmentSource) {
        int vertexShader = ShaderUtils.loadShader(35633, vertexSource);
        if (vertexShader == 0) {
            return 0;
        }
        int pixelShader = ShaderUtils.loadShader(35632, fragmentSource);
        if (pixelShader == 0) {
            return 0;
        }
        int program = GLES20.glCreateProgram();
        if (program != 0) {
            GLES20.glAttachShader((int)program, (int)vertexShader);
            ShaderUtils.checkGlError("glAttachShader");
            GLES20.glAttachShader((int)program, (int)pixelShader);
            ShaderUtils.checkGlError("glAttachShader");
            GLES20.glLinkProgram((int)program);
            int[] linkStatus = new int[1];
            GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
            if (linkStatus[0] != 1) {
                MLog.error((Object)"ES20_ERROR", (String)("Could not link program: " + GLES20.glGetProgramInfoLog((int)program)), (Object[])new Object[0]);
                GLES20.glDeleteProgram((int)program);
                program = 0;
            }
        }
        return program;
    }

    public static void checkGlError(String operation) {
        int error;
        while ((error = GLES20.glGetError()) != 0) {
            MLog.error((Object)"ES20_ERROR", (String)(operation + ": glError " + error), (Object[])new Object[0]);
        }
    }

    public static String loadFromAssetsFile(String fname, Resources resources) {
        String result = null;
        try {
            int ch;
            InputStream in = resources.getAssets().open(fname);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((ch = in.read()) != -1) {
                baos.write(ch);
            }
            byte[] buff = baos.toByteArray();
            baos.close();
            in.close();
            result = new String(buff, "UTF-8");
            result = result.replaceAll("\\r\\n", "\n");
        }
        catch (Exception e2) {
            MLog.error((Object)"ShaderUtils", (String)"printStackTrace", (Throwable)e2, (Object[])new Object[0]);
        }
        return result;
    }
}

