/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicgunview.danmuopengl;

import android.content.Context;
import android.opengl.GLES20;
import android.os.SystemClock;
import com.yy.mobile.ui.basicgunview.danmuopengl.DanmakuView;
import com.yy.mobile.ui.basicgunview.danmuopengl.GLTextureView;
import com.yy.mobile.ui.basicgunview.danmuopengl.gunpower.DanmuItem;
import com.yy.mobile.ui.basicgunview.danmuopengl.util.MatrixUtils;
import com.yy.mobile.ui.basicgunview.danmuopengl.util.ShaderUtils;
import com.yy.mobile.ui.basicgunview.newgunpower.IDanmuSwitchListener;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class DanmakuRenderer
implements GLTextureView.Renderer {
    private static final String TAG = "DanmakuRenderer";
    private CopyOnWriteArrayList<DanmuItem> mDanmakus = new CopyOnWriteArrayList();
    private Context mContext;
    private RenderListener mListener;
    private String mVertexShader;
    private String mFragmentShader;
    private int mViewWidth;
    private int mViewHeight;
    private int mSpeed;
    private int screenWidth;
    private List<DanmuItem> mShouldRemove = new ArrayList<DanmuItem>();
    private boolean isOpenCloseSwitch = false;
    private int frameRate = 25;

    public DanmakuRenderer(Context context, final DanmakuView danmakuView) {
        this.mContext = context.getApplicationContext();
        if (danmakuView != null) {
            danmakuView.setOnSwitchListener(new IDanmuSwitchListener(){

                @Override
                public void openSwitch() {
                    DanmakuRenderer.this.isOpenCloseSwitch = true;
                }

                @Override
                public void closeSwitch() {
                    DanmakuRenderer.this.isOpenCloseSwitch = false;
                    danmakuView.queueEvent(new Runnable(){

                        @Override
                        public void run() {
                            DanmakuRenderer.this.clearDanmuKu();
                        }
                    });
                }
            });
        }
    }

    public void setListener(RenderListener listener) {
        this.mListener = listener;
    }

    public void setSpeed(int speed) {
        this.mSpeed = speed;
    }

    public void setScreenWidth(int screenWidth) {
        this.screenWidth = screenWidth;
    }

    public void setOffsetX(int detalOffset) {
    }

    public void addDanmaku(DanmuItem danmaku) {
        danmaku.setShader(this.mVertexShader, this.mFragmentShader);
        danmaku.setViewSize(this.mViewWidth, this.mViewHeight);
        this.mDanmakus.add(danmaku);
    }

    public CopyOnWriteArrayList<DanmuItem> getmDanmakus() {
        return this.mDanmakus;
    }

    public synchronized void clearDanmuKu() {
        if (this.mDanmakus != null) {
            for (int i2 = 0; i2 < this.mDanmakus.size(); ++i2) {
                this.mDanmakus.get(i2).recyle();
            }
            this.mDanmakus.clear();
        }
    }

    @Override
    public void onSurfaceCreated(GL10 gl10, EGLConfig eglConfig) {
        GLES20.glEnable((int)2884);
        GLES20.glCullFace((int)1028);
        GLES20.glEnable((int)3042);
        GLES20.glBlendFunc((int)770, (int)771);
        this.mVertexShader = ShaderUtils.loadFromAssetsFile("vertex.sh", this.mContext.getResources());
        this.mFragmentShader = ShaderUtils.loadFromAssetsFile("frag.sh", this.mContext.getResources());
    }

    @Override
    public void onSurfaceChanged(GL10 gl10, int width, int height) {
        this.mViewWidth = width;
        this.mViewHeight = height;
        GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
        MatrixUtils.setProjectOrtho(-1.0f, 1.0f, -1.0f, 1.0f, 0.0f, 1.0f);
        MatrixUtils.setCamera(0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        if (this.mListener != null) {
            this.mListener.onInited();
        }
        if (this.mDanmakus != null && this.mDanmakus.size() > 0) {
            for (int i2 = 0; i2 < this.mDanmakus.size(); ++i2) {
                DanmuItem danmaku = this.mDanmakus.get(i2);
                danmaku.setViewSize(width, height);
                danmaku.initVertexData();
            }
        }
    }

    @Override
    public void onDrawFrame(GL10 gl10) {
        long currentTime = SystemClock.elapsedRealtime();
        float intervalTime = (float)this.frameRate / 1000.0f;
        float detalOffset = (float)this.mSpeed * intervalTime;
        this.clearCanvas();
        if (this.mDanmakus != null && this.mDanmakus.size() > 0) {
            int size = this.mDanmakus.size();
            try {
                for (int i2 = 0; i2 < size && this.isOpenCloseSwitch; ++i2) {
                    DanmuItem danmaku = this.mDanmakus.get(i2);
                    if (danmaku == null) continue;
                    float newOffset = detalOffset + danmaku.getCurrentOffsetX();
                    danmaku.setOffsetX(newOffset);
                    if (newOffset <= (float)(this.mViewWidth + danmaku.getBitmapWidth())) {
                        if (!this.isOpenCloseSwitch) continue;
                        danmaku.drawDanmaku();
                        continue;
                    }
                    this.mShouldRemove.add(danmaku);
                    danmaku.recyle();
                }
                this.mListener.onOpenDanmuSwitch();
                this.mListener.onListInit(this.mDanmakus);
            }
            catch (IndexOutOfBoundsException e2) {
                MLog.error((Object)TAG, (String)"", (Object[])new Object[0]);
            }
            this.mDanmakus.removeAll(this.mShouldRemove);
            this.mShouldRemove.clear();
        } else {
            this.mListener.onInitDrawMode();
        }
        long dt = SystemClock.elapsedRealtime() - currentTime;
        if (dt < (long)this.frameRate) {
            this.waitForSync((long)this.frameRate - dt);
        }
    }

    public void waitForSync(long t) {
        try {
            Thread.sleep(t);
        }
        catch (InterruptedException e2) {
            MLog.error((Object)TAG, (String)"printStackTrace", (Throwable)e2, (Object[])new Object[0]);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void onSurfaceDestroyed(GL10 gl) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"onSurfaceDestroyed", (Object[])new Object[0]);
        }
    }

    public void clearCanvas() {
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES20.glClear((int)16640);
    }

    public static interface RenderListener {
        public void onInited();

        public void onOpenDanmuSwitch();

        public void onInitDrawMode();

        public void onListInit(CopyOnWriteArrayList<DanmuItem> var1);
    }
}

