/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicfunction.report;

import android.annotation.TargetApi;
import android.app.Activity;
import android.os.Build;
import com.yymobile.core.ICoreManagerBase;
import java.lang.ref.WeakReference;

public abstract class BaseModule {
    private static final String TAG = "BaseModule";
    private WeakReference<Activity> mActivity;

    public BaseModule(Activity activity) {
        this.mActivity = new WeakReference<Activity>(activity);
        ICoreManagerBase.addClient(this);
    }

    @TargetApi(value=17)
    protected boolean checkActivityValid() {
        if (this.mActivity == null) {
            return false;
        }
        Activity activity = (Activity)this.mActivity.get();
        if (activity == null) {
            return false;
        }
        if (activity.isFinishing()) {
            return false;
        }
        return Build.VERSION.SDK_INT < 17 || !activity.isDestroyed();
    }

    public Activity getActivity() {
        if (this.mActivity == null) {
            return null;
        }
        return (Activity)this.mActivity.get();
    }

    public void destroy() {
        if (this.mActivity != null) {
            this.mActivity = null;
        }
        ICoreManagerBase.removeClient(this);
    }
}

