/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicchanneltemplate.component;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import com.yy.mobile.ui.basicchanneltemplate.component.IComponent;
import com.yy.mobile.ui.basicchanneltemplate.component.IComponentBehavior;
import com.yy.mobile.ui.basicchanneltemplate.component.IComponentContainer;
import com.yy.mobile.ui.basicchanneltemplate.component.IComponentRoot;
import com.yy.mobile.ui.basicchanneltemplate.component.IPopupComponent;
import com.yy.mobile.util.DontProguardClass;
import java.util.List;

@DontProguardClass
public abstract class AbstractComponentRoot
implements IComponentRoot {
    private FragmentManager mFragmentManager;

    public AbstractComponentRoot(FragmentManager mFragmentManager) {
        this.mFragmentManager = mFragmentManager;
    }

    @Override
    public void applyContainer(int locationId, IComponentContainer container) {
        this.onAttachToTemplate();
        int enterAnim = container.customEnterAnimation();
        int exitAnim = container.customExitAnimation();
        int transit = container.getTransition();
        FragmentTransaction transaction = this.mFragmentManager.beginTransaction();
        if (enterAnim != 0 || exitAnim != 0) {
            transaction.setCustomAnimations(enterAnim, exitAnim);
        }
        if (transit != 0) {
            transaction.setTransition(transit);
        }
        transaction.replace(locationId, container.getContent()).commitAllowingStateLoss();
    }

    @Override
    public void onContainerApplyDone() {
    }

    @Override
    public <T extends IComponentBehavior> T getComponentBehavior(Class<T> clazz) {
        List<IComponent> components = this.getComponents();
        for (IComponent component : components) {
            Class<?>[] interfaces;
            for (Class<?> interfaceClazz : interfaces = component.getClass().getInterfaces()) {
                if (interfaceClazz != clazz) continue;
                return (T)((IComponentBehavior)((Object)component));
            }
        }
        return null;
    }

    @Override
    public void showPopupComponent(IPopupComponent popupComponent) {
        this.showPopupComponent(popupComponent, null);
    }

    @Override
    public void showPopupComponent(IPopupComponent popupComponent, Bundle bundle) {
        if (popupComponent != null && !popupComponent.isShowing()) {
            popupComponent.show(this.mFragmentManager, bundle);
            popupComponent.setTemplate(this);
        }
    }

    @Override
    public void hidePopComponent(Class<? extends IPopupComponent> clz) {
        IPopupComponent ret;
        if (clz != null && (ret = (IPopupComponent)this.mFragmentManager.findFragmentByTag(clz.getCanonicalName())) != null) {
            ret.hide();
        }
    }

    @Override
    @Nullable
    public <T extends IComponent> T findComponent(Class<T> clazz) {
        return this.getContainer().getComponent(clazz);
    }

    @Override
    public <T extends IComponent> T obtainComponent(Class<T> clazz) {
        return this.getContainer().obtainComponent(clazz);
    }

    @Override
    public <T extends IComponent> T obtainComponent(Class<T> clazz, Bundle bundle) {
        return this.getContainer().obtainComponent(clazz, bundle);
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        List<IComponent> componentList;
        if (this.getContent() != null) {
            this.getContent().onActivityResult(requestCode, resultCode, data);
        }
        if ((componentList = this.getComponents()) != null && componentList.size() > 0) {
            for (IComponent component : componentList) {
                if (component == null) continue;
                component.onActivityResult(requestCode, resultCode, data);
            }
        }
    }

    @Override
    public FragmentManager getFragmentManager() {
        return this.mFragmentManager;
    }

    @Override
    public void clear() {
        this.onDetachFromTemplate();
    }
}

