/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.activity;

import android.app.Activity;
import android.support.annotation.NonNull;
import com.yy.mobile.util.log.MLog;

class BaseActivityProxy {
    private static final String TAG = "BaseActivityProxy";
    @NonNull
    private final Activity mActivity;
    private final Class<? extends Activity> mLastActivityClass;
    private boolean mIsResumed = false;

    BaseActivityProxy(@NonNull Activity activity, Class<? extends Activity> lastActivityClass) {
        this.mActivity = activity;
        this.mLastActivityClass = lastActivityClass;
    }

    @NonNull
    public Activity getActivity() {
        return this.mActivity;
    }

    Class<? extends Activity> getLastActivityClass() {
        return this.mLastActivityClass;
    }

    public void onCreate() {
    }

    public void onResume() {
        MLog.info((Object)TAG, (String)"onResume, activity: %s", (Object[])new Object[]{this.mActivity});
        this.mIsResumed = true;
    }

    public void onPause() {
        MLog.info((Object)TAG, (String)"onPause, activity: %s", (Object[])new Object[]{this.mActivity});
        this.mIsResumed = false;
    }

    public boolean isResumed() {
        return this.mIsResumed;
    }
}

