/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core.mobilelive;

import com.yy.mobile.util.log.MLog;
import com.yy.mobile.yyprotocol.core.ByteString;
import com.yy.mobile.yyprotocol.core.MarshalContainer;
import com.yy.mobile.yyprotocol.core.Marshallable;
import com.yy.mobile.yyprotocol.core.Pack;
import com.yy.mobile.yyprotocol.core.Uint16;
import com.yy.mobile.yyprotocol.core.Uint32;
import com.yy.mobile.yyprotocol.core.UnmarshalContainer;
import com.yy.mobile.yyprotocol.core.Unpack;
import com.yymobile.core.MobileServers;
import com.yymobile.core.ent.protos.IEntProtocol;
import com.yymobile.core.ent.v2.ProtosMapperV2;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MobileLiveReplayProtocol {
    public static void registerProtocols() {
        ProtosMapperV2 v2 = ProtosMapperV2.getInstanceByServiceApp(MobileServers.sMobileSrv);
        v2.add(PMobileLiveReplayFlowReq.class, PMobileLiveReplayFlowRes.class, PMobileLiveReplaySnapReq.class, PMobileLiveReplaySnapRes.class);
    }

    private static String utf16Decode(byte[] bytes) throws UnsupportedEncodingException {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        String str = new String(buffer.array(), "utf-16LE");
        return str;
    }

    public static class TextChatMarshallable
    implements Marshallable,
    Serializable {
        public Uint32 effects = new Uint32(0);
        public String name;
        public Uint32 clr = new Uint32(0);
        public Uint32 height = new Uint32(0);
        public String msg;
        public Uint32 sd = new Uint32(0);

        public void marshall(Pack pack) {
        }

        public void unmarshall(Unpack up) {
            try {
                this.effects = up.popUint32();
                this.name = MobileLiveReplayProtocol.utf16Decode(up.popBytes32());
                this.clr = up.popUint32();
                this.height = up.popUint32();
                this.msg = MobileLiveReplayProtocol.utf16Decode(up.popBytes32());
                this.sd = up.popUint32();
            }
            catch (OutOfMemoryError e2) {
                MLog.error((Object)"MobileLiveReplayProtocol", (String)"Out of memory error: %s", (Object[])new Object[]{this, e2});
            }
            catch (Throwable e3) {
                MLog.error((Object)"MobileLiveReplayProtocol", (String)"printStackTrace", (Throwable)e3, (Object[])new Object[0]);
            }
        }

        public String toString() {
            return "MobileLiveReplayFlowMarshall { effects = " + this.effects + ", name = " + this.name + ", clr = " + this.clr + ", height = " + this.height + ", msg = " + this.msg + ", sd = " + this.sd + " }";
        }
    }

    public static class PTextChatServiceMarshall
    implements Marshallable,
    Serializable {
        public Uint32 from = new Uint32(0);
        public Uint32 topsid = new Uint32(0);
        public Uint32 sid = new Uint32(0);
        public TextChatMarshallable textChat = new TextChatMarshallable();
        public byte[] reserver1;
        public byte[] reserver2;
        public String nick;
        public Map<Uint16, byte[]> extendInfo = new HashMap<Uint16, byte[]>();

        public void marshall(Pack pack) {
        }

        public void unmarshall(Unpack up) {
            int mLen = up.popInt();
            int mUri = up.popInt();
            short mRes = up.popUint16().shortValue();
            this.from = up.popUint32();
            this.topsid = up.popUint32();
            this.sid = up.popUint32();
            this.textChat.unmarshall(new Unpack(up.popBytes()));
            this.reserver1 = up.popBytes();
            this.reserver2 = up.popBytes();
            this.nick = up.popString();
            UnmarshalContainer.unmarshalMapUint16Bytes((Unpack)up, this.extendInfo);
        }

        public String toString() {
            return "MobileLiveReplayFlowMarshall { from = " + this.from + ", topsid = " + this.topsid + ", sid = " + this.sid + ", textChat = " + this.textChat + ", nick = " + this.textChat + ", extendInfo = " + this.extendInfo + " }";
        }
    }

    public static class MobileLiveReplaySnapMarshall
    implements Marshallable,
    Serializable {
        public Uint32 type = new Uint32(0);
        public String content;
        public Uint32 snapTime = new Uint32(0);

        public void marshall(Pack pack) {
        }

        public void unmarshall(Unpack up) {
            this.type = up.popUint32();
            this.content = up.popString();
            this.snapTime = up.popUint32();
        }

        public String toString() {
            return "MobileLiveReplaySnapMarshall{type=" + this.type + ", content='" + this.content + '\'' + ", snapTime=" + this.snapTime + '}';
        }
    }

    public static class MobileLiveReplayFlowMarshall
    implements Marshallable,
    Serializable {
        public String appid;
        public Uint32 max = new Uint32(0);
        public Uint32 min = new Uint32(0);
        public byte[] content;
        public Uint32 ctime;
        public Map<String, String> extendInfo = new HashMap<String, String>();

        public void marshall(Pack pack) {
        }

        public void unmarshall(Unpack up) {
            this.appid = up.popString();
            this.max = up.popUint32();
            this.min = up.popUint32();
            this.content = up.popBytes();
            this.ctime = up.popUint32();
            UnmarshalContainer.unmarshalMapStringString((Unpack)up, this.extendInfo);
        }

        public String toString() {
            return "MobileLiveReplayFlowMarshall { appid = " + this.appid + ", max = " + this.max + ", min = " + this.min + ", ctime = " + this.ctime + " }";
        }
    }

    public static class MobileLiveReplayTypeMarshall
    implements Marshallable,
    Serializable {
        public String appid;
        public Uint32 max = new Uint32(0);
        public Uint32 min = new Uint32(0);

        public MobileLiveReplayTypeMarshall(String appid, Uint32 max, Uint32 min) {
            this.appid = appid;
            this.max = max;
            this.min = min;
        }

        public void marshall(Pack pack) {
            pack.push(this.appid);
            pack.push(this.max);
            pack.push(this.min);
        }

        public void unmarshall(Unpack up) {
        }

        public String toString() {
            return "MobileLiveReplayTypeMarshall { appid = " + this.appid + ", max = " + this.max + ", min = " + this.min + " }";
        }
    }

    public static class PMobileLiveReplaySnapRes
    implements IEntProtocol {
        public static final Uint32 sMaxType = MsgMaxType.REPLAY_MAX;
        public static final Uint32 sMinType = MsgMinType.REPLAY_SNAP_RES;
        public Uint32 result = new Uint32(0);
        public List<MobileLiveReplaySnapMarshall> snaps = new ArrayList<MobileLiveReplaySnapMarshall>();
        public Map<String, String> extendInfo = new HashMap<String, String>();

        @Override
        public Uint32 getMaxType() {
            return sMaxType;
        }

        @Override
        public Uint32 getMinType() {
            return sMinType;
        }

        public void toString(ByteString bs) {
        }

        public void unString(ByteString bs) {
            Unpack unpack = new Unpack(bs.getBytes());
            this.result = unpack.popUint32();
            UnmarshalContainer.unmarshalColMarshallable((Unpack)unpack, this.snaps, MobileLiveReplaySnapMarshall.class);
            UnmarshalContainer.unmarshalMapStringString((Unpack)unpack, this.extendInfo);
        }

        public String toString() {
            return "PMobileLiveReplaySnapRes { result = " + this.result + ", snaps = " + this.snaps + ", extendInfo = " + this.extendInfo + " }";
        }
    }

    public static class PMobileLiveReplaySnapReq
    implements IEntProtocol {
        public static final Uint32 sMaxType = MsgMaxType.REPLAY_MAX;
        public static final Uint32 sMinType = MsgMinType.REPLAY_SNAP_REQ;
        public List<Uint32> types = new ArrayList<Uint32>();
        public Uint32 tid = new Uint32(0);
        public Uint32 sid = new Uint32(0);
        public String pid;
        public Uint32 startTime = new Uint32(0);
        public Uint32 endTime = new Uint32(0);
        public Map<String, String> extendInfo = new HashMap<String, String>();

        @Override
        public Uint32 getMaxType() {
            return sMaxType;
        }

        @Override
        public Uint32 getMinType() {
            return sMinType;
        }

        public void toString(ByteString bs) {
            Pack pack = new Pack();
            MarshalContainer.marshalColUint32((Pack)pack, this.types);
            pack.push(this.tid);
            pack.push(this.sid);
            pack.push(this.pid);
            pack.push(this.startTime);
            pack.push(this.endTime);
            MarshalContainer.marshalMapStringString((Pack)pack, this.extendInfo);
            bs.setBytes(pack.toBytes());
        }

        public void unString(ByteString bs) {
        }

        public String toString() {
            return "PMobileLiveReplaySnapReq { types = " + this.types + ", tid = " + this.tid + ", sid = " + this.sid + ", pid = " + this.pid + ", startTime = " + this.startTime + ", endTime = " + this.endTime + ", extendInfo = " + this.extendInfo + " }";
        }
    }

    public static class PMobileLiveReplayFlowRes
    implements IEntProtocol {
        public static final Uint32 sMaxType = MsgMaxType.REPLAY_MAX;
        public static final Uint32 sMinType = MsgMinType.REPLAY_FLOW_RES;
        public Uint32 result = new Uint32(0);
        public List<MobileLiveReplayFlowMarshall> flows = new ArrayList<MobileLiveReplayFlowMarshall>();
        public Map<String, String> extendInfo = new HashMap<String, String>();

        @Override
        public Uint32 getMaxType() {
            return sMaxType;
        }

        @Override
        public Uint32 getMinType() {
            return sMinType;
        }

        public void toString(ByteString bs) {
        }

        public void unString(ByteString bs) {
            Unpack unpack = new Unpack(bs.getBytes());
            this.result = unpack.popUint32();
            UnmarshalContainer.unmarshalColMarshallable((Unpack)unpack, this.flows, MobileLiveReplayFlowMarshall.class);
            UnmarshalContainer.unmarshalMapStringString((Unpack)unpack, this.extendInfo);
        }

        public String toString() {
            return "PMobileLiveReplayFlowRes { result = " + this.result + ", flows =  size :" + this.flows.size() + " " + this.flows + ", extendInfo = " + this.extendInfo + " }";
        }
    }

    public static class PMobileLiveReplayFlowReq
    implements IEntProtocol {
        public static final Uint32 sMaxType = MsgMaxType.REPLAY_MAX;
        public static final Uint32 sMinType = MsgMinType.REPLAY_FLOW_REQ;
        public List<MobileLiveReplayTypeMarshall> types = new ArrayList<MobileLiveReplayTypeMarshall>();
        public Uint32 limit = new Uint32(0);
        public Uint32 tid = new Uint32(0);
        public Uint32 sid = new Uint32(0);
        public String pid;
        public Uint32 startTime = new Uint32(0);
        public Uint32 endTime = new Uint32(0);
        public Map<String, String> extendInfo = new HashMap<String, String>();

        @Override
        public Uint32 getMaxType() {
            return sMaxType;
        }

        @Override
        public Uint32 getMinType() {
            return sMinType;
        }

        public void toString(ByteString bs) {
            Pack pack = new Pack();
            MarshalContainer.marshalColMarshallable((Pack)pack, this.types);
            pack.push(this.limit);
            pack.push(this.tid);
            pack.push(this.sid);
            pack.push(this.pid);
            pack.push(this.startTime);
            pack.push(this.endTime);
            MarshalContainer.marshalMapStringString((Pack)pack, this.extendInfo);
            bs.setBytes(pack.toBytes());
        }

        public void unString(ByteString bs) {
        }

        public String toString() {
            return "PMobileLiveReplayFlowReq { type = " + this.types + ", limit = " + this.limit + ", tid = " + this.tid + ", sid = " + this.sid + ", pid = " + this.pid + ", startTime = " + this.startTime + ", endTime = " + this.endTime + ", extendInfo = " + this.extendInfo + " }";
        }
    }

    public static class MsgMinType {
        public static final Uint32 REPLAY_SNAP_REQ = new Uint32(61);
        public static final Uint32 REPLAY_SNAP_RES = new Uint32(62);
        public static final Uint32 REPLAY_FLOW_REQ = new Uint32(63);
        public static final Uint32 REPLAY_FLOW_RES = new Uint32(64);
    }

    public static final class MsgMaxType {
        public static final Uint32 REPLAY_MAX = new Uint32(3306);
    }
}

