/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicgunview.danmuopengl;

import android.content.Context;
import android.content.res.Configuration;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.ui.basicgunview.IDanmukuView;
import com.yy.mobile.ui.basicgunview.danmuopengl.DanmakuRenderer;
import com.yy.mobile.ui.basicgunview.danmuopengl.GLTextureView;
import com.yy.mobile.ui.basicgunview.danmuopengl.gunpower.DanMuItemStub;
import com.yy.mobile.ui.basicgunview.danmuopengl.gunpower.DanmuItem;
import com.yy.mobile.ui.basicgunview.danmuopengl.util.TexturePool;
import com.yy.mobile.ui.basicgunview.newgunpower.GunNewPower;
import com.yy.mobile.ui.basicgunview.newgunpower.IDanmuClickListener;
import com.yy.mobile.ui.basicgunview.newgunpower.IDanmuOpenStatus;
import com.yy.mobile.ui.basicgunview.newgunpower.IDanmuSwitchListener;
import com.yy.mobile.ui.utils.DimensUtils;
import com.yy.mobile.util.DimenConverter;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.asynctask.ScheduledTask;
import com.yy.mobile.util.log.MLog;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class DanmakuView
extends GLTextureView
implements IDanmukuView {
    private static final String TAG = "ZGDanmakuView";
    private Context mContext;
    private DanmakuRenderer mRenderer;
    private int gapLine = 3;
    private float mLineSpace;
    private static final int DEFAULT_TOP_MARGIN = DimenConverter.dip2px((Context)BasicConfig.getInstance().getAppContext(), (float)4.0f);
    private int kTopMargin = DEFAULT_TOP_MARGIN;
    private boolean isInited = false;
    private boolean isPaused = false;
    private Map<Integer, DanmuItem> mLinesAvaliable;
    private HashMap<Integer, Boolean> hashMap = new HashMap();
    private ScheduledTask scheduledTask;
    private ScheduledTask touchTask;
    private AtomicBoolean mOnOff = new AtomicBoolean(false);
    private IDanmuOpenStatus danmuOpenStatus;
    private IDanmuSwitchListener switchListener;
    private IDanmuClickListener listener;
    public float width = 0.0f;
    private static int FRAME_RATE = 20;
    private int mtime = 4000;
    private CopyOnWriteArrayList<DanmuItem> danmuItemList = new CopyOnWriteArrayList();
    private Runnable scheduRunnable = new Runnable(){

        @Override
        public void run() {
            if (DanmakuView.this.danmuOpenStatus != null) {
                DanmakuView.this.danmuOpenStatus.getGunPower(DanmakuView.this.hashMap);
            }
            if (DanmakuView.this.scheduledTask != null) {
                DanmakuView.this.scheduledTask.scheduledDelayed(DanmakuView.this.scheduRunnable, 500L);
            }
        }
    };
    private Runnable touchRunnable = new Runnable(){

        @Override
        public void run() {
            if (DanmakuView.this.danmuItemList != null && DanmakuView.this.danmuItemList.size() > 0) {
                DanmakuView.this.touchTask.scheduledDelayed(new Runnable(){

                    @Override
                    public void run() {
                        for (DanmuItem point : DanmakuView.this.danmuItemList) {
                            float x = DanmakuView.this.width - point.offsetX;
                            if (!((float)DanmakuView.this.tx > x) || !((float)DanmakuView.this.tx < x + (float)point.bitmapWidth) || !((float)DanmakuView.this.ty > point.offsetY) || !((float)DanmakuView.this.ty < point.offsetY + (float)point.bitmapHeight) || !NetworkUtils.isNetworkStrictlyAvailable((Context)BasicConfig.getInstance().getAppContext()) || DanmakuView.this.listener == null) continue;
                            DanmakuView.this.listener.setOnClickListener(new DanMuItemStub(point.gunId, point.senderUid, point.content));
                        }
                    }
                }, 0L);
            }
        }
    };
    int tx = 0;
    int ty = 0;
    private HashMap<Integer, Integer> levelMap = new HashMap();

    @Override
    public void showView(ViewGroup root, RelativeLayout.LayoutParams params) {
    }

    @Override
    public void hideView(ViewGroup root) {
    }

    public DanmakuView(Context context) {
        super(context);
        this.init(context);
    }

    public DanmakuView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        this.mContext = context.getApplicationContext();
        MLog.info((Object)TAG, (String)"DanmukuView init sucess", (Object[])new Object[0]);
        this.mLinesAvaliable = new HashMap<Integer, DanmuItem>();
        this.setEGLContextClientVersion(2);
        this.setEGLConfigChooser(8, 8, 8, 8, 16, 0);
        this.mRenderer = new DanmakuRenderer(context, this);
        this.setRenderer(this.mRenderer);
        this.setRenderMode(0);
        this.setOpaque(false);
        int drawWidth = context.getResources().getDisplayMetrics().widthPixels;
        this.setDrawWidth(drawWidth);
        this.setSpeed(120.0f);
        this.setDrawTime(4000);
        this.setLineSpace(4);
        int offsetX = FRAME_RATE * drawWidth / this.mtime;
        this.setOffsetX(offsetX);
        this.mRenderer.setListener(new DanmakuRenderer.RenderListener(){

            @Override
            public void onInited() {
                DanmakuView.this.isInited = true;
            }

            @Override
            public void onOpenDanmuSwitch() {
                DanmakuView.this.getAvaliableLine();
            }

            @Override
            public void onInitDrawMode() {
                DanmakuView.this.setRenderMode(0);
            }

            @Override
            public void onListInit(CopyOnWriteArrayList<DanmuItem> list) {
                if (list != null && DanmakuView.this.danmuItemList != null) {
                    if (DanmakuView.this.danmuItemList.size() > 0) {
                        DanmakuView.this.danmuItemList.clear();
                    }
                    DanmakuView.this.danmuItemList.addAll(list);
                    if (list.size() == 0) {
                        DanmakuView.this.setRenderMode(0);
                    }
                }
            }
        });
        for (int i2 = 0; i2 < this.gapLine; ++i2) {
            this.levelMap.put(i2, 1);
        }
    }

    @Override
    public void setScreenWidth(float width) {
        this.width = width;
    }

    public void setDrawWidth(int width) {
        this.mRenderer.setScreenWidth(width);
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        int drawWidth = this.mContext.getResources().getDisplayMetrics().widthPixels;
        if (newConfig.orientation == 2) {
            drawWidth = this.mContext.getResources().getDisplayMetrics().widthPixels - DimenConverter.dip2px((Context)this.mContext, (float)96.0f);
        }
        this.setDrawWidth(drawWidth);
        int offsetX = FRAME_RATE * drawWidth / this.mtime;
        this.setOffsetX(offsetX);
    }

    public void initFlag() {
        if (this.hashMap.size() > 0) {
            this.hashMap.clear();
        }
        for (int i2 = 0; i2 < this.gapLine; ++i2) {
            this.hashMap.put(i2, true);
        }
    }

    private void onBarrageSwitch(boolean on) {
        if (on) {
            this.mOnOff.set(true);
            if (this.switchListener != null) {
                this.switchListener.openSwitch();
            }
            this.initFlag();
            if (this.scheduledTask == null) {
                this.scheduledTask = ScheduledTask.getInstance();
            }
            this.scheduledTask.scheduledDelayed(this.scheduRunnable, 0L);
            if (this.touchTask == null) {
                this.touchTask = ScheduledTask.getInstance();
            }
        } else {
            this.mOnOff.set(false);
            if (this.switchListener != null) {
                this.switchListener.closeSwitch();
            }
            this.initFlag();
            if (this.mLinesAvaliable != null) {
                this.mLinesAvaliable.clear();
            }
            if (this.scheduledTask != null) {
                this.scheduledTask.removeCallbacks(this.scheduRunnable);
            }
            if (this.touchTask != null) {
                this.touchTask.removeCallbacks(this.touchRunnable);
            }
            if (this.danmuItemList != null && this.danmuItemList.size() > 0) {
                this.danmuItemList.clear();
            }
        }
    }

    public void initTexturePool() {
        TexturePool.uninit();
    }

    public void setOnSwitchListener(IDanmuSwitchListener listener) {
        this.switchListener = listener;
    }

    @Override
    public boolean onDanmuSwitch() {
        return this.mOnOff.get();
    }

    @Override
    public void setOpenView() {
        this.onBarrageSwitch(true);
    }

    @Override
    public void setCloseView() {
        this.onBarrageSwitch(false);
    }

    public int getTopMargin() {
        return this.kTopMargin;
    }

    @Override
    public void onResume() {
        super.onResume();
        MLog.info((Object)TAG, (String)"DanmukuView onResume sucess", (Object[])new Object[0]);
        this.isPaused = false;
    }

    @Override
    public void onPause() {
        super.onPause();
        MLog.info((Object)TAG, (String)"DanmukuView onPause sucess", (Object[])new Object[0]);
        this.isPaused = true;
    }

    @Override
    public void onDestory() {
        if (this.scheduledTask != null) {
            this.scheduledTask.removeCallbacks(this.scheduRunnable);
        }
        if (this.touchTask != null) {
            this.touchTask.removeCallbacks(this.touchRunnable);
        }
    }

    private synchronized boolean getAvaliableLine(int position) {
        if (position > this.gapLine) {
            return false;
        }
        if (this.mLinesAvaliable.get(position) == null) {
            this.setCheckStatus(position, true);
            return true;
        }
        DanmuItem danmaku = this.mLinesAvaliable.get(position);
        if (danmaku.getCurrentOffsetX() > (float)danmaku.getBitmapWidth()) {
            this.setCheckStatus(position, true);
            return true;
        }
        this.setCheckStatus(position, false);
        return false;
    }

    private synchronized void getAvaliableLine() {
        for (int i2 = 0; i2 < this.gapLine; ++i2) {
            if (this.mLinesAvaliable.get(i2) == null) {
                this.setCheckStatus(i2, true);
                continue;
            }
            DanmuItem danmaku = this.mLinesAvaliable.get(i2);
            if (danmaku == null) {
                this.setCheckStatus(i2, true);
                continue;
            }
            if (danmaku.getCurrentOffsetX() > (float)danmaku.getBitmapWidth()) {
                this.setCheckStatus(i2, true);
                continue;
            }
            this.setCheckStatus(i2, false);
        }
    }

    @Override
    public void setSpeed(float speed) {
        int pxSpeed = DimensUtils.dip2pixel((Context)this.mContext, (float)speed);
        this.mRenderer.setSpeed(pxSpeed);
    }

    @Override
    public void setDrawTime(int time) {
        this.mtime = time;
    }

    public void setOffsetX(int time) {
        this.mRenderer.setOffsetX(time);
    }

    @Override
    public void setLines(int lines) {
        this.gapLine = lines;
        for (int i2 = 0; i2 < this.gapLine; ++i2) {
            this.levelMap.put(i2, 1);
        }
    }

    @Override
    public int getLines() {
        return this.gapLine;
    }

    @Override
    public void setLineSpace(int lineSpace) {
        float pxLineSpace;
        this.mLineSpace = pxLineSpace = (float)DimensUtils.dip2pixel((Context)this.mContext, (float)lineSpace);
    }

    public synchronized void setCheckStatus(int position, boolean isOpen) {
        if (position < this.gapLine) {
            this.hashMap.put(position, isOpen);
        } else {
            MLog.error((Object)TAG, (String)("getLineStatus is line > gapLine , gapLine " + this.gapLine), (Object[])new Object[0]);
        }
    }

    @Override
    public synchronized void sendGunPower(GunNewPower gun, int position) {
        if (gun == null || position < 0 || position >= this.gapLine) {
            return;
        }
        if (this.mOnOff.get() && this.getAvaliableLine(position) && gun != null && gun.bitmap != null) {
            this.setCheckStatus(position, false);
            DanmuItem danmakuItem = new DanmuItem(gun.gunId, gun.senderUid, gun.bitmap, gun.content);
            this.mLinesAvaliable.put(position, danmakuItem);
            float offsetY = (float)(danmakuItem.getmViewHeight() * position) + this.mLineSpace;
            danmakuItem.setOffsetY(offsetY);
            this.mRenderer.addDanmaku(danmakuItem);
            this.setRenderMode(1);
            this.requestRender();
        }
    }

    @Override
    public void queryDanmuOpenStatus(IDanmuOpenStatus status) {
        this.danmuOpenStatus = status;
    }

    @Override
    public void setOnClickListener(IDanmuClickListener clickListener) {
        this.listener = clickListener;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 0) {
            this.tx = (int)event.getX();
            this.ty = (int)event.getY();
            if (this.touchTask != null) {
                this.touchTask.scheduledDelayed(this.touchRunnable, 0L);
            }
        }
        return false;
    }

    @Override
    public synchronized HashMap<Integer, Integer> getLevelMap() {
        return this.levelMap;
    }

    @Override
    public synchronized void setLevelMap(int index, int level) {
        this.levelMap.put(index, level);
    }

    @Override
    public void setDanMuAlpha(int alpha) {
    }
}

