/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core.subscribe;

import android.content.Context;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.ui.pop.IGuidePop;
import com.yy.mobile.util.VersionUtil;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;
import com.yymobile.core.ICoreManagerBase;
import java.util.Calendar;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONException;

public class SubscribedNotifyOpenPushPermissionManager {
    private static final String TAG = "SubscribedNotifyOpenPushPermissionManager";
    public static final String EVENT_ID_OPEN_PUSH_POPUPDIALOG = "51204";
    public static final String EVENT_LABEL_CLICK_OPEN_PUSH = "0002";
    public static final String EVENT_LABEL_CLICK_CANCEL = "0003";
    public static final String EVENT_LABEL_SHOW_OPEN_PUSH_POPUPDIALOG = "0001";
    public static final String LAST_VERSION = "lastVersion";
    public static final String TOTAL_SHOW_SUBSCRIBED_DIALOG = "total_show_subscribed_dialog";
    public static final String LAST_TIME_TO_SHOW_DIALOG = "last_time_to_show_dialog";
    public static final String SUBSCRIBED_JSONARRAY = "subscribed_jsonarray";
    private static final int totalCnt = 3;
    private static final int noNotifyDay = 3;
    private static final int subscribeDay = 3;
    private static final int subscribeNum = 2;

    public static void showSubscribedNotifyDialog(Fragment fragment, long subscribedUid, String nickName, int fromScene) {
        IGuidePop iGuidePop = ICoreManagerBase.getCore(IGuidePop.class);
        if (iGuidePop != null) {
            iGuidePop.requestShowGuideDialog(fromScene, subscribedUid, nickName);
        }
    }

    private static boolean shouldShowSubscribedNotifyDialog() {
        boolean rule3;
        CommonPref pref = CommonPref.instance();
        SubscribedNotifyOpenPushPermissionManager.checkVersionChanged();
        int cnt = pref.getInt(TOTAL_SHOW_SUBSCRIBED_DIALOG, 0);
        boolean bl = rule3 = cnt <= 3;
        if (!rule3) {
            MLog.info((Object)TAG, (String)("showSubscribedNotifyDialog : rule3 = " + rule3), (Object[])new Object[0]);
            return false;
        }
        boolean rule1 = false;
        String jsonArray = pref.getString(SUBSCRIBED_JSONARRAY, "");
        try {
            if (!TextUtils.isEmpty((CharSequence)jsonArray)) {
                JSONArray array = new JSONArray(jsonArray);
                LinkedList<Long> time = new LinkedList<Long>();
                for (int i2 = 0; i2 < array.length(); ++i2) {
                    time.add(array.getLong(i2));
                }
                long newestTime = SubscribedNotifyOpenPushPermissionManager.getToday();
                int index = time.size();
                for (int i3 = 0; i3 < time.size(); ++i3) {
                    Long subTime = (Long)time.get(i3);
                    if (subTime >= newestTime) continue;
                    index = i3;
                    break;
                }
                if (index + 2 <= time.size()) {
                    long nDaysBefore;
                    long oldestTime = (Long)time.get(index + 2 - 1);
                    if (oldestTime >= (nDaysBefore = SubscribedNotifyOpenPushPermissionManager.getTheDaysBeforeToday(3))) {
                        rule1 = true;
                    }
                    JSONArray newArray = new JSONArray();
                    for (int i4 = 0; i4 < index + 2; ++i4) {
                        newArray.put(time.get(i4));
                    }
                    pref.putString(SUBSCRIBED_JSONARRAY, newArray.toString());
                }
            }
        }
        catch (JSONException e2) {
            MLog.error((Object)TAG, (Throwable)e2);
        }
        long lastTime = pref.getLong(LAST_TIME_TO_SHOW_DIALOG, 0L);
        long kDaysBefore = SubscribedNotifyOpenPushPermissionManager.getTheDaysBeforeToday(3);
        boolean rule2 = false;
        if (lastTime < kDaysBefore) {
            rule2 = true;
        }
        MLog.info((Object)TAG, (String)("showSubscribedNotifyDialog : rule1 = " + rule1 + " rule2 = " + rule2 + " rule3 = " + rule3), (Object[])new Object[0]);
        return rule1 && rule2;
    }

    public static void unSubscribeAnchor(long uid) {
    }

    private static boolean checkVersionChanged() {
        String versionNow = VersionUtil.getLocalVer((Context)BasicConfig.getInstance().getAppContext()).getVersionNameWithoutSnapshot();
        String lastVersion = CommonPref.instance().getString(LAST_VERSION);
        MLog.info((Object)TAG, (String)"versionNow: %s , lastVersion: %s", (Object[])new Object[]{versionNow, lastVersion});
        if (TextUtils.isEmpty((CharSequence)versionNow)) {
            return false;
        }
        if (!versionNow.equals(lastVersion)) {
            CommonPref.instance().putString(LAST_VERSION, versionNow);
            SubscribedNotifyOpenPushPermissionManager.cleanLastVersionData();
            return true;
        }
        return false;
    }

    private static void updateData() {
        CommonPref pref = CommonPref.instance();
        pref.putLong(LAST_TIME_TO_SHOW_DIALOG, System.currentTimeMillis());
        int time = pref.getInt(TOTAL_SHOW_SUBSCRIBED_DIALOG, 0);
        pref.putInt(TOTAL_SHOW_SUBSCRIBED_DIALOG, time + 1);
    }

    private static void cleanLastVersionData() {
        CommonPref pref = CommonPref.instance();
        pref.putInt(TOTAL_SHOW_SUBSCRIBED_DIALOG, 0);
        pref.putLong(LAST_TIME_TO_SHOW_DIALOG, 0L);
        pref.putString(SUBSCRIBED_JSONARRAY, "");
    }

    public static void addSubscibeToList() {
        JSONArray newArray;
        CommonPref pref;
        block5: {
            pref = CommonPref.instance();
            int time = pref.getInt(TOTAL_SHOW_SUBSCRIBED_DIALOG, 0);
            if (time > 3) {
                return;
            }
            long timeout = SubscribedNotifyOpenPushPermissionManager.getTheDaysBeforeToday(4);
            String json = pref.getString(SUBSCRIBED_JSONARRAY, "");
            newArray = new JSONArray();
            newArray.put(System.currentTimeMillis());
            try {
                if (TextUtils.isEmpty((CharSequence)json)) break block5;
                JSONArray array = new JSONArray(json);
                for (int i2 = 0; i2 < array.length(); ++i2) {
                    long subscribeTime = array.getLong(i2);
                    newArray.put(subscribeTime);
                    if (subscribeTime >= timeout) {
                        continue;
                    }
                    break;
                }
            }
            catch (JSONException e2) {
                MLog.error((Object)TAG, (Throwable)e2);
            }
        }
        pref.putString(SUBSCRIBED_JSONARRAY, newArray.toString());
    }

    private static long getToday() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTimeInMillis();
    }

    private static long getTheDaysBeforeToday(int nDaysBefore) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -nDaysBefore);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTimeInMillis();
    }
}

