/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core.auth.bind;

import android.content.Context;
import com.yy.mobile.bizmodel.login.ThirdType;
import com.yy.mobile.share.BasePlatform;
import com.yy.mobile.share.BasePlatformActionListener;
import com.yy.mobile.util.log.MLog;
import com.yymobile.baseapi.R;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.auth.bind.FixThirdNickNameEmptyUtils;
import com.yymobile.core.user.Gender;
import com.yymobile.core.user.UserInfo;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;

public class ThirdPartyUserInfoListener
implements BasePlatformActionListener {
    private static final String TAG = "ThirdPartyUserInfoListener";
    private Context context;
    private ThirdType thirdType;
    private long userId;
    private String figureUrl;
    private Runnable connectNet = new Runnable(){

        @Override
        public void run() {
            try {
                if (ThirdPartyUserInfoListener.this.figureUrl != null) {
                    byte[] data = ThirdPartyUserInfoListener.this.getImage(ThirdPartyUserInfoListener.this.figureUrl);
                    MLog.info((Object)ThirdPartyUserInfoListener.TAG, (String)"ThirdPartyUserInfoListener connectNet data length:%d", (Object[])new Object[]{data.length});
                    UserInfo userInfo = new UserInfo();
                    userInfo.userId = ThirdPartyUserInfoListener.this.userId;
                    ICoreManagerBase.getUserCore().reqUploadPortrait(data, userInfo);
                }
                MLog.info((Object)ThirdPartyUserInfoListener.TAG, (String)"ThirdPartyUserInfoListener connectNet loadImage:%s", (Object[])new Object[]{ThirdPartyUserInfoListener.this.figureUrl});
            }
            catch (Exception e2) {
                MLog.error((Object)ThirdPartyUserInfoListener.TAG, (String)"ThirdPartyUserInfoListener connectNet exception! %s", (Object[])new Object[]{ThirdPartyUserInfoListener.this.figureUrl, e2});
            }
        }
    };

    public ThirdPartyUserInfoListener(Context c, long userId, ThirdType thirdType) {
        this.context = c;
        this.userId = userId;
        this.thirdType = thirdType;
    }

    @Override
    public void onComplete(BasePlatform platform, int i2, HashMap<String, Object> stringObjectHashMap) {
        MLog.info((Object)TAG, (String)"ThirdPartyUserInfoListener onComplete %s %d %s", (Object[])new Object[]{platform, i2, stringObjectHashMap});
        try {
            String genderStr;
            String nickName = "";
            Gender gender = Gender.Unknown;
            if (this.thirdType.equals((Object)ThirdType.QQ)) {
                nickName = (String)stringObjectHashMap.get("nickname");
                this.figureUrl = (String)stringObjectHashMap.get("figureurl_qq_2");
                genderStr = (String)stringObjectHashMap.get("gender");
                gender = genderStr.equals(this.context.getString(R.string.str_male)) ? Gender.Male : Gender.Female;
            } else if (this.thirdType.equals((Object)ThirdType.WECHAT)) {
                nickName = (String)stringObjectHashMap.get("nickname");
                genderStr = stringObjectHashMap.get("sex") + "";
                this.figureUrl = (String)stringObjectHashMap.get("headimgurl");
                gender = genderStr.equals("1") ? Gender.Male : Gender.Female;
            } else if (this.thirdType.equals((Object)ThirdType.SINA)) {
                nickName = (String)stringObjectHashMap.get("name");
                this.figureUrl = (String)stringObjectHashMap.get("avatar_large");
                genderStr = (String)stringObjectHashMap.get("gender");
                gender = genderStr.equals("m") ? Gender.Male : Gender.Female;
            }
            MLog.info((Object)TAG, (String)"userinfo: %s %s %s", (Object[])new Object[]{nickName, gender, this.figureUrl});
            HashMap<Integer, byte[]> infoMap = new HashMap<Integer, byte[]>();
            if (nickName != null) {
                infoMap.put(2, nickName.getBytes());
            }
            infoMap.put(5, this.getGender(gender));
            ICoreManagerBase.getUserCore().requestEditUser(infoMap);
            if (FixThirdNickNameEmptyUtils.INSTANCE.isUpdatePortrait()) {
                new Thread(this.connectNet).start();
            }
        }
        catch (Exception e2) {
            MLog.error((Object)TAG, (String)"onComplete exception!", (Throwable)e2, (Object[])new Object[0]);
        }
    }

    private byte[] getGender(Gender gender) {
        if (gender == Gender.Female) {
            return "0".getBytes();
        }
        if (gender == Gender.Male) {
            return "1".getBytes();
        }
        return "2".getBytes();
    }

    @Override
    public void onError(BasePlatform platform, int i2, Throwable throwable) {
        MLog.error((Object)TAG, (String)"ThirdPartyUserInfoListener onError %s %d %s", (Object[])new Object[]{platform, i2, throwable});
    }

    @Override
    public void onCancel(BasePlatform platform, int i2) {
        MLog.info((Object)TAG, (String)"ThirdPartyUserInfoListener onCancel %s %d", (Object[])new Object[]{platform, i2});
    }

    private byte[] getImage(String path) throws Exception {
        URL url = new URL(path);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(5000);
        conn.setRequestMethod("GET");
        InputStream inStream = conn.getInputStream();
        if (conn.getResponseCode() == 200) {
            return this.readStream(inStream);
        }
        return null;
    }

    private byte[] readStream(InputStream inStream) throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = inStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, len);
        }
        outStream.close();
        inStream.close();
        return outStream.toByteArray();
    }
}

