/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.util.device;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class DeviceInfo {
    public static final int DEVICEINFO_UNKNOWN = -1;
    private static final FileFilter CPU_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            String path = pathname.getName();
            if (path.startsWith("cpu")) {
                for (int i2 = 3; i2 < path.length(); ++i2) {
                    if (Character.isDigit(path.charAt(i2))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    };

    public static int getNumberOfCPUCores() {
        int cores;
        if (Build.VERSION.SDK_INT <= 10) {
            return 1;
        }
        try {
            cores = DeviceInfo.getCoresFromFileInfo("/sys/devices/system/cpu/possible");
            if (cores == -1) {
                cores = DeviceInfo.getCoresFromFileInfo("/sys/devices/system/cpu/present");
            }
            if (cores == -1) {
                cores = DeviceInfo.getCoresFromCPUFileList();
            }
        }
        catch (SecurityException e2) {
            cores = -1;
        }
        catch (NullPointerException e3) {
            cores = -1;
        }
        return cores;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getCoresFromFileInfo(String fileLocation) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(fileLocation);
            BufferedReader buf = new BufferedReader(new InputStreamReader(is));
            String fileContents = buf.readLine();
            buf.close();
            int n = DeviceInfo.getCoresFromFileString(fileContents);
            return n;
        }
        catch (IOException e2) {
            int n = -1;
            return n;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static int getCoresFromFileString(String str) {
        if (str == null || !str.matches("0-[\\d]+$")) {
            return -1;
        }
        int cores = Integer.valueOf(str.substring(2)) + 1;
        return cores;
    }

    private static int getCoresFromCPUFileList() {
        File[] files = new File("/sys/devices/system/cpu/").listFiles(CPU_FILTER);
        if (files != null) {
            return files.length;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCPUMaxFreqKHz() {
        int maxFreq;
        block13: {
            maxFreq = -1;
            try {
                for (int i2 = 0; i2 < DeviceInfo.getNumberOfCPUCores(); ++i2) {
                    String filename = "/sys/devices/system/cpu/cpu" + i2 + "/cpufreq/cpuinfo_max_freq";
                    File cpuInfoMaxFreqFile = new File(filename);
                    if (!cpuInfoMaxFreqFile.exists() || !cpuInfoMaxFreqFile.canRead()) continue;
                    byte[] buffer = new byte[128];
                    try (FileInputStream stream = new FileInputStream(cpuInfoMaxFreqFile);){
                        int endIndex;
                        stream.read(buffer);
                        for (endIndex = 0; Character.isDigit(buffer[endIndex]) && endIndex < buffer.length; ++endIndex) {
                        }
                        String str = new String(buffer, 0, endIndex);
                        Integer freqBound = Integer.parseInt(str);
                        if (freqBound <= maxFreq) continue;
                        maxFreq = freqBound;
                        continue;
                    }
                }
                if (maxFreq != -1) break block13;
                try (FileInputStream stream = new FileInputStream("/proc/cpuinfo");){
                    int freqBound = DeviceInfo.parseFileForValue("cpu MHz", stream);
                    if ((freqBound *= 1000) > maxFreq) {
                        maxFreq = freqBound;
                    }
                }
            }
            catch (IOException e2) {
                maxFreq = -1;
            }
        }
        return maxFreq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=16)
    public static long getTotalMemory(Context c) {
        if (Build.VERSION.SDK_INT >= 16) {
            ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
            ActivityManager am = (ActivityManager)c.getSystemService("activity");
            am.getMemoryInfo(memInfo);
            if (memInfo != null) {
                return memInfo.totalMem;
            }
            return -1L;
        }
        long totalMem = -1L;
        try (FileInputStream stream = new FileInputStream("/proc/meminfo");){
            totalMem = DeviceInfo.parseFileForValue("MemTotal", stream);
            totalMem *= 1024L;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return totalMem;
    }

    private static int parseFileForValue(String textToMatch, FileInputStream stream) {
        byte[] buffer = new byte[1024];
        try {
            int length = stream.read(buffer);
            for (int i2 = 0; i2 < length; ++i2) {
                int textIndex;
                if (buffer[i2] != 10 && i2 != 0) continue;
                if (buffer[i2] == 10) {
                    // empty if block
                }
                for (int j = ++i2; j < length && buffer[j] == textToMatch.charAt(textIndex = j - i2); ++j) {
                    if (textIndex != textToMatch.length() - 1) continue;
                    return DeviceInfo.extractValue(buffer, j);
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    private static int extractValue(byte[] buffer, int index) {
        while (index < buffer.length && buffer[index] != 10) {
            if (Character.isDigit(buffer[index])) {
                int start = index++;
                while (index < buffer.length && Character.isDigit(buffer[index])) {
                    ++index;
                }
                String str = new String(buffer, 0, start, index - start);
                return Integer.parseInt(str);
            }
            ++index;
        }
        return -1;
    }
}

