/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.flipper;

import android.content.Context;
import android.graphics.Rect;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ViewFlipper;
import com.yy.mobile.ui.widget.flipper.IFlipperViewHolder;
import com.yy.mobile.ui.widget.flipper.IViewFlipper;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yymobile.baseapi.R;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseViewFlipper<T, VH extends IFlipperViewHolder>
extends ViewFlipper
implements IViewFlipper<T, VH>,
Animation.AnimationListener {
    private static final long ANIM_DURATION = 500L;
    public Context mContext;
    public List<T> mData = new ArrayList<T>();
    public View itemView1;
    public View itemView2;
    private int flipInterval = 5000;
    private int mPos;
    private Handler mHandler = new SafeDispatchHandler();
    private boolean isFling = false;
    private Runnable autoScrollRunnable = new Runnable(){

        @Override
        public void run() {
            Rect rect = new Rect();
            BaseViewFlipper.this.getGlobalVisibleRect(rect);
            int[] locOnScr = new int[2];
            BaseViewFlipper.this.getLocationOnScreen(locOnScr);
            if (rect.top == 0 || locOnScr[0] < 0 || locOnScr[0] >= BaseViewFlipper.this.getResources().getDisplayMetrics().widthPixels) {
                BaseViewFlipper.this.endAutoScroll();
            } else {
                BaseViewFlipper.this.showNext();
                BaseViewFlipper.this.mHandler.postDelayed(BaseViewFlipper.this.autoScrollRunnable, (long)BaseViewFlipper.this.flipInterval);
            }
        }
    };

    public BaseViewFlipper(Context context) {
        this(context, null);
    }

    public BaseViewFlipper(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAnim(context);
        this.initView();
    }

    private void initAnim(Context context) {
        this.mContext = context;
        Animation animIn = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.pre_loop_view_flip_in);
        animIn.setDuration(500L);
        this.setInAnimation(animIn);
        animIn.setAnimationListener((Animation.AnimationListener)this);
        Animation animOut = AnimationUtils.loadAnimation((Context)this.mContext, (int)R.anim.pre_loop_view_flip_out);
        animOut.setDuration(500L);
        this.setOutAnimation(animOut);
        this.mPos = 0;
    }

    public void initView() {
        this.itemView1 = this.getItemView();
        this.itemView2 = this.getItemView();
        this.addView(this.itemView1);
        this.addView(this.itemView2);
    }

    @Override
    public void bindData(List<T> data) {
        if (!FP.empty(data)) {
            this.mData.clear();
            this.mData.addAll(data);
            this.initItem();
        }
        if (this.isFling) {
            this.endAutoScroll();
        }
        this.startAutoScroll();
    }

    public void onAnimationStart(Animation animation) {
    }

    public void onAnimationEnd(Animation animation) {
        if (!FP.empty(this.mData)) {
            ++this.mPos;
            this.mPos %= this.mData.size();
            int pos = (this.mPos + 1) % this.mData.size();
            if (this.isFirstChildShow()) {
                this.bindViewHolder(pos, (IFlipperViewHolder)this.itemView2.getTag());
            } else {
                this.bindViewHolder(pos, (IFlipperViewHolder)this.itemView1.getTag());
            }
        }
    }

    public void onAnimationRepeat(Animation animation) {
    }

    public void initItem() {
        this.itemView1 = this.getChildAt(0);
        this.itemView2 = this.getChildAt(1);
        this.bindViewHolder(0, (IFlipperViewHolder)this.itemView1.getTag());
        if (this.mData.size() > 1) {
            this.bindViewHolder(1, (IFlipperViewHolder)this.itemView2.getTag());
        }
    }

    public void startAutoScroll() {
        if (!this.isFling && this.mData != null && this.mData.size() > 1) {
            if (this.mHandler == null) {
                this.mHandler = new SafeDispatchHandler();
            }
            this.mHandler.postDelayed(this.autoScrollRunnable, (long)this.flipInterval);
            this.isFling = true;
        }
    }

    public void endAutoScroll() {
        if (this.isFling && this.mHandler != null) {
            this.mHandler.removeCallbacks(this.autoScrollRunnable);
            this.clearAnimation();
            this.isFling = false;
        }
    }

    public boolean isFirstChildShow() {
        return this.itemView1.getVisibility() == 0;
    }

    public int getCurPos() {
        return this.mPos;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.endAutoScroll();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.startAutoScroll();
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility == 0) {
            this.startAutoScroll();
        } else {
            this.endAutoScroll();
        }
    }

    public void notifyChangeDataSet() {
        if (!FP.empty(this.mData)) {
            int pos1 = this.getCurPos() % this.mData.size();
            int pos2 = (this.getCurPos() + 1) % this.mData.size();
            if (this.isFirstChildShow()) {
                this.bindViewHolder(pos1, (IFlipperViewHolder)this.itemView1.getTag());
                this.bindViewHolder(pos2, (IFlipperViewHolder)this.itemView2.getTag());
            } else {
                this.bindViewHolder(pos1, (IFlipperViewHolder)this.itemView2.getTag());
                this.bindViewHolder(pos2, (IFlipperViewHolder)this.itemView1.getTag());
            }
        }
    }

    public void setFlipInterval(int millisecond) {
        this.flipInterval = millisecond;
    }
}

