/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.res.Resources;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.unionyy.mobile.spdt.Spdt;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.plugin.main.events.IReportClient_onReport_EventArgs;
import com.yy.mobile.ui.widget.dialog.ReportPopupDialog;
import com.yy.mobile.ui.widget.dialog.ReportReasonPopupDialog$$EventBinder;
import com.yy.mobile.ui.widget.dialog.SpdtReportReasonBtnBg;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.ImeUtil;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.baseapi.R;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.report.IReportCore;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class ReportReasonPopupDialog
extends Dialog
implements EventCompat {
    private static final String TAG = "ReportReasonPopupDialog";
    private EditText mEtReason;
    protected Button mBtnReport;
    private TextView mTvCurrentCount;
    private boolean isDataReady = false;
    private int type;
    private int style;
    private long chid;
    private long suid;
    private String content;
    private String extParUrlEncoder;
    private String extProductorParm;
    private Map<String, String> extendInfo;
    private ReportPopupDialog.BeforeReportListener mBeforeListener;
    private ReportPopupDialog.OnReportItemClickListener mOnReportItemClickListener;
    private ReportPopupDialog.ParmRewriteStrategy mRewriteParamStrategy;
    private SpdtReportReasonBtnBg spdtReportReasonBtnBg = (SpdtReportReasonBtnBg)Spdt.of(SpdtReportReasonBtnBg.class);
    private EventBinder mReportReasonPopupDialogSniperEventBinder;

    public void onEventBind() {
        if (this.mReportReasonPopupDialogSniperEventBinder == null) {
            this.mReportReasonPopupDialogSniperEventBinder = new ReportReasonPopupDialog$$EventBinder();
        }
        this.mReportReasonPopupDialogSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mReportReasonPopupDialogSniperEventBinder != null) {
            this.mReportReasonPopupDialogSniperEventBinder.unBindEvent();
        }
    }

    public ReportReasonPopupDialog(Context context, int type, int style2, long chid, long suid, String content, String extParUrlEncoder, String extProductorParm, Map<String, String> extendInfo, ReportPopupDialog.OnReportItemClickListener mOnReportItemClickListener, ReportPopupDialog.BeforeReportListener beforeReportListener) {
        this(context, type, style2, chid, suid, content, extParUrlEncoder, extProductorParm, extendInfo, mOnReportItemClickListener, beforeReportListener, null);
    }

    public ReportReasonPopupDialog(Context context, int type, int style2, long chid, long suid, String content, String extParUrlEncoder, String extProductorParm, Map<String, String> extendInfo, ReportPopupDialog.OnReportItemClickListener mOnReportItemClickListener, ReportPopupDialog.BeforeReportListener beforeReportListener, ReportPopupDialog.ParmRewriteStrategy rewriteStrategy) {
        super(context, R.style.Dialog_Edit_Text);
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"type = %d ,chid = %d , suid = %d ,content = %s ,extParUrlEncoder = %s ,extProductorParm = %s ,extendInfo = %s", (Object[])new Object[]{type, chid, suid, content, extParUrlEncoder, extProductorParm, ""});
        }
        ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51034", "0002");
        this.type = type;
        this.style = style2;
        this.chid = chid;
        this.suid = suid;
        this.content = content;
        this.extParUrlEncoder = extParUrlEncoder;
        this.extProductorParm = extProductorParm;
        if (extendInfo == null) {
            extendInfo = new HashMap<String, String>();
        }
        this.extendInfo = extendInfo;
        this.mOnReportItemClickListener = mOnReportItemClickListener;
        this.mRewriteParamStrategy = rewriteStrategy;
        this.mBeforeListener = beforeReportListener;
        this.isDataReady = !TextUtils.isEmpty((CharSequence)extProductorParm);
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View rootView = inflater.inflate(this.getLayoutResId(), null);
        this.setContentView(rootView);
        Window window = this.getWindow();
        WindowManager.LayoutParams params = window.getAttributes();
        params.height = -2;
        params.width = -1;
        window.setGravity(80);
        window.setSoftInputMode(18);
        window.setAttributes(params);
        window.setWindowAnimations(R.style.DialogAnimation);
        this.mEtReason = (EditText)rootView.findViewById(R.id.et_report_reason);
        this.mBtnReport = (Button)rootView.findViewById(R.id.btn_report);
        this.mTvCurrentCount = (TextView)rootView.findViewById(R.id.tv_current_count);
        this.initCustomView(rootView);
        this.initListener();
    }

    protected int getLayoutResId() {
        return R.layout.dialog_report_reason;
    }

    protected void initCustomView(View rootView) {
    }

    private void initListener() {
        this.mBtnReport.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!TextUtils.isEmpty((CharSequence)ReportReasonPopupDialog.this.mEtReason.getText().toString())) {
                    ReportReasonPopupDialog.this.sendReport();
                } else {
                    Toast.makeText((Context)ReportReasonPopupDialog.this.getContext(), (CharSequence)"\u8bf7\u586b\u5199\u4e3e\u62a5\u539f\u56e0", (int)0).show();
                }
            }
        });
        this.mEtReason.addTextChangedListener(this.getInputTextChangeListener());
    }

    protected TextWatcher getInputTextChangeListener() {
        return new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                int reasonStrLength = ReportReasonPopupDialog.this.mEtReason.getText().toString().length();
                Resources r = BasicConfig.getInstance().getAppContext().getResources();
                ReportReasonPopupDialog.this.mTvCurrentCount.setText((CharSequence)String.valueOf(reasonStrLength));
                ReportReasonPopupDialog.this.mTvCurrentCount.setTextColor(reasonStrLength == 0 ? r.getColor(R.color.report_btn_not_enable) : r.getColor(R.color.bg_high_light));
                ReportReasonPopupDialog.this.mBtnReport.setTextColor(reasonStrLength > 0 ? r.getColor(ReportReasonPopupDialog.this.spdtReportReasonBtnBg.getBtnTextColorResource()) : r.getColor(R.color.white));
                ReportReasonPopupDialog.this.mBtnReport.setBackgroundResource(reasonStrLength > 0 ? ReportReasonPopupDialog.this.spdtReportReasonBtnBg.getBackgroundResource() : R.drawable.bg_selector_report_btn);
            }

            public void afterTextChanged(Editable s) {
            }
        };
    }

    @BusEvent(sync=true)
    public void onReport(IReportClient_onReport_EventArgs busEventArgs) {
        int code = busEventArgs.getCode();
        Map<String, String> data = busEventArgs.getData();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug(ReportPopupDialog.class, (String)("onReport: code=" + code), (Object[])new Object[0]);
        }
        if (code == 0) {
            Toast.makeText((Context)BasicConfig.getInstance().getAppContext().getApplicationContext(), (CharSequence)BasicConfig.getInstance().getAppContext().getApplicationContext().getText(R.string.str_report_success), (int)0).show();
        } else if (code == 1) {
            Toast.makeText((Context)BasicConfig.getInstance().getAppContext().getApplicationContext(), (CharSequence)BasicConfig.getInstance().getAppContext().getApplicationContext().getText(R.string.str_report_repeat), (int)0).show();
        }
        ICoreManagerBase.removeClient((Object)this);
    }

    private void sendReport() {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"report reason is--->%s", (Object[])new Object[]{this.mEtReason.getText().toString()});
        }
        if (!NetworkUtils.isNetworkStrictlyAvailable((Context)BasicConfig.getInstance().getAppContext())) {
            Toast.makeText((Context)BasicConfig.getInstance().getAppContext(), (CharSequence)BasicConfig.getInstance().getAppContext().getApplicationContext().getText(R.string.str_network_not_capable), (int)0).show();
            return;
        }
        if (this.mOnReportItemClickListener != null) {
            this.mOnReportItemClickListener.onReportItemClick(this.style, this.mEtReason.getText().toString());
        }
        this.dismiss();
        this.statisticClick();
        this.sendReportInner(this.mEtReason.getText().toString());
    }

    private void statisticClick() {
        Property property = new Property();
        property.putString("key1", "1");
        property.putString("key2", this.generateKey2(this.style));
        ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51034", "0003", (Serializable)property);
    }

    private String generateKey2(int style2) {
        if (style2 == 6) {
            return String.valueOf(style2 - 1);
        }
        if (style2 <= 4) {
            return String.valueOf(style2);
        }
        return "6";
    }

    protected void sendReportInner(String reason) {
        if (this.mBeforeListener == null && this.isDataReady || this.mBeforeListener != null && this.mBeforeListener.beforeReport(this.style)) {
            this.onSendReportBefore();
            ICoreManagerBase.addClient((Object)this);
            ICoreManagerBase.getCore(IReportCore.class).sendReport(this.type, this.chid, this.style, this.suid, this.content, this.extParUrlEncoder, this.setReportReasonJson(this.extProductorParm, reason), this.extendInfo);
        }
    }

    public String getReason() {
        return this.mEtReason.getText().toString();
    }

    private String setReportReasonJson(String jsonStr, String reason) {
        try {
            JSONObject object = new JSONObject(jsonStr);
            object.put("extraData", (Object)reason);
            return object.toString();
        }
        catch (JSONException e2) {
            MLog.error((Object)TAG, (Throwable)e2);
            return "";
        }
    }

    private void onSendReportBefore() {
        this.rewriteParam();
    }

    private void rewriteParam() {
        if (this.mRewriteParamStrategy != null) {
            this.chid = this.mRewriteParamStrategy.rewriteChidParm(this.style, this.chid);
            this.extProductorParm = this.mRewriteParamStrategy.rewriteExtProductorParm(this.style, this.extProductorParm);
            this.type = this.mRewriteParamStrategy.rewriteTypeParm(this.style, this.type);
        }
    }

    public void dismiss() {
        try {
            if (this.mEtReason != null) {
                ImeUtil.hideIME((Context)BasicConfig.getInstance().getAppContext().getApplicationContext(), (View)this.mEtReason);
            }
            super.dismiss();
        }
        catch (Exception e2) {
            MLog.error((Object)TAG, (Throwable)e2);
        }
    }
}

