/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.webview;

import android.content.Context;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.NestedScrollingChildHelper;
import android.util.AttributeSet;
import android.view.ActionMode;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.WebView;
import com.yy.mobile.util.log.MLog;

public class NestedWebView
extends WebView
implements NestedScrollingChild {
    public static final String TAG = "NestedWebView";
    private int mLastMotionY;
    private final int[] mScrollOffset = new int[2];
    private final int[] mScrollConsumed = new int[2];
    private int mNestedYOffset;
    private boolean mChange;
    private NestedScrollingChildHelper mChildHelper;
    private float downx;
    private float downy;
    private MotionEvent b;

    public NestedWebView(Context context) {
        super(context);
        this.init();
    }

    public NestedWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public NestedWebView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mChildHelper = new NestedScrollingChildHelper((View)this);
        this.setNestedScrollingEnabled(true);
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean result = false;
        MotionEvent trackedEvent = MotionEvent.obtain((MotionEvent)event);
        int action = MotionEventCompat.getActionMasked((MotionEvent)event);
        if (action == 0) {
            this.mNestedYOffset = 0;
        }
        int y = (int)event.getY();
        event.offsetLocation(0.0f, (float)this.mNestedYOffset);
        switch (action) {
            case 0: {
                this.mLastMotionY = y;
                this.startNestedScroll(2);
                result = super.onTouchEvent(event);
                this.mChange = false;
                this.downx = event.getX();
                this.downy = event.getY();
                this.b = MotionEvent.obtain((MotionEvent)event);
                break;
            }
            case 2: {
                int deltaY = this.mLastMotionY - y;
                if (this.dispatchNestedPreScroll(0, deltaY, this.mScrollConsumed, this.mScrollOffset)) {
                    deltaY -= this.mScrollConsumed[1];
                    trackedEvent.offsetLocation(0.0f, (float)this.mScrollOffset[1]);
                    this.mNestedYOffset += this.mScrollOffset[1];
                }
                int oldY = this.getScrollY();
                this.mLastMotionY = y - this.mScrollOffset[1];
                int newScrollY = Math.max(0, oldY + deltaY);
                if (this.dispatchNestedScroll(0, newScrollY - (deltaY -= newScrollY - oldY), 0, deltaY, this.mScrollOffset)) {
                    this.mLastMotionY -= this.mScrollOffset[1];
                    trackedEvent.offsetLocation(0.0f, (float)this.mScrollOffset[1]);
                    this.mNestedYOffset += this.mScrollOffset[1];
                }
                if (this.mScrollConsumed[1] == 0 && this.mScrollOffset[1] == 0) {
                    if (this.mChange) {
                        this.mChange = false;
                        trackedEvent.setAction(0);
                        super.onTouchEvent(trackedEvent);
                    } else {
                        result = super.onTouchEvent(trackedEvent);
                    }
                    trackedEvent.recycle();
                    break;
                }
                if (Math.abs(this.mLastMotionY - y) < 10 || this.mChange) break;
                this.mChange = true;
                super.onTouchEvent(MotionEvent.obtain((long)0L, (long)0L, (int)3, (float)0.0f, (float)0.0f, (int)0));
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                this.stopNestedScroll();
                result = super.onTouchEvent(event);
                break;
            }
        }
        return result;
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.mChildHelper.setNestedScrollingEnabled(enabled);
    }

    public boolean isNestedScrollingEnabled() {
        return this.mChildHelper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int axes) {
        return this.mChildHelper.startNestedScroll(axes);
    }

    public void stopNestedScroll() {
        this.mChildHelper.stopNestedScroll();
    }

    public boolean hasNestedScrollingParent() {
        return this.mChildHelper.hasNestedScrollingParent();
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow) {
        return this.mChildHelper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow) {
        return this.mChildHelper.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow);
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return this.mChildHelper.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        return this.mChildHelper.dispatchNestedPreFling(velocityX, velocityY);
    }

    public ActionMode startActionMode(final ActionMode.Callback callback) {
        ActionMode.Callback catchExceptionCallback = new ActionMode.Callback(){

            public boolean onCreateActionMode(ActionMode actionMode, Menu menu) {
                try {
                    return callback.onCreateActionMode(actionMode, menu);
                }
                catch (Exception e2) {
                    MLog.error((Object)NestedWebView.TAG, (String)"onCreateActionMode exception:%s", (Object[])new Object[]{e2.toString()});
                    return false;
                }
            }

            public boolean onPrepareActionMode(ActionMode actionMode, Menu menu) {
                try {
                    return callback.onPrepareActionMode(actionMode, menu);
                }
                catch (Exception e2) {
                    MLog.error((Object)NestedWebView.TAG, (String)"onPrepareActionMode exception:%s", (Object[])new Object[]{e2.toString()});
                    return false;
                }
            }

            public boolean onActionItemClicked(ActionMode actionMode, MenuItem menuItem) {
                try {
                    return callback.onActionItemClicked(actionMode, menuItem);
                }
                catch (Exception e2) {
                    MLog.error((Object)NestedWebView.TAG, (String)"onActionItemClicked exception:%s", (Object[])new Object[]{e2.toString()});
                    return false;
                }
            }

            public void onDestroyActionMode(ActionMode actionMode) {
                try {
                    callback.onDestroyActionMode(actionMode);
                }
                catch (Exception e2) {
                    MLog.error((Object)NestedWebView.TAG, (String)"onDestroyActionMode exception:%s", (Object[])new Object[]{e2.toString()});
                }
            }
        };
        return super.startActionMode(catchExceptionCallback);
    }

    public ActionMode startActionMode(final ActionMode.Callback callback, int type) {
        ActionMode.Callback catchExceptionCallback = new ActionMode.Callback(){

            public boolean onCreateActionMode(ActionMode actionMode, Menu menu) {
                try {
                    return callback.onCreateActionMode(actionMode, menu);
                }
                catch (Exception e2) {
                    MLog.error((Object)NestedWebView.TAG, (String)"onCreateActionMode exception:%s", (Object[])new Object[]{e2.toString()});
                    return false;
                }
            }

            public boolean onPrepareActionMode(ActionMode actionMode, Menu menu) {
                try {
                    return callback.onPrepareActionMode(actionMode, menu);
                }
                catch (Exception e2) {
                    MLog.error((Object)NestedWebView.TAG, (String)"onPrepareActionMode exception:%s", (Object[])new Object[]{e2.toString()});
                    return false;
                }
            }

            public boolean onActionItemClicked(ActionMode actionMode, MenuItem menuItem) {
                try {
                    return callback.onActionItemClicked(actionMode, menuItem);
                }
                catch (Exception e2) {
                    MLog.error((Object)NestedWebView.TAG, (String)"onActionItemClicked exception:%s", (Object[])new Object[]{e2.toString()});
                    return false;
                }
            }

            public void onDestroyActionMode(ActionMode actionMode) {
                try {
                    callback.onDestroyActionMode(actionMode);
                }
                catch (Exception e2) {
                    MLog.error((Object)NestedWebView.TAG, (String)"onDestroyActionMode exception:%s", (Object[])new Object[]{e2.toString()});
                }
            }
        };
        return super.startActionMode(catchExceptionCallback, type);
    }
}

