/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.ui.utils.IView;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.ActivityUtilKt;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.log.MLog;
import com.yymobile.baseapi.R;
import com.yymobile.core.ICoreManagerBase;
import java.lang.ref.WeakReference;

public abstract class AbstractViewController
implements IView,
EventCompat {
    private static final String TAG = "AbstractViewController";
    private WeakReference<Activity> mContext;
    protected View mRootView;
    Handler mHandler = new SafeDispatchHandler(Looper.getMainLooper());
    protected boolean isInitHidden = false;
    protected boolean isDetached = false;

    public Activity getActivity() {
        if (this.mContext != null && this.mContext.get() != null) {
            return (Activity)this.mContext.get();
        }
        return null;
    }

    public void setActivityNull() {
        this.mContext = null;
    }

    public void attach(Activity activity) {
        this.mContext = new WeakReference<Activity>(activity);
        ICoreManagerBase.addClient(this);
        this.onAttach(activity);
        this.isDetached = false;
    }

    protected void onAttach(Activity activity) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"onAttach", (Object[])new Object[0]);
        }
    }

    public boolean isInitHidden() {
        return this.isInitHidden;
    }

    public boolean isDetached() {
        return this.isDetached;
    }

    public void setInitHidden(boolean initHidden) {
        this.isInitHidden = initHidden;
    }

    protected void onCreatePrepare(Bundle savedInstanceState) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"onCreatePrepare", (Object[])new Object[0]);
        }
    }

    public boolean isLandScape() {
        if (this.getActivity() != null) {
            return ActivityUtilKt.isLandScape((Activity)this.getActivity());
        }
        return false;
    }

    public void create(Bundle savedInstanceState, ViewGroup container) {
        this.onCreatePrepare(savedInstanceState);
        if (this.mRootView == null) {
            this.mRootView = this.onCreateView(this.getActivity().getLayoutInflater(), container, savedInstanceState);
        }
        if (this.mRootView != null && this.isInitHidden()) {
            this.mRootView.setVisibility(4);
        }
        if (container != null && this.mRootView != null && this.mRootView.getParent() == null) {
            container.addView(this.mRootView);
        }
        this.onViewCreated(this.mRootView, savedInstanceState);
        if (this.mRootView != null) {
            if (this.isInitHidden()) {
                this.mRootView.setVisibility(4);
            } else {
                Animation animation = this.onCreateAnimation(true);
                if (animation != null) {
                    this.mRootView.startAnimation(animation);
                }
            }
        }
    }

    public void saveInstanceState(Bundle outState) {
        this.onSaveInstanceState(outState);
    }

    protected void onSaveInstanceState(Bundle outState) {
    }

    protected void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"onViewCreated", (Object[])new Object[0]);
        }
    }

    @Override
    public View getView() {
        return this.mRootView;
    }

    @Override
    public void show() {
        if (this.mRootView != null) {
            Animation animation = this.onCreateAnimation(true);
            if (animation != null) {
                animation.setAnimationListener(new Animation.AnimationListener(){

                    public void onAnimationStart(Animation animation) {
                        AbstractViewController.this.onEnterAnimationStart(animation);
                    }

                    public void onAnimationEnd(Animation animation) {
                        AbstractViewController.this.onEnterAnimationEnd(animation);
                    }

                    public void onAnimationRepeat(Animation animation) {
                        AbstractViewController.this.onEnterAnimationRepeat(animation);
                    }
                });
                this.mRootView.setVisibility(0);
                this.mRootView.startAnimation(animation);
            } else {
                this.mRootView.setVisibility(0);
            }
        }
        this.onHiddenChanged(false);
    }

    protected void onEnterAnimationRepeat(Animation animation) {
    }

    protected void onEnterAnimationEnd(Animation animation) {
    }

    protected void onEnterAnimationStart(Animation animation) {
    }

    @Override
    public void hide() {
        if (this.mRootView != null) {
            Animation animation = this.onCreateAnimation(false);
            if (animation != null) {
                animation.setAnimationListener(new Animation.AnimationListener(){

                    public void onAnimationStart(Animation animation) {
                        AbstractViewController.this.onExitAnimationStart(animation);
                    }

                    public void onAnimationEnd(Animation animation) {
                        AbstractViewController.this.mRootView.setVisibility(8);
                        AbstractViewController.this.onExitAnimationEnd(animation);
                    }

                    public void onAnimationRepeat(Animation animation) {
                        AbstractViewController.this.onExitAnimationRepeat(animation);
                    }
                });
                this.mRootView.startAnimation(animation);
            } else {
                this.mRootView.setVisibility(8);
            }
        }
        this.onHiddenChanged(true);
    }

    public void dismiss() {
        if (this.mRootView != null && this.mRootView.getParent() != null) {
            ViewGroup vg = (ViewGroup)this.mRootView.getParent();
            vg.removeView(this.mRootView);
            this.destroy();
        }
    }

    protected void onExitAnimationRepeat(Animation animation) {
    }

    protected void onExitAnimationEnd(Animation animation) {
    }

    protected void onExitAnimationStart(Animation animation) {
    }

    public void resume() {
        this.onResume();
    }

    protected void onResume() {
    }

    public void pause() {
        this.onPause();
    }

    protected void onPause() {
    }

    public void destroy() {
        this.mHandler.removeCallbacksAndMessages(null);
        ICoreManagerBase.removeClient(this);
        this.onDestroy();
        this.isDetached = true;
    }

    protected void onDestroy() {
    }

    protected abstract View onCreateView(LayoutInflater var1, ViewGroup var2, Bundle var3);

    public void orientationChanged(boolean isLandscape) {
        this.onOrientationChanged(isLandscape);
    }

    protected void onOrientationChanged(boolean isLandscape) {
    }

    protected Animation onCreateAnimation(boolean enter) {
        return null;
    }

    protected void onHiddenChanged(boolean hidden) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("onHiddenChanged hidden " + hidden), (Object[])new Object[0]);
        }
    }

    public boolean isHidden() {
        if (this.mRootView != null && this.mRootView.getParent() != null) {
            return this.mRootView.getVisibility() != 0;
        }
        return false;
    }

    public boolean isLogined() {
        return LoginUtil.isLogined();
    }

    public boolean checkNetToast() {
        boolean falg = this.isNetworkAvailable();
        if (!falg) {
            Toast.makeText((Context)this.getActivity(), (int)R.string.str_network_not_capable, (int)0).show();
        }
        return falg;
    }

    public boolean isNetworkAvailable() {
        return NetworkUtils.isNetworkStrictlyAvailable((Context)this.getActivity());
    }

    @TargetApi(value=17)
    protected boolean checkActivityValid() {
        if (this.getActivity() == null) {
            return false;
        }
        if (this.getActivity().isFinishing()) {
            return false;
        }
        return Build.VERSION.SDK_INT < 17 || !this.getActivity().isDestroyed();
    }

    protected String getString(int id2) {
        if (this.getActivity() != null) {
            return this.getActivity().getResources().getString(id2);
        }
        return "";
    }

    public Handler getHandler() {
        return this.mHandler;
    }

    protected View findViewById(int id2) {
        if (this.mRootView != null) {
            return this.mRootView.findViewById(id2);
        }
        return null;
    }

    public FragmentManager getSupportFragmentManager() {
        FragmentActivity fa;
        if (this.getActivity() != null && this.mContext.get() instanceof FragmentActivity && (fa = (FragmentActivity)this.mContext.get()) != null) {
            return fa.getSupportFragmentManager();
        }
        return null;
    }

    public void noticeToast(String message) {
        if (this.checkActivityValid()) {
            Toast.makeText((Context)BasicConfig.getInstance().getAppContext(), (CharSequence)message, (int)0).show();
        }
    }

    public void onEventBind() {
    }

    public void onEventUnBind() {
    }
}

