/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core.live.LiveCore;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.alibaba.android.arouter.facade.Postcard;
import com.alibaba.android.arouter.launcher.ARouter;
import com.yy.mobile.channeltokenutil.JoinChannelTokenUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class JoinChannelIntent {
    private static final String TAG = "JoinChannelIntent";
    private final long sid;
    private final long ssid;
    private final int queryType;
    @Nullable
    private final String channelFrom;
    @Nullable
    private final String templateId;
    @Nullable
    private final Bundle extras;
    @Nullable
    private final HashMap<String, String> extendInfo;

    private JoinChannelIntent(long sid, long ssid, int queryType, @Nullable String templateId, @Nullable String src, @Nullable HashMap<String, String> extendInfo, @Nullable Bundle extras) {
        this.sid = sid;
        this.ssid = ssid;
        this.queryType = queryType;
        this.templateId = templateId;
        this.channelFrom = src;
        this.extendInfo = extendInfo;
        this.extras = extras;
    }

    private long sid() {
        return this.sid;
    }

    private long ssid() {
        return this.ssid;
    }

    @Nullable
    private String templateId() {
        return this.templateId;
    }

    private String src() {
        return this.channelFrom;
    }

    @Nullable
    private Bundle extras() {
        if (this.extras == null) {
            return null;
        }
        return new Bundle(this.extras);
    }

    @Nullable
    private HashMap<String, String> extendInfo() {
        if (this.extendInfo == null) {
            return null;
        }
        return new LinkedHashMap<String, String>(this.extendInfo);
    }

    @NonNull
    public Bundle toBundle() {
        Bundle bundle;
        Bundle bundle2 = bundle = this.extras() != null ? new Bundle(this.extras()) : new Bundle();
        if (TextUtils.isEmpty((CharSequence)this.templateId())) {
            bundle.putInt("channel_mobile_query", this.queryType);
        } else {
            bundle.putString("channel_templateId", this.templateId());
        }
        bundle.putString("channel_from", this.src());
        bundle.putLong("channel_sid", this.sid());
        bundle.putLong("channel_ssid", this.ssid());
        bundle.putSerializable("channel_mobile_extend_info", this.extendInfo());
        return bundle;
    }

    public Postcard toPostcard() {
        return ARouter.getInstance().build("/Live/Template").withFlags(0x10000000).with(this.toBundle());
    }

    public void joinChannel(@Nullable Context context) {
        this.joinChannel(context, -1);
    }

    public void joinChannel(@Nullable Context context, int requestCode) {
        if (context != null) {
            ARouter.getInstance().navigation(context, this.toPostcard(), requestCode, null);
        }
    }

    public static JoinChannelBuilder instance(long sid, long ssid) {
        return new JoinChannelBuilder(sid, ssid);
    }

    public String toString() {
        String toStr = "JoinChannelIntent{sid=" + this.sid + ", ssid=" + this.ssid + ", queryType=" + this.queryType + ", templateId='" + this.templateId + '\'' + ", channelFrom='" + this.channelFrom + '\'';
        if (this.extras != null) {
            toStr = toStr + ", anchorUid=" + this.extras.getLong("channel_anchor_uid") + ", liveType=" + this.extras.getInt("channel_type");
        }
        return toStr + ", extras=" + this.extras + ", extendInfo=" + this.extendInfo + '}';
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.PARAMETER, ElementType.METHOD, ElementType.FIELD})
    public static @interface JoinChannelQueryType {
    }

    @Target(value={ElementType.PARAMETER, ElementType.METHOD, ElementType.FIELD})
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface JoinChannelLiveType {
    }

    @Target(value={ElementType.PARAMETER, ElementType.METHOD, ElementType.FIELD})
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface JoinChannelSrc {
    }

    public static class JoinChannelBuilder {
        private final long sid;
        private final long ssid;
        private long anchorUid = -1L;
        @Nullable
        private String templateId;
        private int queryType = 1;
        @Nullable
        private String src = "0";
        @Nullable
        private HashMap<String, String> extendInfo = null;
        @Nullable
        private Bundle extras = null;

        @NonNull
        private HashMap<String, String> extendInfo() {
            if (this.extendInfo == null) {
                this.extendInfo = new LinkedHashMap<String, String>();
            }
            return this.extendInfo;
        }

        @NonNull
        private Bundle extras() {
            if (this.extras == null) {
                this.extras = new Bundle();
            }
            return this.extras;
        }

        private JoinChannelBuilder(long sid, long ssid) {
            this.sid = sid;
            this.ssid = ssid;
        }

        public JoinChannelBuilder templateId(long templateId) {
            this.templateId = String.valueOf(templateId);
            return this;
        }

        public JoinChannelBuilder templateId(@Nullable String templateId) {
            this.templateId = templateId;
            return this;
        }

        public JoinChannelBuilder recommend(int recommend) {
            this.extendInfo().put("recommed", String.valueOf(recommend));
            return this;
        }

        public JoinChannelBuilder token(@Nullable String token) {
            token = JoinChannelTokenUtil.createOrSetJoinChannelToken((String)token);
            this.extendInfo().put("token", token);
            return this;
        }

        public JoinChannelBuilder biz(String biz) {
            if (!StringUtils.isEmpty((String)biz).booleanValue()) {
                this.extendInfo().put("channel_biz", biz);
            }
            return this;
        }

        public JoinChannelBuilder category(String category) {
            if (!StringUtils.isEmpty((String)category).booleanValue()) {
                this.extendInfo().put("channel_category", category);
            }
            return this;
        }

        public JoinChannelBuilder desc(@Nullable String desc) {
            this.extendInfo().put("home_click_desc", desc);
            return this;
        }

        public JoinChannelBuilder src(@NonNull String src) {
            this.src = src;
            this.extendInfo().put("channel_from", src);
            return this;
        }

        public JoinChannelBuilder thumb(@Nullable String screenShotUrl) {
            this.extras().putString("channel_screenshot_url", screenShotUrl);
            return this;
        }

        public JoinChannelBuilder type(int type) {
            this.extras().putInt("channel_type", type);
            return this;
        }

        public JoinChannelBuilder queryType(int queryType) {
            this.queryType = queryType;
            return this;
        }

        public JoinChannelBuilder anchorUid(long uid) {
            this.anchorUid = uid;
            this.extras().putLong("channel_anchor_uid", uid);
            return this;
        }

        public JoinChannelBuilder extendInfo(@Nullable Map<String, String> extendInfo) {
            if (extendInfo != null) {
                for (Map.Entry<String, String> entry : extendInfo.entrySet()) {
                    this.extendInfo().put(entry.getKey(), entry.getValue());
                }
            }
            return this;
        }

        public JoinChannelBuilder extras(@Nullable Bundle extras) {
            if (extras != null) {
                this.extras().putAll(extras);
            }
            return this;
        }

        public JoinChannelIntent build() {
            this.checkParameters();
            if (!this.extendInfo().containsKey("token") || TextUtils.isEmpty((CharSequence)this.extendInfo().get("token"))) {
                this.extendInfo().put("token", JoinChannelTokenUtil.createOrSetJoinChannelToken(null));
            }
            JoinChannelIntent intent = new JoinChannelIntent(this.sid, this.ssid, this.queryType, this.templateId, this.src, this.extendInfo, this.extras);
            MLog.info((Object)JoinChannelIntent.TAG, (String)("joinChannel: " + intent), (Object[])new Object[0]);
            return intent;
        }

        private void checkParameters() {
            if (this.sid <= 0L && this.queryType == 1) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(" no illegalArgumentException use sid = " + this.sid + " queryType = " + this.queryType + ", queryType must LiveTemplateConstant.QUERY_TYPE_SEARCH OR sid must > 0 ");
                if (BasicConfig.getInstance().isDebuggable()) {
                    throw illegalArgumentException;
                }
                MLog.error((Object)JoinChannelIntent.TAG, (Throwable)illegalArgumentException);
            }
        }
    }
}

