/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core.db;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.support.ConnectionSource;
import com.yy.mobile.util.log.MLog;
import java.sql.SQLException;

public abstract class DbHelper
extends OrmLiteSqliteOpenHelper {
    protected final String logTag;
    private String dbName;
    private String dbOpenAccountAction;
    private String dbOpenAccountDbName;

    public DbHelper(Context context, String dbName, int dbVersion) {
        super(context, dbName, null, dbVersion);
        this.dbName = dbName;
        this.logTag = "DbHelper(" + dbName + ")";
        MLog.info((Object)this.logTag, (String)"DbHelper constructor", (Object[])new Object[0]);
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDBOpenAccount(String action, String dbName) {
        this.dbOpenAccountAction = action;
        this.dbOpenAccountDbName = dbName;
    }

    public String getDbOpenAccountAction() {
        return this.dbOpenAccountAction;
    }

    public String getDbOpenAccountDbName() {
        return this.dbOpenAccountDbName;
    }

    public void onCreate(SQLiteDatabase database, ConnectionSource connectionSource) {
        MLog.info((Object)this.logTag, (String)("DbHelper onCreate, name = " + this.dbName), (Object[])new Object[0]);
        try {
            this.onDbCreate(database, connectionSource);
        }
        catch (SQLException e2) {
            MLog.error((Object)this.logTag, (String)"DbHelper onCreate error", (Throwable)e2, (Object[])new Object[0]);
        }
    }

    protected abstract void onDbCreate(SQLiteDatabase var1, ConnectionSource var2) throws SQLException;

    public void onUpgrade(SQLiteDatabase database, ConnectionSource connectionSource, int oldVersion, int newVersion) {
        MLog.info((Object)this.logTag, (String)("DbHelper onUpdate old " + oldVersion + " new " + newVersion), (Object[])new Object[0]);
        try {
            this.onDbUpgrade(database, connectionSource, oldVersion, newVersion);
        }
        catch (SQLException e2) {
            MLog.error((Object)this.logTag, (String)"DbHelper onUpgrade error", (Throwable)e2, (Object[])new Object[0]);
        }
    }

    protected abstract void onDbUpgrade(SQLiteDatabase var1, ConnectionSource var2, int var3, int var4) throws SQLException;
}

