/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ListView;
import com.yy.mobile.ui.widget.StatusLayout;
import com.yy.mobile.util.log.MLog;

public class EndlessListScrollListener
implements AbsListView.OnScrollListener {
    private static final String TAG = "EndlessListScrollListener";
    private int visibleThreshold = 1;
    private boolean mLoading = false;
    private View mFooter;
    private ListView mListView;
    private EndlessListener mListener;
    private AbsListView.OnScrollListener mOnScrollListener;
    private ViewGroup mLoadingViewContainer;
    private boolean mLastItemVisible;
    private StatusLayout mStatus;

    public EndlessListScrollListener(StatusLayout layout2) {
        this.mStatus = layout2;
    }

    public EndlessListScrollListener(ViewGroup loadingViewContainer, int resourceId) {
        this.mLoadingViewContainer = loadingViewContainer;
        this.setLoadingView(resourceId);
    }

    public void setListener(EndlessListener listener) {
        this.mListener = listener;
    }

    public void setParentOnScrollListener(AbsListView.OnScrollListener listener) {
        this.mOnScrollListener = listener;
    }

    protected void setLoadingView(int resourceId) {
        if (this.mLoadingViewContainer != null) {
            LayoutInflater inflater = (LayoutInflater)this.mLoadingViewContainer.getContext().getSystemService("layout_inflater");
            this.mFooter = inflater.inflate(resourceId, null);
        }
    }

    public void setVisibleThreshold(int visibleThreshold) {
        this.visibleThreshold = visibleThreshold;
    }

    public void onLoadComplete() {
        MLog.verbose((Object)TAG, (String)"onLoadComplete", (Object[])new Object[0]);
        this.mLoading = false;
        if (this.mLoadingViewContainer != null) {
            this.mLoadingViewContainer.removeView(this.mFooter);
        }
        if (this.mListView != null) {
            this.mListView.removeFooterView(this.mFooter);
        }
        if (this.mStatus != null) {
            this.mStatus.hideLoadMore();
        }
    }

    protected void onLoading() {
        MLog.verbose((Object)TAG, (String)"onLoading", (Object[])new Object[0]);
        this.mLoading = true;
        if (this.mLoadingViewContainer != null) {
            this.mLoadingViewContainer.addView(this.mFooter);
        }
        if (this.mListView != null) {
            this.mListView.addFooterView(this.mFooter);
        }
        if (this.mStatus != null) {
            this.mStatus.showLoadMore();
        }
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        boolean bl = this.mLastItemVisible = totalItemCount > 0 && firstVisibleItem + visibleItemCount >= totalItemCount - this.visibleThreshold;
        if (!this.mLastItemVisible && this.mStatus != null) {
            this.mStatus.hideLoadMore();
        }
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
        }
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        if (scrollState == 0 && null != this.mListener && this.mLastItemVisible && !this.mLoading && this.mListener.shouldLoadData()) {
            this.onLoading();
            this.mListener.onLoadData();
        }
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScrollStateChanged(view, scrollState);
        }
    }

    public void setLastItemVisible(boolean visible) {
        this.mLastItemVisible = visible;
    }

    public static interface EndlessListener {
        public void onLoadData();

        public boolean shouldLoadData();
    }
}

