/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils;

import android.support.v4.app.FragmentManager;
import android.text.format.DateUtils;
import android.util.Log;
import com.google.gson.Gson;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.util.log.MLog;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class MiscUtils {
    private static final String TAG = "MiscUtils";
    private static ThreadLocal<SimpleDateFormat> simpleDateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        public SimpleDateFormat get() {
            return new SimpleDateFormat("yyyy.MM.dd", Locale.getDefault());
        }
    };

    public static long getSpecificDayStartTime(long time) {
        if (String.valueOf(time).length() != String.valueOf(System.currentTimeMillis()).length()) {
            time *= 1000L;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTimeInMillis() / 1000L;
    }

    public static boolean isToday(long time) {
        return time != 0L && DateUtils.isToday((long)time);
    }

    public static String getSpecialDate(long time) {
        long startTime;
        long today = MiscUtils.getSpecificDayStartTime(System.currentTimeMillis());
        long delta = today / 86400L - (startTime = MiscUtils.getSpecificDayStartTime(time)) / 86400L;
        if (delta == 0L) {
            return "\u4eca\u5929";
        }
        if (delta == 1L) {
            return "\u6628\u5929";
        }
        if (delta == 2L) {
            return "\u524d\u5929";
        }
        if (String.valueOf(System.currentTimeMillis()).length() != String.valueOf(time).length()) {
            time *= 1000L;
        }
        return simpleDateFormat.get().format(new Date(time));
    }

    public static long getTheDaysBeforeToday(int nDaysBefore) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -nDaysBefore);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTimeInMillis();
    }

    public static <T> T safeConvert(Gson gson, String content, Class<T> clazz, T defaultValue) {
        try {
            return (T)gson.fromJson(content, clazz);
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (String)("\u5831\u932f\uff1a" + throwable), (Object[])new Object[0]);
            return defaultValue;
        }
    }

    public static void openFragmentManagerLog(FragmentManager fragmentManager) {
        Log.e((String)TAG, (String)"\u9875\u9762\u53d8\u767dbug\u6d4b\u8bd5\uff0c\u540e\u7eed\u9700\u8981\u5220\u9664");
        try {
            Field field = fragmentManager.getClass().getDeclaredField("DEBUG");
            field.setAccessible(true);
            field.set(null, true);
        }
        catch (NoSuchFieldException e2) {
            e2.printStackTrace();
            Log.e((String)TAG, (String)("\u9519\u4e86?\uff1a" + e2));
        }
        catch (IllegalAccessException e3) {
            Log.e((String)TAG, (String)("\u9519\u4e86?\uff1a" + e3));
        }
    }

    public static boolean isFullScreen() {
        return BasicConfig.getInstance().getAppContext().getResources().getConfiguration().orientation == 2;
    }
}

