/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils;

import android.app.Activity;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import com.yy.mobile.baseapi.model.store.YYStore;
import com.yy.mobile.event.ui.YYCommandAction;
import com.yy.mobile.model.ReqAction;
import com.yy.mobile.util.log.MLog;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;

public class AppForegroundStateManager {
    public static final long APP_CLOSED_VALIDATION_TIME_IN_MS = 2000L;
    private static final String TAG = "AppForegroundStateManager";
    private static final int MESSAGE_NOTIFY_LISTENERS = 1;
    private Reference<Activity> mForegroundActivity;
    private Set<OnAppForegroundStateChangeListener> mListeners = new HashSet<OnAppForegroundStateChangeListener>();
    private AppForegroundState mAppForegroundState = AppForegroundState.NOT_IN_FOREGROUND;
    private NotifyListenersHandler mHandler = new NotifyListenersHandler(Looper.getMainLooper());

    private AppForegroundStateManager() {
    }

    public static AppForegroundStateManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void onActivityVisible(Activity activity) {
        if (this.mForegroundActivity != null) {
            this.mForegroundActivity.clear();
        }
        this.mForegroundActivity = new WeakReference<Activity>(activity);
        this.determineAppForegroundState();
    }

    private void determineAppForegroundState() {
        AppForegroundState oldState = this.mAppForegroundState;
        boolean isInForeground = this.mForegroundActivity != null && this.mForegroundActivity.get() != null;
        AppForegroundState appForegroundState = this.mAppForegroundState = isInForeground ? AppForegroundState.IN_FOREGROUND : AppForegroundState.NOT_IN_FOREGROUND;
        if (this.mAppForegroundState != oldState) {
            this.validateThenNotifyListeners();
            if (isInForeground) {
                YYStore.INSTANCE.dispatch((ReqAction)new YYCommandAction());
            }
        }
    }

    private void validateThenNotifyListeners() {
        if (this.mHandler.hasMessages(1)) {
            MLog.verbose((Object)TAG, (String)"Validation Failed: Throwing out app foreground state change notification", (Object[])new Object[0]);
            this.mHandler.removeMessages(1);
        } else if (this.mAppForegroundState == AppForegroundState.IN_FOREGROUND) {
            this.mHandler.sendEmptyMessage(1);
        } else {
            this.mHandler.sendEmptyMessageDelayed(1, 2000L);
        }
    }

    public void onActivityNotVisible(Activity activity) {
        Activity ref;
        if (this.mForegroundActivity != null && activity == (ref = this.mForegroundActivity.get())) {
            this.mForegroundActivity.clear();
            this.mForegroundActivity = null;
        }
        this.determineAppForegroundState();
    }

    public Boolean isAppInForeground() {
        return this.mAppForegroundState == AppForegroundState.IN_FOREGROUND;
    }

    public void addListener(@NonNull OnAppForegroundStateChangeListener listener) {
        this.mListeners.add(listener);
    }

    public void removeListener(OnAppForegroundStateChangeListener listener) {
        this.mListeners.remove(listener);
    }

    private void notifyListeners(AppForegroundState newState) {
        MLog.info((Object)TAG, (String)("Notifying subscribers that app just entered state: " + (Object)((Object)newState)), (Object[])new Object[0]);
        for (OnAppForegroundStateChangeListener listener : this.mListeners) {
            listener.onAppForegroundStateChange(newState);
        }
    }

    private class NotifyListenersHandler
    extends Handler {
        private NotifyListenersHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message inputMessage) {
            switch (inputMessage.what) {
                case 1: {
                    MLog.verbose((Object)AppForegroundStateManager.TAG, (String)("App just changed foreground state to: " + (Object)((Object)AppForegroundStateManager.this.mAppForegroundState)), (Object[])new Object[0]);
                    AppForegroundStateManager.this.notifyListeners(AppForegroundStateManager.this.mAppForegroundState);
                    break;
                }
                default: {
                    super.handleMessage(inputMessage);
                }
            }
        }
    }

    private static class SingletonHolder {
        public static final AppForegroundStateManager INSTANCE = new AppForegroundStateManager();

        private SingletonHolder() {
        }
    }

    public static interface OnAppForegroundStateChangeListener {
        public void onAppForegroundStateChange(AppForegroundState var1);
    }

    public static enum AppForegroundState {
        IN_FOREGROUND,
        NOT_IN_FOREGROUND;

    }
}

