/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.refreshlayout;

import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import com.yymobile.baseapi.R;

public abstract class AnimationDrawableRefreshHeader
extends RelativeLayout
implements RefreshHeader {
    protected ImageView yyView;

    public AnimationDrawableRefreshHeader(Context context) {
        super(context);
        this.initView(context, null, 0);
    }

    public AnimationDrawableRefreshHeader(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs, 0);
    }

    public AnimationDrawableRefreshHeader(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs, defStyleAttr);
    }

    protected void initView(Context context, AttributeSet attrs, int defStyleAttr) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.layout_animation_drawable_header, (ViewGroup)this);
        this.yyView = (ImageView)view.findViewById(R.id.yy_header_view);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.yyView.setImageDrawable((Drawable)this.getPullingAnimationDrawable());
    }

    @NonNull
    public View getView() {
        return this;
    }

    public SpinnerStyle getSpinnerStyle() {
        return SpinnerStyle.Translate;
    }

    public void setPrimaryColors(int ... colors) {
    }

    public void onInitialized(RefreshKernel kernel, int height, int extendHeight) {
    }

    public void onHorizontalDrag(float percentX, int offsetX, int offsetMax) {
    }

    public void onStartAnimator(RefreshLayout layout2, int height, int extendHeight) {
        Drawable d = this.yyView.getDrawable();
        if (d instanceof AnimationDrawable) {
            ((AnimationDrawable)d).start();
        }
    }

    public int onFinish(RefreshLayout layout2, boolean success) {
        Drawable d = this.yyView.getDrawable();
        if (d instanceof AnimationDrawable) {
            ((AnimationDrawable)d).stop();
        }
        return 500;
    }

    public boolean isSupportHorizontalDrag() {
        return false;
    }

    public void onStateChanged(RefreshLayout refreshLayout, RefreshState oldState, RefreshState newState) {
        switch (newState) {
            case None: 
            case PullDownToRefresh: {
                this.yyView.setImageDrawable((Drawable)this.getPullingAnimationDrawable());
                ((AnimationDrawable)this.yyView.getDrawable()).start();
                break;
            }
            case Refreshing: {
                Drawable d = this.yyView.getDrawable();
                if (d instanceof AnimationDrawable) {
                    ((AnimationDrawable)d).stop();
                }
                this.yyView.setImageDrawable((Drawable)this.getLoadingAnimationDrawable());
                break;
            }
            case ReleaseToRefresh: {
                this.yyView.setImageDrawable((Drawable)this.getPullingAnimationDrawable());
                ((AnimationDrawable)this.yyView.getDrawable()).start();
                break;
            }
        }
    }

    public void onPullingDown(float percent, int offset, int headerHeight, int extendHeight) {
    }

    public void onReleasing(float percent, int offset, int headerHeight, int extendHeight) {
    }

    protected abstract AnimationDrawable getPullingAnimationDrawable();

    protected abstract AnimationDrawable getLoadingAnimationDrawable();
}

