/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicchanneltemplate.component;

import android.app.Activity;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import com.alibaba.android.arouter.launcher.ARouter;
import com.trello.rxlifecycle2.android.FragmentEvent;
import com.trello.rxlifecycle2.components.support.RxDialogFragment;
import com.unionyy.mobile.spdt.Spdt;
import com.unionyy.mobile.spdt.annotation.MEIPAI;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.RxBus;
import com.yy.mobile.event.ui.ComponentLifecycleEvent;
import com.yy.mobile.ui.basicchanneltemplate.component.ComponentDimension;
import com.yy.mobile.ui.basicchanneltemplate.component.IComponentContainer;
import com.yy.mobile.ui.basicchanneltemplate.component.IComponentRoot;
import com.yy.mobile.ui.basicchanneltemplate.component.IPopupComponent;
import com.yy.mobile.util.ActivityUtilKt;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.popupmanager.IPopupManagerCore;
import com.yymobile.core.popupmanager.ISupportPopupManager;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.functions.Functions;

public abstract class PopupComponent
extends RxDialogFragment
implements IPopupComponent,
EventCompat,
ISupportPopupManager {
    private static final String TAG = "PopupComponent";
    private int mOrientation = 1;
    private ComponentDimension dimension;
    private IComponentRoot mRoot;
    private Disposable mLifecycleDisposable;
    private volatile boolean isPopupComponentDimissed = true;
    private IPopupManagerCore mPopupManagerCore = (IPopupManagerCore)CoreFactory.getCore(IPopupManagerCore.class);
    private Window window;

    public PopupComponent() {
        this.mLifecycleDisposable = this.lifecycle().subscribe((Consumer)new Consumer<FragmentEvent>(){

            public void accept(FragmentEvent event) throws Exception {
                ComponentLifecycleEvent e2 = new ComponentLifecycleEvent((Fragment)PopupComponent.this, event);
                RxBus.getDefault().post((Object)e2);
                if (event == FragmentEvent.DETACH && PopupComponent.this.mLifecycleDisposable != null && !PopupComponent.this.mLifecycleDisposable.isDisposed()) {
                    PopupComponent.this.mLifecycleDisposable.dispose();
                }
            }
        }, Functions.emptyConsumer());
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        if (this.getDialog() == null) {
            this.setShowsDialog(false);
            MLog.error((Object)TAG, (String)"\u5f02\u5e38\u72b6\u6001", (Object[])new Object[0]);
        }
        super.onActivityCreated(savedInstanceState);
        this.setComponentCreated(true);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ICoreManagerBase.addClient(this);
        this.onEventBind();
        ARouter.getInstance().inject((Object)this);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (Spdt.currentFlavor() instanceof MEIPAI) {
            // empty if block
        }
    }

    public void onStart() {
        super.onStart();
        int orientation = ActivityUtilKt.getConfigurationsOrientation((Activity)this.getActivity());
        if (this.mOrientation != orientation) {
            this.mOrientation = orientation;
            this.onOrientationChanged(orientation == 2);
        }
    }

    public void onDestroy() {
        ICoreManagerBase.removeClient(this);
        this.onEventUnBind();
        super.onDestroy();
        MLog.debug((Object)TAG, (String)"onDestroy:", (Object[])new Object[0]);
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        MLog.debug((Object)TAG, (String)"onDismiss:", (Object[])new Object[0]);
        this.isPopupComponentDimissed = true;
    }

    @Override
    public void show(FragmentManager fm, Bundle data) {
        this.show(fm, data, this.getClass().getCanonicalName());
    }

    @Override
    public void show(FragmentManager fm, Bundle data, String tag) {
        Bundle original = this.getArguments();
        if (data != null) {
            if (original != null) {
                original.clear();
                original.putAll(data);
            } else {
                this.setArguments(data);
            }
        }
        this.show(fm, tag);
    }

    public void show(FragmentManager manager, String tag) {
        if (!this.mPopupManagerCore.checkPopupPermission(this)) {
            MLog.info((Object)TAG, (String)"No popup permission currently", (Object[])new Object[0]);
            return;
        }
        if (!this.isPopupComponentDimissed) {
            return;
        }
        if (manager.isDestroyed()) {
            return;
        }
        if (!manager.isStateSaved()) {
            super.show(manager, tag);
            this.isPopupComponentDimissed = false;
        }
        MLog.debug((Object)TAG, (String)("isPopupComponentDimissed:" + this.isPopupComponentDimissed), (Object[])new Object[0]);
    }

    @Override
    public void hide() {
        this.dismissAllowingStateLoss();
    }

    @Override
    public boolean isShowing() {
        return this.getDialog() != null && this.getDialog().isShowing() || !this.isPopupComponentDimissed;
    }

    @Override
    public IComponentRoot getRoot() {
        return this.mRoot;
    }

    @Override
    public void setTemplate(IComponentRoot template) {
        this.mRoot = template;
    }

    @Override
    public IComponentContainer getParent() {
        return null;
    }

    @Override
    public void setParent(IComponentContainer parent) {
    }

    @Override
    public Fragment getContent() {
        return this;
    }

    @Override
    public boolean isInitHidden() {
        return true;
    }

    @Override
    public void setInitHidden(boolean hidden) {
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.mOrientation != newConfig.orientation) {
            this.mOrientation = newConfig.orientation;
            this.onOrientationChanged(newConfig.orientation == 2);
        }
    }

    public void onEventBind() {
    }

    public void onEventUnBind() {
    }

    @Override
    public void onOrientationChanged(boolean isLandscape) {
    }

    public void onDestroyView() {
        try {
            if (this.getView() != null && (ViewGroup)this.getView().getParent() != null) {
                ((ViewGroup)this.getView().getParent()).removeView(this.getView());
            }
            super.onDestroyView();
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (Throwable)throwable);
        }
    }

    @Override
    public int getDefinedPopupLevel() {
        return 0;
    }

    @Override
    public void showSelf() {
        this.show(this.getFragmentManager(), "");
    }

    @Override
    public void hideSelf() {
        this.hide();
    }

    @Override
    public ComponentDimension getDimension() {
        if (this.dimension == null) {
            this.dimension = new ComponentDimension();
        }
        if (this.getView() != null) {
            this.dimension.x = this.getView().getX();
            this.dimension.y = this.getView().getY();
            this.dimension.width = this.getView().getWidth();
            this.dimension.height = this.getView().getHeight();
        }
        return this.dimension;
    }

    @Override
    public boolean isComponentCreated() {
        return false;
    }

    @Override
    public void setComponentCreated(boolean componentCreated) {
    }
}

