/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core.shenqu;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.WindowManager;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.http.DiskCache;
import com.yy.mobile.util.CommonUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.VersionUtil;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.pref.CommonPref;
import com.yy.mobile.util.valid.BlankUtil;
import com.yymobile.core.AppConstants;
import com.yymobile.core.shenqu.ShenquConstant;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ShenquUtils {
    public static final String LABEL_SNAPSHOT = "labelsnapshot";
    public static final String SHENQU_ROOT_DIR_NAME = "shenqu";
    public static final String SHENQU_RELATIVE_ROOT_DIR = AppConstants.YYMOBILE_DIR_NAME + File.separator + "shenqu";
    private static String SPLASH_FIRST_USE_VERSION = "splash_first_use_version";
    public static final int TYPE_SHENQU = 1;
    public static final int TYPE_DUANPAI = 2;

    public static String getShenquRootDir() {
        File cacheDir = DiskCache.getCacheDir((Context)BasicConfig.getInstance().getAppContext(), (String)AppConstants.YYMOBILE_DIR_NAME);
        String rootDir = cacheDir.getAbsolutePath() + File.separator + SHENQU_ROOT_DIR_NAME;
        File file = new File(rootDir);
        if (!file.exists()) {
            file.mkdirs();
        }
        return rootDir;
    }

    public static String getShenquRecordDir() {
        File file = new File(ShenquUtils.getShenquRootDir() + File.separator + "camera");
        if (!file.exists()) {
            file.mkdirs();
        }
        return file.getAbsolutePath();
    }

    public static String getVideoScreenDir() {
        return ShenquUtils.getShenquRootDir() + File.separator + "videoscreen";
    }

    public static String getLabelSnapshotDir() {
        String snapshotDir = ShenquUtils.getShenquRootDir() + File.separator + LABEL_SNAPSHOT;
        File file = new File(snapshotDir);
        if (!file.exists()) {
            file.mkdirs();
        }
        return snapshotDir;
    }

    public static String getShenquPicsIntoVideoDir() {
        return ShenquUtils.getShenquRootDir() + File.separator + "camera" + File.separator + "pics2video";
    }

    public static String getShenquMusicRecordDir() {
        return ShenquUtils.getShenquRootDir() + File.separator + "audio";
    }

    public static String getShenquOfficialResourceDir() {
        return ShenquUtils.getShenquRootDir() + File.separator + "resources";
    }

    public static String getStickerDir() {
        String stickerDir = ShenquUtils.getShenquRootDir() + File.separator + ".sticker";
        File file = new File(stickerDir);
        if (!file.exists()) {
            file.mkdirs();
        }
        return stickerDir;
    }

    public static <T> T cast(Object obj, Class<T> type) {
        if (!type.isInstance(obj)) {
            return null;
        }
        return type.cast(obj);
    }

    public static boolean assertt(boolean condition) {
        if (!condition) {
            // empty if block
        }
        return condition;
    }

    public static boolean isExistsFile(String location) {
        File file = new File(location);
        return file.exists();
    }

    public static void printMethodCallStack(String tag) {
        StackTraceElement[] ste;
        Map<Thread, StackTraceElement[]> ts = Thread.getAllStackTraces();
        for (StackTraceElement s : ste = ts.get(Thread.currentThread())) {
            if (!MLog.isLogLevelAboveDebug()) continue;
            MLog.debug((Object)tag, (String)s.toString(), (Object[])new Object[0]);
        }
    }

    public static String convertDigit(long digit, int multiple) {
        BigDecimal big = new BigDecimal(digit);
        return big.divide(new BigDecimal(multiple), 1, 1).toString();
    }

    public static StringBuffer wrapCount(long count) {
        StringBuffer sb = new StringBuffer();
        if (count >= 100000000L) {
            sb.append(ShenquUtils.convertDigit(count, 100000000));
            sb.append("\u4ebf");
        } else if (count >= 10000L) {
            sb.append(ShenquUtils.convertDigit(count, 10000));
            sb.append("\u4e07");
        } else {
            sb.append(count);
        }
        return sb;
    }

    public static StringBuffer wrapMusicPlayCount(long count) {
        StringBuffer sb = new StringBuffer();
        if (count >= 100000000L) {
            sb.append(ShenquUtils.convertDigit(count, 100000000));
            sb.append("\u4ebf");
        } else if (count >= 10000000L) {
            sb.append(ShenquUtils.convertDigit(count, 10000));
            sb.append("\u4e07");
        } else {
            sb.append(count);
        }
        return sb;
    }

    public static boolean isContainEmoji(String source) {
        return ShenquUtils.hasEmoji(source);
    }

    public static boolean isNotEmojiCharacter(char codePoint) {
        return codePoint == '\u0000' || codePoint == '\t' || codePoint == '\n' || codePoint == '\r' || codePoint >= ' ' && codePoint <= '\ud7ff' || codePoint >= '\ue000' && codePoint <= '\ufffd' || codePoint >= '\u10000' && codePoint <= '\u10ffff';
    }

    public static boolean hasEmoji(String source) {
        int len = source.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char codePoint = source.charAt(i2);
            if (ShenquUtils.isNotEmojiCharacter(codePoint)) continue;
            return true;
        }
        return false;
    }

    public static String wrapShareCount(int hotDegree) {
        String resultStr = hotDegree + "";
        double temp = (double)hotDegree / 10000.0;
        if (temp >= 1.0) {
            resultStr = (temp = (double)Math.round(temp * 10.0) / 10.0) + "";
            if (resultStr.indexOf(".") > 0) {
                resultStr = resultStr.replaceAll("[10]$", "");
                resultStr = resultStr.replaceAll("[.]$", "");
            }
            resultStr = resultStr + "\u4e07";
        }
        return resultStr;
    }

    public static String filterEmoji(String source) {
        String result = "";
        Pattern unicodeOutliers = Pattern.compile("[\ud83c\udc00-\ud83c\udfff]|[\ud83d\udc00-\ud83d\udfff]|[\u2600-\u27ff]", 66);
        Matcher unicodeOutlierMatcher = unicodeOutliers.matcher(source);
        result = unicodeOutlierMatcher.replaceAll("");
        return result;
    }

    public static String getDurationAppend(int duration) {
        String durationStr = "";
        if (duration > 59) {
            int i2 = duration / 60;
            if (i2 > 8760) {
                int j = i2 / 8760;
                durationStr = j + "\u5e74\u524d";
            } else if (i2 > 720) {
                int j = i2 / 720;
                durationStr = j + "\u4e2a\u6708\u524d";
            } else if (i2 > 23) {
                int j = i2 / 24;
                durationStr = j + "\u5929\u524d";
            } else {
                durationStr = i2 + "\u5c0f\u65f6\u524d";
            }
        } else {
            durationStr = duration > 0 ? duration + "\u5206\u949f\u524d" : "\u521a\u521a";
        }
        return durationStr;
    }

    public static float getRatio(String dpi) {
        try {
            String[] strings = dpi.split("\\*");
            float width = Float.parseFloat(strings[0]);
            float height = Float.parseFloat(strings[1]);
            float ratio = height / width;
            if (ratio > 2.0f) {
                ratio = 2.0f;
            } else if (ratio < 0.5f) {
                ratio = 0.5f;
            }
            return ratio;
        }
        catch (Throwable e2) {
            return 0.75f;
        }
    }

    public static boolean isNewVersion() {
        String lastVersion;
        String currentVersion = VersionUtil.getLocalVer((Context)BasicConfig.getInstance().getAppContext()).getVersionNameFor3GReq();
        return !currentVersion.equalsIgnoreCase(lastVersion = CommonPref.instance().getString(SPLASH_FIRST_USE_VERSION));
    }

    public static ObjectAnimator animateRotation(View view) {
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)view, (String)"rotation", (float[])new float[]{0.0f, 360.0f});
        animator.setDuration(1500L);
        animator.setRepeatCount(100);
        animator.start();
        return animator;
    }

    public static void animateAlphaHide(final View view, final List<ObjectAnimator> mStarAnimates) {
        if (view.getVisibility() == 0) {
            ObjectAnimator alphaAnimator = ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{0.8f, 0.0f});
            alphaAnimator.setDuration(400L);
            alphaAnimator.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animator) {
                }

                public void onAnimationEnd(Animator animator) {
                    for (int i2 = 0; i2 < mStarAnimates.size(); ++i2) {
                        ((ObjectAnimator)mStarAnimates.get(i2)).cancel();
                    }
                    mStarAnimates.clear();
                    view.setVisibility(8);
                }

                public void onAnimationCancel(Animator animator) {
                }

                public void onAnimationRepeat(Animator animator) {
                }
            });
            alphaAnimator.start();
        }
    }

    public static void animateAlphaShow(final View view) {
        if (view.getVisibility() != 0) {
            ObjectAnimator alphaAnimator = ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{0.0f, 0.8f});
            alphaAnimator.setDuration(400L);
            alphaAnimator.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animator) {
                    view.setVisibility(0);
                }

                public void onAnimationEnd(Animator animator) {
                }

                public void onAnimationCancel(Animator animator) {
                }

                public void onAnimationRepeat(Animator animator) {
                }
            });
            alphaAnimator.start();
        }
    }

    public static int string2int(String string2, int def) {
        try {
            def = Integer.parseInt(string2);
            return def;
        }
        finally {
            return def;
        }
    }

    public static int calTextCharLength(String src) {
        if (StringUtils.isEmpty((String)src).booleanValue()) {
            return 0;
        }
        int length = 0;
        String[] list = src.split("");
        for (int i2 = 0; i2 < list.length; ++i2) {
            String s = list[i2];
            int len = s.getBytes().length;
            if (len == 1) {
                ++length;
                continue;
            }
            if (len == 3) {
                ++length;
                continue;
            }
            if (len != 4) continue;
            ++length;
        }
        return length;
    }

    public static String subStringTextChar(String str, int len) {
        int length = ShenquUtils.calTextCharLength(str);
        if (length <= len) {
            return str;
        }
        StringBuilder result = new StringBuilder();
        String[] list = str.split("");
        for (int i2 = 0; i2 <= len; ++i2) {
            result.append(list[i2]);
        }
        return result.toString();
    }

    public static String createRecordFileName() {
        String dateString = ShenquUtils.createTimeStr();
        String name = dateString + ".mp4";
        return name;
    }

    public static String createTimeStr() {
        Date currentTime = new Date();
        SimpleDateFormat formatter = CommonUtils.getSimpleDateFormat((String)"yyyy-MM-dd-HH-mm-ss");
        String dateString = formatter.format(currentTime);
        return dateString;
    }

    public static Spannable parseTopicSpannable(CharSequence charSequence) {
        return ShenquUtils.parseTopicSpannable(charSequence, Color.parseColor((String)"#DD000000"), Color.parseColor((String)"#5AA3E8"));
    }

    public static Spannable parseTopicSpannable(CharSequence charSequence, int groundColor, int matcherColor) {
        return ShenquUtils.parseTopicSpannable(charSequence, "#[^#]+?#", groundColor, matcherColor);
    }

    public static Spannable parseTopicSpannable(CharSequence charSequence, String patternCharSequence, int groundColor, int matcherColor) {
        if (charSequence.length() <= 0) {
            return null;
        }
        Object spannable = charSequence instanceof Spannable ? (Spannable)charSequence : new SpannableString(charSequence);
        spannable.setSpan((Object)new ForegroundColorSpan(groundColor), 0, spannable.length(), 33);
        Pattern p = Pattern.compile(patternCharSequence);
        Matcher m = p.matcher(charSequence);
        while (m.find()) {
            String topic = m.group(0);
            String text = charSequence.toString();
            int start = 0;
            while ((start = text.indexOf(topic, start)) > -1) {
                int end = start + topic.length();
                spannable.setSpan((Object)new ForegroundColorSpan(matcherColor), start, end, 33);
                start = end + 1;
            }
        }
        return spannable;
    }

    public static int getViewWidth(View view, int defaultWidth) {
        int width = view.getWidth();
        if (width == 0) {
            DisplayMetrics metrics = new DisplayMetrics();
            ((WindowManager)view.getContext().getSystemService("window")).getDefaultDisplay().getMetrics(metrics);
            view.measure(View.MeasureSpec.makeMeasureSpec((int)metrics.widthPixels, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)metrics.heightPixels, (int)Integer.MIN_VALUE));
            if (width == 0) {
                width = defaultWidth;
            }
        }
        return width;
    }

    public static int getVideoType(long resId) {
        if (127L == (resId & 0xFF00000000000000L) >> 56) {
            return 2;
        }
        return 1;
    }

    public static String toTimeHHmmss(long duration) {
        SimpleDateFormat formatter = CommonUtils.getSimpleDateFormat((String)"HH:mm:ss");
        formatter.setTimeZone(TimeZone.getTimeZone("GMT+0"));
        return formatter.format(duration);
    }

    public static long toMilliSecondTime(String dateStr) {
        SimpleDateFormat dateFormat = CommonUtils.getSimpleDateFormat((String)"yyyy-MM-dd HH:mm:ss");
        try {
            return dateFormat.parse(dateStr).getTime();
        }
        catch (ParseException e2) {
            MLog.error((Object)"ShenquUtils", (String)("toMilliSecondTime ParseException e =" + e2), (Object[])new Object[0]);
            return 0L;
        }
    }

    public static String getFormatTimeString(long timeMillis, String format) {
        if (format == null || format.length() == 0) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timeMillis);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        String timeString = null;
        try {
            timeString = format.replaceAll("year", String.valueOf(year)).replaceAll("mon", month < 10 ? "0" + month : "" + month).replaceAll("day", day < 10 ? "0" + day : "" + day).replaceAll("hour", hour < 10 ? "0" + hour : "" + hour).replaceAll("min", "00").replaceAll("sec", "00");
        }
        catch (Exception e2) {
            MLog.error((Object)"ShenquUtils", (String)("getFormatTimeString error! " + e2.toString()), (Object[])new Object[0]);
        }
        return timeString;
    }

    public static long formatTimeOutPut(String dateStr) {
        long startMilliSecond = 0L;
        if (BlankUtil.isBlank((String)dateStr)) {
            return startMilliSecond;
        }
        Object[] startPart = dateStr.split(" ");
        Object startDatePart = "";
        Object startTimePart = "";
        String startHourPart = "";
        if (!BlankUtil.isBlank((Object[])startPart)) {
            startDatePart = startPart[0];
            startTimePart = startPart[1];
        }
        if (!BlankUtil.isBlank((String)startTimePart) && ((String)startTimePart).indexOf(":") != -1) {
            startHourPart = ((String)startTimePart).split(":")[0];
        }
        if (!BlankUtil.isBlank((String)startDatePart) && !BlankUtil.isBlank((String)startHourPart)) {
            startMilliSecond = ShenquUtils.toMilliSecondTime((String)startDatePart + " " + startHourPart + ":00:00");
        }
        return startMilliSecond;
    }

    public static String bytes2kb(long bytes) {
        BigDecimal filesize = new BigDecimal(bytes);
        BigDecimal megabyte = new BigDecimal(0x100000);
        float returnValue = filesize.divide(megabyte, 1, 0).floatValue();
        if (returnValue > 1.0f) {
            return returnValue + "M";
        }
        BigDecimal kilobyte = new BigDecimal(1024);
        returnValue = filesize.divide(kilobyte, 1, 0).floatValue();
        return returnValue + "K";
    }

    public static Bitmap compressBySize(Bitmap bitmap, int targetWidth, int targetHeight) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = true;
        bitmap = BitmapFactory.decodeByteArray((byte[])baos.toByteArray(), (int)0, (int)baos.toByteArray().length, (BitmapFactory.Options)opts);
        int imgWidth = opts.outWidth;
        int imgHeight = opts.outHeight;
        int widthRatio = (int)Math.ceil((float)imgWidth / (float)targetWidth);
        int heightRatio = (int)Math.ceil((float)imgHeight / (float)targetHeight);
        if (widthRatio > 1 || heightRatio > 1) {
            opts.inSampleSize = widthRatio > heightRatio ? widthRatio : heightRatio;
        }
        opts.inJustDecodeBounds = false;
        Bitmap compressedBitmap = BitmapFactory.decodeByteArray((byte[])baos.toByteArray(), (int)0, (int)baos.toByteArray().length, (BitmapFactory.Options)opts);
        ShenquUtils.recycleBitmap(bitmap);
        return compressedBitmap;
    }

    public static void recycleBitmap(Bitmap bitmap) {
        if (bitmap != null && !bitmap.isRecycled()) {
            bitmap.recycle();
            bitmap = null;
        }
    }

    public static Bitmap compressByQuality(Bitmap bitmap, int maxSize) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int quality = 100;
        bitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)baos);
        boolean isCompressed = false;
        while (baos.toByteArray().length / 1024 > maxSize) {
            baos.reset();
            bitmap.compress(Bitmap.CompressFormat.JPEG, quality -= 10, (OutputStream)baos);
            isCompressed = true;
        }
        if (isCompressed) {
            Bitmap compressedBitmap = BitmapFactory.decodeByteArray((byte[])baos.toByteArray(), (int)0, (int)baos.toByteArray().length);
            ShenquUtils.recycleBitmap(bitmap);
            return compressedBitmap;
        }
        return bitmap;
    }

    public static ShenquConstant.Type checkType(long resId) {
        long type = (resId & 0xFF00000000000000L) >> 56;
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"ShenquUtils", (String)("checkType resId:" + resId + ", type:" + type), (Object[])new Object[0]);
        }
        if (type == 15L) {
            return ShenquConstant.Type.Shenqu;
        }
        if (type == 127L) {
            return ShenquConstant.Type.ShortVideo;
        }
        return ShenquConstant.Type.None;
    }

    public static String formatSmallVideoPlayCount(int number) {
        String numStr = number < 10000 ? number + "" : (number >= 10000 && number < 1000000 ? String.format(Locale.CHINA, "%.1f", Math.ceil((double)number / 1000.0) / 10.0) + "\u4e07" : Math.round((float)number / 10000.0f) + "\u4e07");
        return numStr;
    }
}

