/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core.playtogether.anchor.timeelapse;

import android.content.Context;
import android.graphics.Rect;
import android.support.annotation.Nullable;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.yy.mobile.ui.DialogBaseActivity;
import com.yy.mobile.ui.utils.DimensUtils;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.playtogether.PlayTogetherHelper;
import com.yymobile.core.playtogether.anchor.timeelapse.ITimeElapse;
import com.yymobile.core.playtogether.anchor.timeelapse.ItemView;
import com.yymobile.core.playtogether.anchor.timeelapse.TimeElapseMessageManager;
import com.yymobile.core.playtogether.anchor.timeelapse.TimeUpdateViewHolder;
import java.util.ArrayList;
import java.util.List;

public class TimeElapseRecyclerView
extends RecyclerView {
    private static final String TAG = "TimeElapseRecyclerView";
    private ItemView mItemView;
    private MessageAdapter mAdapter;
    private int mMaxShowSize = 2;
    private TimeElapseMessageManager.UpdateListener mUpdateListener = new TimeElapseMessageManager.UpdateListener(){

        @Override
        public void notifyUpdate(List<Integer> delIndexList, List<ITimeElapse> showingData, int addCount) {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)(this.toString() + ", list:" + this.hashCode()), (String)("" + (TimeElapseRecyclerView.this.getVisibility() == 0)), (Object[])new Object[0]);
            }
            if (TimeElapseRecyclerView.this.getVisibility() != 0) {
                TimeElapseRecyclerView.this.setVisibility(0);
            }
            TimeElapseRecyclerView.this.mAdapter.setData(showingData);
            if (delIndexList.isEmpty() && addCount <= 0) {
                if (TimeElapseRecyclerView.this.getChildCount() == 0) {
                    TimeElapseRecyclerView.this.mAdapter.notifyDataSetChanged();
                    return;
                }
                for (int i2 = 0; i2 < TimeElapseRecyclerView.this.getChildCount() && i2 < TimeElapseRecyclerView.this.mAdapter.getItemCount(); ++i2) {
                    View childView = TimeElapseRecyclerView.this.getChildAt(i2);
                    Object tag = childView.getTag();
                    if (!(tag instanceof TimeUpdateViewHolder)) continue;
                    TimeUpdateViewHolder viewHolder = (TimeUpdateViewHolder)((Object)childView.getTag());
                    viewHolder.updateTime(TimeElapseRecyclerView.this.mAdapter.getItem(i2));
                }
                return;
            }
            if (!delIndexList.isEmpty()) {
                while (!delIndexList.isEmpty()) {
                    TimeElapseRecyclerView.this.mAdapter.notifyItemRemoved(delIndexList.remove(0));
                }
                if (addCount > 0) {
                    TimeElapseRecyclerView.this.mAdapter.notifyItemRangeInserted(TimeElapseRecyclerView.this.mMaxShowSize - addCount, addCount);
                }
                TimeElapseRecyclerView.this.mAdapter.notifyItemRangeChanged(0, showingData.size());
            } else if (addCount > 0) {
                TimeElapseRecyclerView.this.mAdapter.notifyItemRangeInserted(TimeElapseRecyclerView.this.mMaxShowSize - addCount, addCount);
                TimeElapseRecyclerView.this.mAdapter.notifyItemRangeChanged(0, showingData.size());
            } else {
                TimeElapseRecyclerView.this.mAdapter.notifyDataSetChanged();
            }
            if (TimeElapseRecyclerView.this.mAdapter != null && FP.empty(((TimeElapseRecyclerView)TimeElapseRecyclerView.this).mAdapter.mDataList)) {
                Context context = TimeElapseRecyclerView.this.getContext();
                if (context != null && context instanceof DialogBaseActivity) {
                    ((DialogBaseActivity)context).removePushView();
                } else {
                    PlayTogetherHelper.INSTANCE.destroyHomeActPushView(context);
                }
            }
        }

        @Override
        public void setItemView(ItemView itemView) {
            TimeElapseRecyclerView.this.mItemView = itemView;
        }

        @Override
        public void clear() {
            if (TimeElapseRecyclerView.this.getVisibility() != 0) {
                TimeElapseRecyclerView.this.setVisibility(0);
            }
            ((TimeElapseRecyclerView)TimeElapseRecyclerView.this).mAdapter.mDataList.clear();
            TimeElapseRecyclerView.this.mAdapter.notifyDataSetChanged();
        }
    };

    public TimeElapseRecyclerView(Context context) {
        super(context);
        this.init(context);
    }

    public TimeElapseRecyclerView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public TimeElapseRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    public void setMaxShowSize(int maxShowSize) {
        this.mMaxShowSize = maxShowSize;
        TimeElapseMessageManager.INSTANCE.setMaxShowSize(maxShowSize);
    }

    public void setItemView(ItemView itemView) {
        this.mItemView = itemView;
    }

    public void start() {
        MLog.info((Object)TAG, (String)"start", (Object[])new Object[0]);
        this.setVisibility(8);
        TimeElapseMessageManager.INSTANCE.addUpdateListener(((Object)((Object)this)).hashCode(), this.mUpdateListener);
    }

    public void stop() {
        MLog.info((Object)TAG, (String)"stop", (Object[])new Object[0]);
        this.setVisibility(8);
        TimeElapseMessageManager.INSTANCE.removeUpdateListener(((Object)((Object)this)).hashCode());
    }

    private void init(Context context) {
        this.mAdapter = new MessageAdapter();
        this.setAdapter(this.mAdapter);
        this.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
        this.addItemDecoration(new RecyclerView.ItemDecoration(){

            public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
                outRect.set(0, DimensUtils.dip2pixel((Context)parent.getContext(), (float)5.0f), 0, 0);
            }
        });
        DefaultItemAnimator itemAnimator = new DefaultItemAnimator();
        itemAnimator.setAddDuration(500L);
        itemAnimator.setRemoveDuration(500L);
        itemAnimator.setChangeDuration(500L);
        this.setItemAnimator((RecyclerView.ItemAnimator)itemAnimator);
    }

    public boolean onTouchEvent(MotionEvent e2) {
        return false;
    }

    public boolean onInterceptTouchEvent(MotionEvent e2) {
        return false;
    }

    private static class MessageViewHolder
    extends TimeUpdateViewHolder {
        public MessageViewHolder(View itemView) {
            super(itemView);
        }

        @Override
        public void updateTime(ITimeElapse data) {
        }
    }

    private class MessageAdapter
    extends RecyclerView.Adapter<TimeUpdateViewHolder> {
        List<ITimeElapse> mDataList = new ArrayList<ITimeElapse>();

        private MessageAdapter() {
        }

        public void setData(List<ITimeElapse> dataList) {
            this.mDataList.clear();
            if (dataList != null) {
                this.mDataList.addAll(dataList);
            }
        }

        public ITimeElapse getItem(int pos) {
            return this.mDataList.get(pos);
        }

        public TimeUpdateViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            TimeUpdateViewHolder viewHolder;
            if (TimeElapseRecyclerView.this.mItemView != null && (viewHolder = TimeElapseRecyclerView.this.mItemView.onCreateViewHolder(parent, viewType)) != null) {
                return viewHolder;
            }
            return new MessageViewHolder(new View(parent.getContext()));
        }

        public void onBindViewHolder(TimeUpdateViewHolder holder, int position) {
            if (TimeElapseRecyclerView.this.mItemView != null) {
                TimeElapseRecyclerView.this.mItemView.onBindViewHolder(holder, this.getItem(position), this.getItemViewType(position));
            }
        }

        public int getItemCount() {
            return this.mDataList.size();
        }

        public int getItemViewType(int position) {
            return this.getItem(position).viewType();
        }
    }
}

