/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core.playtogether.anchor.timeelapse;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.yy.mobile.ui.DialogBaseActivity;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.activity.YYActivityManager;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.playtogether.PlayTogetherHelper;
import com.yymobile.core.playtogether.anchor.timeelapse.ITimeElapse;
import com.yymobile.core.playtogether.anchor.timeelapse.ItemView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public enum TimeElapseMessageManager {
    INSTANCE;

    private static final String TAG = "TimeElapseMessageManager";
    private List<ITimeElapse> mWaitingData = new LinkedList<ITimeElapse>();
    private List<ITimeElapse> mShowingData = new LinkedList<ITimeElapse>();
    private List<Integer> mDelIndex = new ArrayList<Integer>();
    private List<ITimeElapse> mDelData = new ArrayList<ITimeElapse>();
    private boolean mUiInTransition = false;
    private ConcurrentHashMap<Integer, UpdateListener> mUpdateListenerHashMap = new ConcurrentHashMap();
    private int maxShowSize = 2;
    private final int duration = 1;
    private boolean mStarted = false;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    TimeListener mTimeListener;
    Runnable updateTask = new Runnable(){

        @Override
        public void run() {
            if (TimeElapseMessageManager.this.mWaitingData.isEmpty() && TimeElapseMessageManager.this.mShowingData.isEmpty()) {
                TimeElapseMessageManager.this.mStarted = false;
                return;
            }
            TimeElapseMessageManager.this.mStarted = true;
            TimeElapseMessageManager.this.timeElapse();
            TimeElapseMessageManager.this.mHandler.postDelayed((Runnable)this, 1000L);
        }
    };

    public void setItemView(ItemView itemView) {
        for (UpdateListener updateListener : this.mUpdateListenerHashMap.values()) {
            updateListener.setItemView(itemView);
            if (!MLog.isLogLevelAboveDebug()) continue;
            MLog.debug((Object)TAG, (String)"setItemView", (Object[])new Object[0]);
        }
    }

    public void addUpdateListener(int key, UpdateListener updateListener) {
        MLog.info((Object)TAG, (String)("addUpdateListener:" + key), (Object[])new Object[0]);
        this.mUpdateListenerHashMap.put(key, updateListener);
    }

    public void removeUpdateListener(int key) {
        MLog.info((Object)TAG, (String)("removeUpdateListener:" + key), (Object[])new Object[0]);
        this.mUpdateListenerHashMap.remove(key);
    }

    public void setTimeListener(TimeListener timeListener) {
        this.mTimeListener = timeListener;
    }

    public void setMaxShowSize(int maxShowSize) {
        this.maxShowSize = maxShowSize;
    }

    public void add(ITimeElapse timeElapse) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.info((Object)TAG, (String)("push data ack:" + timeElapse.toString()), (Object[])new Object[0]);
        }
        if (this.mWaitingData.contains(timeElapse) || this.mShowingData.contains(timeElapse)) {
            MLog.info((Object)TAG, (String)("add return, mWaitingData.contains(timeElapse):" + this.mWaitingData.contains(timeElapse) + ", mShowingData.contains(timeElapse):" + this.mShowingData.contains(timeElapse)), (Object[])new Object[0]);
            return;
        }
        this.mWaitingData.add(timeElapse);
        this.start();
    }

    public String toString() {
        return "waiting list size:" + this.mWaitingData.size() + ", showing list size:" + this.mShowingData.size();
    }

    public void remove(ITimeElapse timeElapse) {
        timeElapse.timeElapse(timeElapse.getRemainTime() * 2);
        this.mHandler.removeCallbacks(this.updateTask);
        this.mHandler.post(this.updateTask);
    }

    public void remove(long id2) {
        for (ITimeElapse data : this.mShowingData) {
            if (data.getId() != id2) continue;
            data.timeElapse(data.getRemainTime() * 2);
            break;
        }
        for (ITimeElapse data : this.mWaitingData) {
            if (data.getId() != id2) continue;
            data.timeElapse(data.getRemainTime() * 2);
            break;
        }
        this.mHandler.removeCallbacks(this.updateTask);
        this.mHandler.post(this.updateTask);
    }

    public void clear() {
        this.mShowingData.clear();
        this.mWaitingData.clear();
        for (UpdateListener updateListener : this.mUpdateListenerHashMap.values()) {
            updateListener.clear();
        }
    }

    public void uiTransition() {
        this.mUiInTransition = true;
    }

    public void start() {
        MLog.info((Object)TAG, (String)("start, mStarted" + this.mStarted), (Object[])new Object[0]);
        if (this.mStarted) {
            return;
        }
        this.mStarted = true;
        this.mHandler.post(this.updateTask);
    }

    public void stop() {
        this.mStarted = false;
        this.mUpdateListenerHashMap.clear();
    }

    private void timeElapse() {
        if (this.mUiInTransition) {
            this.mUiInTransition = false;
            return;
        }
        Iterator<ITimeElapse> it = this.mWaitingData.iterator();
        while (it.hasNext()) {
            ITimeElapse elapse = it.next();
            elapse.timeElapse(1);
            if (elapse.getRemainTime() >= 0) continue;
            it.remove();
        }
        this.mDelIndex.clear();
        this.mDelData.clear();
        int index = 0;
        Iterator<ITimeElapse> it2 = this.mShowingData.iterator();
        while (it2.hasNext()) {
            ITimeElapse elapse = it2.next();
            elapse.timeElapse(1);
            if (elapse.getRemainTime() < 0) {
                this.mDelData.add(elapse);
                it2.remove();
                this.mDelIndex.add(index);
            }
            ++index;
        }
        int addCount = 0;
        while (this.mShowingData.size() < this.maxShowSize && !this.mWaitingData.isEmpty()) {
            this.mShowingData.add(this.mWaitingData.remove(0));
            ++addCount;
        }
        if (!FP.empty(this.mShowingData)) {
            if (YYActivityManager.INSTANCE.getCurrentActivity() instanceof DialogBaseActivity) {
                DialogBaseActivity activity = (DialogBaseActivity)YYActivityManager.INSTANCE.getCurrentActivity();
                if (activity != null && !activity.isMessageRecyclerViewCreated()) {
                    activity.initPushView();
                }
            } else {
                PlayTogetherHelper.INSTANCE.showHomeActPushView((Context)YYActivityManager.INSTANCE.getCurrentActivity());
            }
        }
        for (UpdateListener updateListener : this.mUpdateListenerHashMap.values()) {
            updateListener.notifyUpdate(this.mDelIndex, this.mShowingData, addCount);
            if (!MLog.isLogLevelAboveDebug()) continue;
            MLog.debug((Object)TAG, (String)"push view update", (Object[])new Object[0]);
        }
        if (this.mTimeListener != null && !FP.empty(this.mDelData)) {
            this.mTimeListener.onTimeOut(this.mDelData);
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"push view time out", (Object[])new Object[0]);
            }
        }
    }

    public static interface UpdateListener {
        public void notifyUpdate(List<Integer> var1, List<ITimeElapse> var2, int var3);

        public void setItemView(ItemView var1);

        public void clear();
    }

    public static interface TimeListener {
        public void onTimeOut(List<ITimeElapse> var1);
    }
}

