/*
 * Decompiled with CFR 0.152.
 */
package com.yymobile.core.channel;

import android.text.SpannableStringBuilder;
import android.widget.TextView;
import com.yy.mobile.richtext.RichTextFilter;
import com.yy.mobile.ui.actmedal.core.ActMedalInfo;
import com.yy.mobile.util.DontProguardClass;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.channel.ChatMedalInfo;
import com.yymobile.core.channel.IParser;
import com.yymobile.core.medal.MedalBaseEntry;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

@DontProguardClass
public abstract class ChannelMessage
implements Cloneable {
    private static final String TAG = "ChannelMessage";
    public static final String tinyVideoIconCode = "[tinyVideoIcon]";
    public static final String nobleCode = "[noblelv]";
    public static final String trueloveCode = "[truelove]";
    public static final String knightCode = "[knight]";
    public static final String lftCode = "[lft]";
    public static final String roleLevelCode = "[role]";
    public static final int nickLengthLimit = 10;
    public static final String nickColor = "#ffda81";
    public static final String giftTxtColor = "#7bf0d6";
    public static final String noticeColor = "#bae05d";
    public static final String chatMessageColor = "#ffffff";
    public static final int GIFT_MESSAGE_IMAGE_SIZE_DP = 20;
    public static final int MEDAL_ICON_SIZE_DP = 18;
    public static final int HIGHT_PRIORITY = 3;
    public static final int COMMON_PRIORITY = 2;
    public static final int LOW_PRIORITY = 1;
    public String nickname = "";
    public String text = "";
    public String pureText = "";
    public long uid;
    public long sid = 0L;
    public int ignore;
    public int nobleLevel;
    public int vulgarLevel;
    public int roleLevel;
    public int knightLevel;
    public String paoSaoGroupName;
    public int paoSaoGroupLevel;
    public String treeholeName;
    public ActMedalInfo actMedalInfo;
    public String trueloveMedal = "";
    public int trueLoveLevel = 0;
    public String treasureFansLevelV2 = "";
    public String treasureBgUrlV2PC = "";
    public String treasureBgUrlV2MO = "";
    public String treasureAnchorUidV2 = "";
    public String truelovev5duanweiLv = "";
    public String avatarUrl = "";
    public String gifUri = "";
    public ChannelMsgType channelMessageType = ChannelMsgType.COMMON_MESSAGE_TYPE;
    public boolean isReplay = false;
    public SpannableStringBuilder spannable = null;
    public StringBuilder medals = new StringBuilder();
    public StringBuilder tail = new StringBuilder();
    public int priority = 3;
    public WeakReference<TextView> spannableTarget;
    public boolean isCBA;
    public Map<String, String> tailMap = new HashMap<String, String>();
    public List<ChatMedalInfo> commonMedals;
    public List tagsList;
    public IParser parser;
    public HashMap<Integer, HashMap<Integer, MedalBaseEntry>> medalEntryList = new HashMap();

    public ChannelMessage() {
    }

    public ChannelMessage(ChannelMessage msg) {
        if (msg != null) {
            this.nickname = msg.nickname;
            this.text = msg.text;
            this.pureText = msg.pureText;
            this.uid = msg.uid;
            this.sid = msg.sid;
            this.nobleLevel = msg.nobleLevel;
            this.vulgarLevel = msg.vulgarLevel;
            this.roleLevel = msg.roleLevel;
            this.knightLevel = msg.knightLevel;
            this.actMedalInfo = msg.actMedalInfo;
            this.trueloveMedal = msg.trueloveMedal;
            this.trueLoveLevel = msg.trueLoveLevel;
            this.avatarUrl = msg.avatarUrl;
            this.gifUri = msg.gifUri;
            this.channelMessageType = msg.channelMessageType;
            this.isReplay = msg.isReplay;
            this.spannable = msg.spannable;
            this.medals = msg.medals;
            this.tail = msg.tail;
            this.priority = msg.priority;
            this.spannableTarget = msg.spannableTarget;
            this.isCBA = msg.isCBA;
            this.tailMap = msg.tailMap;
            this.commonMedals = msg.commonMedals;
            this.paoSaoGroupName = msg.paoSaoGroupName;
            this.paoSaoGroupLevel = msg.paoSaoGroupLevel;
            this.treasureFansLevelV2 = msg.treasureFansLevelV2;
            this.treasureBgUrlV2MO = msg.treasureBgUrlV2MO;
            this.treasureBgUrlV2PC = msg.treasureBgUrlV2PC;
            this.treasureAnchorUidV2 = msg.treasureAnchorUidV2;
            this.truelovev5duanweiLv = msg.truelovev5duanweiLv;
            this.medalEntryList = msg.medalEntryList;
            this.parser = msg.parser;
        }
    }

    public String getFormatNick() {
        this.medals = new StringBuilder();
        this.tail = new StringBuilder();
        if (this.medalEntryList.size() > 0) {
            TreeMap<Integer, HashMap<Integer, MedalBaseEntry>> sort = new TreeMap<Integer, HashMap<Integer, MedalBaseEntry>>(this.medalEntryList);
            Set entrySet = sort.entrySet();
            for (Map.Entry entry : entrySet) {
                if (entry.getValue() == null) continue;
                for (MedalBaseEntry bean : ((HashMap)entry.getValue()).values()) {
                    if (!bean.canUse()) continue;
                    if (!bean.isTail()) {
                        this.medals.append(bean.getNote());
                        continue;
                    }
                    this.tail.append(bean.getNote());
                }
            }
        }
        StringBuilder mfHeadMedal = new StringBuilder();
        StringBuilder mfTail = new StringBuilder();
        boolean isOnlyOneTail = false;
        if (this.commonMedals != null) {
            Collections.sort(this.commonMedals, new Comparator<ChatMedalInfo>(){

                @Override
                public int compare(ChatMedalInfo lhs, ChatMedalInfo rhs) {
                    return lhs.priority - rhs.priority;
                }
            });
            for (ChatMedalInfo medal : this.commonMedals) {
                String imgKey = medal.imgKey;
                int pos = medal.pos;
                if (pos == 1) {
                    mfHeadMedal.append("[").append(imgKey).append("]");
                    continue;
                }
                if (pos == 2) {
                    this.medals.append("[").append(imgKey).append("]");
                    continue;
                }
                if (pos == 3) {
                    mfTail.append("[").append(imgKey).append("]");
                    continue;
                }
                if (pos == 4) {
                    if (isOnlyOneTail) continue;
                    this.tail.append("[").append(imgKey).append("]");
                    continue;
                }
                if (pos != 5) continue;
                isOnlyOneTail = true;
                this.tail = new StringBuilder();
                this.tail.append("[").append(imgKey).append("]");
            }
        }
        if (isOnlyOneTail) {
            mfTail = new StringBuilder();
        }
        return mfHeadMedal.toString() + this.medals + this.nickname + mfTail + this.tail;
    }

    public String toString() {
        return "ChannelMessage{nickname='" + this.nickname + '\'' + ", text='" + this.text + '\'' + ", pureText='" + this.pureText + '\'' + ", uid=" + this.uid + ", sid=" + this.sid + ", nobleLevel=" + this.nobleLevel + ", roleLevel=" + this.roleLevel + ", knightLevel=" + this.knightLevel + ", actMedalInfo=" + this.actMedalInfo + ", trueloveMedal='" + this.trueloveMedal + '\'' + ", trueLoveLevel=" + this.trueLoveLevel + ", avatarUrl='" + this.avatarUrl + '\'' + ", gifUri='" + this.gifUri + '\'' + ", channelMessageType=" + (Object)((Object)this.channelMessageType) + ", isReplay=" + this.isReplay + ", spannable=" + this.spannable + ", medals=" + this.medals + ", tail=" + this.tail + ", priority=" + this.priority + ", spannableTarget=" + this.spannableTarget + ", isCBA=" + this.isCBA + ", tailMap=" + this.tailMap + '}';
    }

    public ChannelMessage getInstanceCopy() {
        try {
            return (ChannelMessage)this.clone();
        }
        catch (CloneNotSupportedException e2) {
            MLog.error((Object)TAG, (Throwable)e2);
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public List<Class<? extends RichTextFilter>> getFeatures() {
        return null;
    }

    public boolean onBeforeParse() {
        return true;
    }

    public static enum ChannelMsgType {
        COMMON_MESSAGE_TYPE,
        CUSTOMS_MESSAGE_TYPE,
        NOTICE_MESSAGE_TYPE,
        NOBLEEMOTION_MESSAGE_TYPE,
        TURNTABLE_MESSAGE_TYPE,
        SHARE_MESSAGE_TYPE,
        SUBSCRIBE_MESSAGE_TYPE,
        TURE_LOVE_TYPE,
        TURNCHAIR_MESSAGE_TYPE,
        TURE_LOVE_UPGRADE_TYPE;

    }
}

