/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.webview.purewebview;

import android.content.Context;
import com.yy.mobile.ui.webview.purewebview.IPureWebview;
import com.yy.mobile.ui.webview.purewebview.IPurewebviewCore;
import com.yymobile.core.ICoreManagerBase;

public class PureWebviewUtil {

    public static class BuilderParamter {
        public String url;
        public boolean isTrans;
        public boolean isInvisible;
        public boolean isDisableJavascript;
        public boolean isDisablePull;
        public boolean isWebviewFeatureSet = false;
        public int webviewFeature;
        public boolean isOpenStatus;
    }

    public static class Builder {
        BuilderParamter builderParamter = new BuilderParamter();
        private Context context;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder setUrl(String url) {
            this.builderParamter.url = url;
            return this;
        }

        public Builder setBackgroudTrans(boolean isTrans) {
            this.builderParamter.isTrans = isTrans;
            return this;
        }

        public Builder setDisablePull(boolean isDisable) {
            this.builderParamter.isDisablePull = isDisable;
            return this;
        }

        public Builder setInvisible(boolean isInvisible) {
            this.builderParamter.isInvisible = isInvisible;
            return this;
        }

        public Builder setWebviewFeature(int feature) {
            this.builderParamter.isWebviewFeatureSet = true;
            this.builderParamter.webviewFeature = feature;
            return this;
        }

        public Builder setOpenStatus(boolean isOpenStatus) {
            this.builderParamter.isOpenStatus = isOpenStatus;
            return this;
        }

        public IPureWebview create() {
            IPureWebview pureWebview = ICoreManagerBase.getCore(IPurewebviewCore.class).createPureWebview(this.context, this.builderParamter);
            return pureWebview;
        }
    }
}

