/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils.dialog;

import android.app.Dialog;
import android.text.TextUtils;
import android.view.View;
import android.view.Window;
import android.widget.TextView;
import com.yy.mobile.ui.utils.dialog.BaseDialog;
import com.yy.mobile.ui.utils.dialog.OkCancelDialogListener;
import com.yymobile.baseapi.R;

public class OkCancelDialog
implements BaseDialog {
    protected CharSequence message;
    protected CharSequence okLabel;
    protected int okLabelColor = 0;
    protected CharSequence cancelLabel;
    protected int cancelLabelColor = 0;
    protected float lineSpacingExtra = -1.0f;
    protected float lineSpacingMultiplier = -1.0f;
    protected boolean cancelable;
    protected boolean outSideCancelable;
    protected boolean isNeedCenter = true;
    protected OkCancelDialogListener listener;

    public OkCancelDialog(Builder builder) {
        this(builder.message, builder.okLabel, builder.okLabelColor, builder.cancelLabel, builder.cancelLabelColor, builder.lineSpacingExtra, builder.lineSpacingMultiplier, builder.cancelable, builder.outSideCancelable, builder.isNeedCenter, builder.listener);
    }

    public OkCancelDialog(CharSequence message, CharSequence okLabel, int okLabelColor, CharSequence cancelLabel, int cancelLabelColor, float lineSpacingExtra, float lineSpacingMultiplier, boolean cancelable, boolean outSideCancelable, boolean isNeedCenter, OkCancelDialogListener listener) {
        this.message = message;
        this.okLabel = okLabel;
        this.okLabelColor = okLabelColor;
        this.cancelLabel = cancelLabel;
        this.cancelLabelColor = cancelLabelColor;
        this.lineSpacingExtra = lineSpacingExtra;
        this.lineSpacingMultiplier = lineSpacingMultiplier;
        this.cancelable = cancelable;
        this.outSideCancelable = outSideCancelable;
        this.isNeedCenter = isNeedCenter;
        this.listener = listener;
    }

    public OkCancelDialog(CharSequence message, CharSequence okLabel, int okLabelColor, CharSequence cancelLabel, int cancelLabelColor, boolean cancelable, boolean outSideCancelable, OkCancelDialogListener listener) {
        this(message, okLabel, okLabelColor, cancelLabel, cancelLabelColor, -1.0f, -1.0f, cancelable, outSideCancelable, true, listener);
    }

    public OkCancelDialog(CharSequence message, CharSequence okLabel, CharSequence cancelLabel, float lineSpacingExtra, float lineSpacingMultiplier, boolean cancelable, boolean outSideCancelable, boolean isNeedCenter, OkCancelDialogListener listener) {
        this(message, okLabel, 0, cancelLabel, 0, lineSpacingExtra, lineSpacingMultiplier, cancelable, outSideCancelable, isNeedCenter, listener);
    }

    public OkCancelDialog(CharSequence message, CharSequence okLabel, CharSequence cancelLabel, float lineSpacingExtra, float lineSpacingMultiplier, boolean cancelable, OkCancelDialogListener listener) {
        this(message, okLabel, 0, cancelLabel, 0, lineSpacingExtra, lineSpacingMultiplier, cancelable, cancelable, true, listener);
    }

    public OkCancelDialog(CharSequence message, CharSequence okLabel, CharSequence cancelLabel, boolean cancelable, boolean outSideCancelable, OkCancelDialogListener listener) {
        this(message, okLabel, 0, cancelLabel, 0, -1.0f, -1.0f, cancelable, outSideCancelable, true, listener);
    }

    public OkCancelDialog(CharSequence message, CharSequence okLabel, CharSequence cancelLabel, boolean cancelable, boolean outSideCancelable, boolean isNeedCenter, OkCancelDialogListener listener) {
        this(message, okLabel, 0, cancelLabel, 0, -1.0f, -1.0f, cancelable, outSideCancelable, isNeedCenter, listener);
    }

    public OkCancelDialog(CharSequence message, CharSequence okLabel, CharSequence cancelLabel, boolean cancelable, OkCancelDialogListener listener) {
        this(message, okLabel, 0, cancelLabel, 0, -1.0f, -1.0f, cancelable, cancelable, true, listener);
    }

    public OkCancelDialog(CharSequence message, CharSequence okLabel, CharSequence cancelLabel, OkCancelDialogListener listener) {
        this(message, okLabel, 0, cancelLabel, 0, -1.0f, -1.0f, true, true, true, listener);
    }

    public OkCancelDialog(CharSequence message, boolean cancelable, OkCancelDialogListener listener) {
        this(message, "\u786e\u5b9a", 0, "\u53d6\u6d88", 0, -1.0f, -1.0f, cancelable, cancelable, true, listener);
    }

    @Override
    public void init(final Dialog dialog) {
        dialog.setCancelable(this.cancelable);
        dialog.setCanceledOnTouchOutside(this.outSideCancelable);
        Window window = dialog.getWindow();
        window.setContentView(this.getLayoutResId());
        TextView tip = (TextView)window.findViewById(R.id.message);
        if (this.lineSpacingExtra != -1.0f && this.lineSpacingMultiplier != -1.0f) {
            tip.setLineSpacing(this.lineSpacingExtra, this.lineSpacingMultiplier);
        }
        if (!TextUtils.isEmpty((CharSequence)this.message)) {
            tip.setText(this.message);
        }
        if (this.isNeedCenter) {
            tip.setGravity(17);
        } else {
            tip.setGravity(19);
        }
        TextView ok = (TextView)window.findViewById(R.id.btn_ok);
        if (this.okLabelColor != 0) {
            ok.setTextColor(this.okLabelColor);
        }
        if (!TextUtils.isEmpty((CharSequence)this.okLabel)) {
            ok.setText(this.okLabel);
        }
        ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                dialog.dismiss();
                if (OkCancelDialog.this.listener != null) {
                    OkCancelDialog.this.listener.onOk();
                }
            }
        });
        TextView cancel = (TextView)window.findViewById(R.id.btn_cancel);
        if (this.cancelLabelColor != 0) {
            cancel.setTextColor(this.cancelLabelColor);
        }
        if (!TextUtils.isEmpty((CharSequence)this.cancelLabel)) {
            cancel.setText(this.cancelLabel);
        }
        cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                dialog.dismiss();
                if (OkCancelDialog.this.listener != null) {
                    OkCancelDialog.this.listener.onCancel();
                }
            }
        });
    }

    @Override
    public int getLayoutResId() {
        return R.layout.layout_ok_cancel_color_link_dialog;
    }

    public class Builder {
        public CharSequence message;
        public CharSequence okLabel;
        int okLabelColor = 0;
        public CharSequence cancelLabel;
        int cancelLabelColor = 0;
        float lineSpacingExtra = -1.0f;
        float lineSpacingMultiplier = -1.0f;
        public boolean cancelable;
        public boolean outSideCancelable;
        boolean isNeedCenter = true;
        public OkCancelDialogListener listener;

        public Builder message(CharSequence message) {
            this.message = message;
            return this;
        }

        public Builder okLabel(CharSequence okLabel) {
            this.okLabel = okLabel;
            return this;
        }

        public Builder okLabelColor(int okLabelColor) {
            this.okLabelColor = okLabelColor;
            return this;
        }

        public Builder setCancelLabel(CharSequence cancelLabel) {
            this.cancelLabel = cancelLabel;
            return this;
        }

        public Builder cancelLabelColor(int cancelLabelColor) {
            this.cancelLabelColor = cancelLabelColor;
            return this;
        }

        public Builder lineSpacingExtra(float lineSpacingExtra) {
            this.lineSpacingExtra = lineSpacingExtra;
            return this;
        }

        public Builder lineSpacingMultiplier(float lineSpacingMultiplier) {
            this.lineSpacingMultiplier = lineSpacingMultiplier;
            return this;
        }

        public Builder cancelable(boolean cancelable) {
            this.cancelable = cancelable;
            return this;
        }

        public Builder outSideCancelable(boolean outSideCancelable) {
            this.outSideCancelable = outSideCancelable;
            return this;
        }

        public Builder needCenter(boolean needCenter) {
            this.isNeedCenter = needCenter;
            return this;
        }

        public Builder listener(OkCancelDialogListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder build() {
            return new Builder();
        }
    }
}

