/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.guide;

import android.os.Handler;
import android.view.View;
import com.yy.mobile.ui.guide.DefaultOnce;
import com.yy.mobile.ui.guide.Guide;

public abstract class AbsGuide
implements Guide {
    protected boolean mBackKeyDismiss = false;
    protected long mAutoDismissDuration = -1L;
    protected View mGuideView;
    protected Guide.GuideViewBuilder mGuideViewBuilder;
    protected View mAchorView;
    boolean isShow = false;
    Guide.Intercept mIntercepts;
    Guide.LifeCallback mLifeCallbacks;
    private Handler mHandler;
    private String mKey;
    private Runnable mAutoDismissRunnable = new Runnable(){

        @Override
        public void run() {
            AbsGuide.this.dismiss();
        }
    };

    public AbsGuide(String key) {
        this.mKey = key;
    }

    @Override
    public void setBackKeyDismiss(boolean backKeyDismiss) {
        this.mBackKeyDismiss = backKeyDismiss;
    }

    @Override
    public void autoDismiss(long duration) {
        this.mAutoDismissDuration = duration;
    }

    @Override
    public void setAchorView(View view) {
        this.mAchorView = view;
    }

    @Override
    public void setGuideViewBuilder(Guide.GuideViewBuilder builder) {
        this.mGuideViewBuilder = builder;
    }

    @Override
    public void setIntercept(Guide.Intercept intercepts) {
        this.mIntercepts = intercepts;
    }

    @Override
    public void setLifeCallback(Guide.LifeCallback lifeCallbacks) {
        this.mLifeCallbacks = lifeCallbacks;
    }

    @Override
    public void show() {
        if (this.mIntercepts != null && this.mIntercepts.shouldIntercept(this.mKey)) {
            return;
        }
        if (this.mBackKeyDismiss) {
            this.subscribeBackKeyEvent();
        }
        if (this.mAutoDismissDuration > 0L) {
            if (this.mHandler == null) {
                this.mHandler = new Handler();
            }
            this.mHandler.postDelayed(this.mAutoDismissRunnable, this.mAutoDismissDuration);
        }
        this.showInternal();
        if (this.mLifeCallbacks != null) {
            this.mLifeCallbacks.onShow();
        }
        this.isShow = true;
    }

    @Override
    public void dismiss() {
        this.dismissInternal();
        if (this.mAutoDismissDuration != -1L) {
            this.mHandler.removeCallbacks(this.mAutoDismissRunnable);
        }
        this.mAchorView = null;
        this.mGuideView = null;
        if (this.mLifeCallbacks != null) {
            this.mLifeCallbacks.onDismiss();
        }
        this.isShow = false;
    }

    public abstract void showInternal();

    public abstract void dismissInternal();

    public abstract void subscribeBackKeyEvent();

    public abstract void unSubscribeBackKeyEvent();

    public void withOnce(Guide.LifeCallback lifeCallbacks) {
        DefaultOnce defaultOnce = new DefaultOnce(this.mKey);
        defaultOnce.setLifeCallback(lifeCallbacks);
        this.setIntercept(defaultOnce);
        this.setLifeCallback(defaultOnce);
    }

    public boolean isShow() {
        return this.isShow;
    }
}

