/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.activity;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.immersion.ImmersionActivity;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.ui.activity.BaseActivityProxy;
import com.yy.mobile.ui.utils.AppForegroundStateManager;
import com.yy.mobile.util.ImeUtil;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.activity.YYActivityManager;
import com.yy.mobile.util.asynctask.ScheduledTask;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.playtogether.anchor.timeelapse.TimeElapseMessageManager;
import com.yymobile.core.statistic.IHiidoStatisticNewCore;

public enum GlobalActivityManager implements EventCompat
{
    INSTANCE;

    private static final String TAG = "GlobalActivityManager";
    private BaseActivityProxy mBaseActivityProxy;

    public void onEventBind() {
    }

    public void onEventUnBind() {
    }

    public void init(Application application) {
        YYActivityManager.INSTANCE.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                MLog.info((Object)GlobalActivityManager.TAG, (String)"activity onCreate: %s", (Object[])new Object[]{activity});
                GlobalActivityManager.this.setCurrentActivity(activity);
                GlobalActivityManager.this.mBaseActivityProxy.onCreate();
            }

            public void onActivityStarted(Activity activity) {
                GlobalActivityManager.this.onStarted(activity);
            }

            public void onActivityResumed(Activity activity) {
                MLog.info((Object)GlobalActivityManager.TAG, (String)"activity onResume: %s", (Object[])new Object[]{activity});
                GlobalActivityManager.this.setCurrentActivity(activity);
                GlobalActivityManager.this.onResume(activity);
                GlobalActivityManager.this.mBaseActivityProxy.onResume();
            }

            public void onActivityPaused(Activity activity) {
                MLog.info((Object)GlobalActivityManager.TAG, (String)"activity onPause: %s", (Object[])new Object[]{activity});
                GlobalActivityManager.this.onPause(activity);
                if (GlobalActivityManager.this.mBaseActivityProxy != null && GlobalActivityManager.this.mBaseActivityProxy.getActivity() == activity) {
                    GlobalActivityManager.this.mBaseActivityProxy.onPause();
                }
            }

            public void onActivityStopped(Activity activity) {
                GlobalActivityManager.this.onStop(activity);
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            }

            public void onActivityDestroyed(Activity activity) {
                MLog.info((Object)GlobalActivityManager.TAG, (String)"activity onDestroy: %s", (Object[])new Object[]{activity});
                if (GlobalActivityManager.this.isCurrentActivity(activity)) {
                    GlobalActivityManager.this.setCurrentActivity(null);
                }
            }
        });
        ICoreManagerBase.addClient((Object)this);
    }

    private void onResume(Activity activity) {
        if (!this.isSplash(activity)) {
            ScheduledTask.getInstance().scheduledDelayed((Runnable)new HiidoResumeRunnable(activity), 0L);
        }
    }

    protected void handleTimeElapseMessageWhenStop() {
        if (AppForegroundStateManager.getInstance().isAppInForeground().booleanValue()) {
            TimeElapseMessageManager.INSTANCE.clear();
        }
    }

    private void onStarted(Activity activity) {
        if (this.isShowBaseActivity()) {
            AppForegroundStateManager.getInstance().onActivityVisible(activity);
        }
    }

    private void onStop(Activity activity) {
        if (this.isShowBaseActivity()) {
            AppForegroundStateManager.getInstance().onActivityNotVisible(activity);
            this.handleTimeElapseMessageWhenStop();
        }
    }

    private boolean isShowBaseActivity() {
        return this.getCurrentActivity() != null && this.getCurrentActivity() instanceof ImmersionActivity;
    }

    private void onPause(Activity activity) {
        if (!this.isSplash(activity)) {
            ScheduledTask.getInstance().scheduledDelayed((Runnable)new HiidoPauseRunnable(activity), 0L);
            ImeUtil.hideIME((Activity)activity);
            TimeElapseMessageManager.INSTANCE.uiTransition();
        }
    }

    private boolean isSplash(Activity activity) {
        return StringUtils.equal((String)"com.yy.mobile.ui.splash.SplashActivity", (String)activity.getClass().getName());
    }

    private boolean isCurrentActivity(Activity activity) {
        return activity == this.getCurrentActivity();
    }

    public void setCurrentActivity(Activity activity) {
        MLog.info((Object)TAG, (String)"set current activity: %s", (Object[])new Object[]{activity});
        Class<?> lastActivityClass = null;
        if (this.mBaseActivityProxy != null) {
            lastActivityClass = this.mBaseActivityProxy.getActivity().getClass();
        }
        if (activity == null) {
            this.mBaseActivityProxy = null;
        } else if (this.mBaseActivityProxy == null || this.mBaseActivityProxy.getActivity() != activity) {
            this.mBaseActivityProxy = new BaseActivityProxy(activity, lastActivityClass);
        }
    }

    public Activity getCurrentActivity() {
        if (this.mBaseActivityProxy == null) {
            return null;
        }
        return this.mBaseActivityProxy.getActivity();
    }

    public Class<? extends Activity> getLastActivityClass() {
        if (this.mBaseActivityProxy == null) {
            return null;
        }
        return this.mBaseActivityProxy.getLastActivityClass();
    }

    public boolean isResumed() {
        return this.mBaseActivityProxy.isResumed();
    }

    private static class HiidoPauseRunnable
    extends HiidoRunnable {
        HiidoPauseRunnable(Activity activity) {
            super(activity);
        }

        @Override
        public void run() {
            try {
                ((IHiidoStatisticNewCore)CoreFactory.getCore(IHiidoStatisticNewCore.class)).onPause(this.getPageId());
            }
            catch (Throwable t) {
                MLog.error((Object)GlobalActivityManager.TAG, (String)"[kaede] onPause", (Throwable)t, (Object[])new Object[0]);
            }
        }
    }

    private static class HiidoResumeRunnable
    extends HiidoRunnable {
        HiidoResumeRunnable(Activity activity) {
            super(activity);
        }

        @Override
        public void run() {
            ((IHiidoStatisticNewCore)CoreFactory.getCore(IHiidoStatisticNewCore.class)).onResume(LoginUtil.getUid(), this.getPageId());
        }
    }

    private static abstract class HiidoRunnable
    implements Runnable {
        private final String mPageId;

        HiidoRunnable(Activity activity) {
            this.mPageId = activity != null ? activity.getClass().getName() : "";
        }

        protected String getPageId() {
            return this.mPageId;
        }
    }
}

