/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.alibaba.android.arouter.exception.InitException;
import com.alibaba.android.arouter.launcher.ARouter;
import com.yy.android.small.Small;
import com.yy.immersion.ImmersionActivity;
import com.yy.mobile.model.startup.RestartUnionSDK;
import com.yy.mobile.mvp.MvpPresenter;
import com.yy.mobile.mvp.MvpView;
import com.yy.mobile.ui.IDialogBaseActivity;
import com.yy.mobile.ui.utils.AppForegroundStateManager;
import com.yy.mobile.ui.utils.DimensUtils;
import com.yy.mobile.ui.utils.dialog.DialogLinkManager;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.playtogether.anchor.timeelapse.ItemView;
import com.yymobile.core.playtogether.anchor.timeelapse.TimeElapseMessageManager;
import com.yymobile.core.playtogether.anchor.timeelapse.TimeElapseRecyclerView;
import com.yymobile.core.playtogether.anchor.timeelapse.TimeElapseViewHolderMapper;

public abstract class DialogBaseActivity<P extends MvpPresenter<V>, V extends MvpView>
extends ImmersionActivity<P, V>
implements IDialogBaseActivity {
    private static final String TAG = "DialogBaseActivity";
    private Context mContext;
    private DialogLinkManager mDialogLinkManager;
    private Handler mHandler = new SafeDispatchHandler(Looper.getMainLooper());
    protected TimeElapseRecyclerView messageRecyclerView;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mContext = this;
        this.mDialogLinkManager = new DialogLinkManager((Context)this);
        try {
            ARouter.getInstance().inject((Object)this);
        }
        catch (InitException e2) {
            RestartUnionSDK.restart(this.getApplication());
        }
    }

    protected void onResume() {
        super.onResume();
    }

    public void initPushView() {
        MLog.info((Object)TAG, (String)"initPushView", (Object[])new Object[0]);
        View parent = this.getWindow().getDecorView();
        if (parent != null && parent instanceof ViewGroup) {
            ItemView itemView = TimeElapseViewHolderMapper.INSTANCE.get("play_together_push");
            this.messageRecyclerView = new TimeElapseRecyclerView((Context)this);
            this.messageRecyclerView.setItemView(itemView);
            ViewGroup viewGroup = (ViewGroup)parent;
            viewGroup.addView((View)this.messageRecyclerView);
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, DimensUtils.dip2pixel((Context)this, (float)300.0f));
            int margin = DimensUtils.dip2pixel((Context)this, (float)10.0f);
            int marginTop = DimensUtils.getStatusBarHeight((Context)this);
            lp.setMargins(margin, marginTop, margin, margin);
            this.messageRecyclerView.setLayoutParams((ViewGroup.LayoutParams)lp);
            viewGroup.bringChildToFront((View)this.messageRecyclerView);
            this.messageRecyclerView.start();
        }
    }

    public void removePushView() {
        if (this.messageRecyclerView != null) {
            MLog.info((Object)TAG, (String)"removePushView", (Object[])new Object[0]);
            View parent = this.getWindow().getDecorView();
            if (parent != null && parent instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)parent;
                viewGroup.removeView((View)this.messageRecyclerView);
            }
            this.destroyPushView();
        }
    }

    @Override
    public DialogLinkManager getDialogLinkManager() {
        if (this.mDialogLinkManager == null) {
            this.mDialogLinkManager = new DialogLinkManager((Context)this);
        }
        return this.mDialogLinkManager;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        Small.updateResource();
        super.onConfigurationChanged(newConfig);
    }

    protected void onStart() {
        super.onStart();
        if (this.messageRecyclerView != null) {
            this.messageRecyclerView.setMaxShowSize(1);
            this.messageRecyclerView.start();
        }
    }

    protected void onPause() {
        super.onPause();
    }

    protected void onStop() {
        super.onStop();
        this.destroyPushView();
    }

    protected void handleTimeElapseMessageWhenStop() {
        if (AppForegroundStateManager.getInstance().isAppInForeground().booleanValue()) {
            TimeElapseMessageManager.INSTANCE.clear();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mDialogLinkManager != null) {
            try {
                this.mDialogLinkManager.dismissDialog();
            }
            catch (Exception e2) {
                MLog.error((Object)TAG, (String)"onDestroy dismiss dialog error.", (Throwable)e2, (Object[])new Object[0]);
            }
        }
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
        this.mDialogLinkManager = null;
    }

    @Override
    public Handler getHandler() {
        return this.mHandler;
    }

    @Override
    public boolean isBindingYYAccount() {
        return false;
    }

    @Override
    public boolean needAutoFinishWhenKickedOff() {
        return false;
    }

    @Override
    public boolean needBackToMainWhenKickedOff() {
        return true;
    }

    public boolean isMessageRecyclerViewCreated() {
        return this.messageRecyclerView != null;
    }

    public void destroyPushView() {
        MLog.info((Object)TAG, (String)"destroyPushView", (Object[])new Object[0]);
        if (this.messageRecyclerView != null) {
            this.messageRecyclerView.stop();
            this.messageRecyclerView = null;
        }
    }

    public Context getContext() {
        return this.mContext;
    }
}

