/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import com.alibaba.android.arouter.exception.InitException;
import com.alibaba.android.arouter.launcher.ARouter;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.model.startup.RestartUnionSDK;
import com.yy.mobile.mvp.MvpPresenter;
import com.yy.mobile.mvp.MvpView;
import com.yy.mobile.ui.IDataStatus;
import com.yy.mobile.ui.common.IStatusFragment;
import com.yy.mobile.ui.common.LoadingFragment;
import com.yy.mobile.ui.common.NetworkErrorFragment;
import com.yy.mobile.ui.common.NoDataFragment;
import com.yy.mobile.ui.common.NoDataFragmentWithBtn;
import com.yy.mobile.ui.common.NoMobileLiveFragment;
import com.yy.mobile.ui.common.ReloadFragment;
import com.yy.mobile.ui.utils.dialog.DialogLinkManager;
import com.yy.mobile.ui.widget.BaseFragment;
import com.yy.mobile.ui.widget.StatusLayout;
import com.yy.mobile.ui.widget.pager.IPagerPosition;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.log.MLog;
import com.yymobile.baseapi.R;
import com.yymobile.core.ICoreManagerBase;

public class BaseLinkFragment<P extends MvpPresenter<V>, V extends MvpView>
extends BaseFragment<P, V>
implements IDataStatus,
IPagerPosition {
    public static final String STATUS_TAG = "STATUS_TAG";
    private static final String TAG = "BaseLinkFragment";
    public boolean isSelected = false;
    private Context mContext;
    private SafeDispatchHandler mHandler = new SafeDispatchHandler(Looper.getMainLooper());
    private Toast mToast;
    private DialogLinkManager mDialogManager;
    private String mSimpleName;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mSimpleName = ((Object)((Object)this)).getClass().getSimpleName();
        MLog.info((Object)TAG, (String)"fragment(%s) onCreate", (Object[])new Object[]{this.mSimpleName});
        this.mContext = this.getActivity();
        ICoreManagerBase.addClient((Object)this);
        try {
            ARouter.getInstance().inject((Object)this);
        }
        catch (InitException e2) {
            FragmentActivity activity = this.getActivity();
            assert (activity != null);
            RestartUnionSDK.restart(activity.getApplication());
        }
    }

    public Context getContext() {
        return this.mContext;
    }

    public void onStart() {
        super.onStart();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"fragment(%s) onStart", (Object[])new Object[]{this.mSimpleName});
        }
    }

    public void onResume() {
        super.onResume();
        MLog.info((Object)TAG, (String)"fragment(%s) onResume", (Object[])new Object[]{this.mSimpleName});
    }

    public void onPause() {
        super.onPause();
        MLog.info((Object)TAG, (String)"fragment(%s) onPause", (Object[])new Object[]{this.mSimpleName});
        if (this.mToast != null) {
            this.mToast.cancel();
        }
    }

    public void onStop() {
        super.onStop();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"fragment(%s) onStop", (Object[])new Object[]{this.mSimpleName});
        }
    }

    public void onDestroy() {
        super.onDestroy();
        MLog.info((Object)TAG, (String)"fragment(%s) onDestroy", (Object[])new Object[]{this.mSimpleName});
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
        if (this.mContext != null) {
            this.mContext = null;
        }
        if (this.mDialogManager != null) {
            this.mDialogManager = null;
        }
        ICoreManagerBase.removeClient((Object)this);
    }

    public void onViewStateRestored(Bundle savedInstanceState) {
        super.onViewStateRestored(savedInstanceState);
        if (savedInstanceState != null) {
            Fragment fragment = this.getChildFragmentManager().findFragmentByTag(STATUS_TAG);
            if (fragment != null && fragment instanceof NoMobileLiveFragment) {
                ((NoMobileLiveFragment)fragment).setListener(this.getNoMobileLiveDataListener());
            } else if (fragment != null && fragment instanceof IStatusFragment) {
                if (!MLog.isLogLevelAboveVerbose()) {
                    MLog.verbose((Object)TAG, (String)"xuwakao, onViewStateRestored re-set listener", (Object[])new Object[0]);
                }
                ((IStatusFragment)fragment).setListener(this.getLoadListener());
            }
        }
    }

    public void onHiddenChanged(boolean hidden) {
        super.onHiddenChanged(hidden);
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((Object)TAG, (String)("xuwakao, fragment onHiddenChanged hidden = " + hidden), (Object[])new Object[0]);
        }
    }

    public View.OnClickListener getLoadListener() {
        return null;
    }

    public View.OnClickListener getLoadMoreListener() {
        return null;
    }

    public View.OnClickListener getNoMobileLiveDataListener() {
        return null;
    }

    public void showLoading() {
        this.showLoading(0, 0);
    }

    public void showLoading(View view) {
        this.showLoading(view, 0, 0);
    }

    public void showReload() {
        this.showReload(0, 0);
    }

    public void showLoading(int drawable, int tips) {
        this.showLoading(this.getView(), drawable, tips);
    }

    public void showLoading(View view, int drawable, int tips) {
        if (!this.checkActivityValid()) {
            return;
        }
        if (view == null) {
            return;
        }
        View status = view.findViewById(R.id.status_layout);
        if (status == null || status.getId() <= 0) {
            return;
        }
        LoadingFragment fragment = LoadingFragment.newInstance((int)drawable, (int)tips);
        this.getChildFragmentManager().beginTransaction().replace(status.getId(), (Fragment)fragment, STATUS_TAG).commitAllowingStateLoss();
    }

    public void showReload(int drawable, int tips) {
        this.showReload(this.getView(), drawable, tips);
    }

    public void showReload(View view, int drawable, int tips) {
        if (!this.checkActivityValid()) {
            return;
        }
        if (view == null) {
            MLog.error((Object)TAG, (String)"xuwakao, showReload view is NULL", (Object[])new Object[0]);
            return;
        }
        View status = view.findViewById(R.id.status_layout);
        if (status == null || status.getId() <= 0) {
            MLog.error((Object)TAG, (String)"xuwakao, had not set layout id ", (Object[])new Object[0]);
            return;
        }
        ReloadFragment fragment = ReloadFragment.newInstance((int)drawable, (int)tips);
        fragment.setListener(this.getLoadListener());
        this.getChildFragmentManager().beginTransaction().replace(status.getId(), (Fragment)fragment, STATUS_TAG).commitAllowingStateLoss();
    }

    public void showNoData() {
        this.showNoData(0, 0);
    }

    public void showNoData(int drawable, int tips) {
        this.showNoData(this.getView(), drawable, tips);
    }

    public void showNoData(int drawable, CharSequence charSequence) {
        this.showNoData(this.getView(), drawable, charSequence);
    }

    public void showNoData(View view, int drawable, int tips) {
        if (tips <= 0) {
            this.showNoData(view, drawable, "");
        } else {
            this.showNoData(view, drawable, this.mContext.getString(tips));
        }
    }

    public void showNoData(View view, int drawable, CharSequence charSequence) {
        this.showNoData(view, drawable, charSequence, null);
    }

    public void showNoData(View view, int drawable, CharSequence charSequence, View.OnClickListener onClickListener) {
        if (!this.checkActivityValid()) {
            return;
        }
        if (view == null) {
            MLog.error((Object)TAG, (String)"xuwakao, showNoData view is NULL", (Object[])new Object[0]);
            return;
        }
        View status = view.findViewById(R.id.status_layout);
        if (status == null || status.getId() <= 0) {
            MLog.error((Object)TAG, (String)"xuwakao, had not set layout id ", (Object[])new Object[0]);
            return;
        }
        NoDataFragment fragment = NoDataFragment.newInstance((int)drawable, (CharSequence)charSequence);
        fragment.setListener(onClickListener != null ? onClickListener : this.getLoadListener());
        this.getChildFragmentManager().beginTransaction().replace(status.getId(), (Fragment)fragment, STATUS_TAG).commitAllowingStateLoss();
    }

    public void showNoDataWithBtn(int drawable, String tips, String btnText, View.OnClickListener btnClickListener) {
        if (!this.checkActivityValid()) {
            return;
        }
        if (this.getView() == null) {
            MLog.error((Object)TAG, (String)"showNoDataWithBtn view is NULL", (Object[])new Object[0]);
            return;
        }
        View status = this.getView().findViewById(R.id.status_layout);
        if (status == null || status.getId() <= 0) {
            MLog.error((Object)TAG, (String)"had not set layout id ", (Object[])new Object[0]);
            return;
        }
        NoDataFragmentWithBtn fragment = NoDataFragmentWithBtn.newInstance((int)drawable, (CharSequence)tips);
        fragment.setBtnContent(btnText, btnClickListener);
        this.getChildFragmentManager().beginTransaction().replace(status.getId(), (Fragment)fragment, STATUS_TAG).commitAllowingStateLoss();
    }

    public void showFragment(Fragment fragment) {
        if (!this.checkActivityValid()) {
            return;
        }
        if (this.getView() == null) {
            MLog.error((Object)TAG, (String)"showNoDataWithBtn view is NULL", (Object[])new Object[0]);
            return;
        }
        View status = this.getView().findViewById(R.id.status_layout);
        if (status == null || status.getId() <= 0) {
            MLog.error((Object)TAG, (String)"had not set layout id ", (Object[])new Object[0]);
            return;
        }
        this.getChildFragmentManager().beginTransaction().replace(status.getId(), fragment, STATUS_TAG).commitAllowingStateLoss();
    }

    public void showNetworkErr() {
        if (!this.checkActivityValid()) {
            return;
        }
        if (this.getView() == null) {
            MLog.error((Object)TAG, (String)"xuwakao, showNetworkErr view is NULL", (Object[])new Object[0]);
            return;
        }
        View status = this.getView().findViewById(R.id.status_layout);
        if (status == null || status.getId() <= 0) {
            MLog.error((Object)TAG, (String)"xuwakao, had not set layout id ", (Object[])new Object[0]);
            return;
        }
        NetworkErrorFragment fragment = NetworkErrorFragment.newInstance();
        fragment.setListener(this.getLoadListener());
        this.getChildFragmentManager().beginTransaction().replace(status.getId(), (Fragment)fragment, STATUS_TAG).commitAllowingStateLoss();
    }

    public void hideStatus() {
        try {
            Fragment fragment = this.getChildFragmentManager().findFragmentByTag(STATUS_TAG);
            if (fragment != null) {
                this.getChildFragmentManager().beginTransaction().remove(fragment).commitAllowingStateLoss();
            } else if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((Object)TAG, (String)"xuwakao, status fragment is NULL", (Object[])new Object[0]);
            }
        }
        catch (IllegalStateException ex) {
            MLog.error((Object)TAG, (String)"xuwakao, status fragment has not been attached yet", (Object[])new Object[0]);
        }
    }

    public void showNoMobileLiveData() {
        if (!this.checkActivityValid()) {
            return;
        }
        if (this.getView() == null) {
            MLog.error((Object)TAG, (String)"xuwakao, showNoMobileLiveData view is NULL", (Object[])new Object[0]);
            return;
        }
        View status = this.getView().findViewById(R.id.status_layout);
        if (status == null || status.getId() <= 0) {
            MLog.error((Object)TAG, (String)"xuwakao, had not set layout id ", (Object[])new Object[0]);
            return;
        }
        NoMobileLiveFragment fragment = NoMobileLiveFragment.newInstance();
        fragment.setListener(this.getNoMobileLiveDataListener());
        this.getChildFragmentManager().beginTransaction().replace(status.getId(), (Fragment)fragment, STATUS_TAG).commitAllowingStateLoss();
    }

    public void showPageError(int tips) {
        this.showPageError(this.getView(), tips);
    }

    public void showPageError(View view, int tips) {
        if (!this.checkActivityValid()) {
            return;
        }
        if (view == null) {
            MLog.error((Object)TAG, (String)"xuwakao, showReload view is NULL", (Object[])new Object[0]);
            return;
        }
        View more = view.findViewById(R.id.loading_more);
        if (more == null) {
            MLog.error((Object)TAG, (String)"xuwakao, showReload more is NULL", (Object[])new Object[0]);
            return;
        }
        StatusLayout statusLayout = (StatusLayout)more.getParent();
        statusLayout.showErrorPage(tips, this.getLoadMoreListener());
    }

    public void showPageLoading() {
        if (!this.checkActivityValid()) {
            return;
        }
        if (this.getView() == null) {
            MLog.error((Object)TAG, (String)"xuwakao, showReload view is NULL", (Object[])new Object[0]);
            return;
        }
        View more = this.getView().findViewById(R.id.loading_more);
        if (more == null) {
            MLog.error((Object)TAG, (String)"xuwakao, showReload more is NULL", (Object[])new Object[0]);
            return;
        }
        if (more.getParent() == null) {
            MLog.error((Object)TAG, (String)"xuwakao, showReload more getParent is NULL", (Object[])new Object[0]);
            return;
        }
        StatusLayout statusLayout = (StatusLayout)more.getParent();
        statusLayout.showLoadMore();
    }

    @TargetApi(value=17)
    protected boolean checkActivityValid() {
        if (this.getActivity() == null) {
            return false;
        }
        if (this.getActivity().isFinishing()) {
            return false;
        }
        return Build.VERSION.SDK_INT < 17 || !this.getActivity().isDestroyed();
    }

    public boolean isLogined() {
        return LoginUtil.isLogined();
    }

    public boolean isNetworkAvailable() {
        return NetworkUtils.isNetworkStrictlyAvailable((Context)this.getContext());
    }

    public boolean checkNetToast() {
        boolean falg = this.isNetworkAvailable();
        if (this.checkActivityValid() && !falg && this.getContext() != null) {
            Toast.makeText((Context)this.getContext(), (int)R.string.str_network_not_capable, (int)0).show();
        }
        return falg;
    }

    public void toast(int resId) {
        this.toast(resId, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void toast(int resId, int length) {
        if (!this.isResumed()) return;
        if (this.mToast == null) {
            if (this.getContext() == null) return;
            this.mToast = Toast.makeText((Context)this.getContext(), (int)resId, (int)length);
        } else {
            this.mToast = Toast.makeText((Context)this.getContext(), (int)resId, (int)length);
        }
        this.mToast.show();
    }

    public void toast(String message) {
        this.toast(message, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void toast(String message, int length) {
        if (!this.isResumed()) return;
        if (this.mToast == null) {
            if (this.getContext() == null) return;
            this.mToast = Toast.makeText((Context)this.getContext(), (CharSequence)message, (int)length);
        } else {
            this.mToast = Toast.makeText((Context)this.getContext(), (CharSequence)message, (int)length);
        }
        this.mToast.show();
    }

    public <T> T findFragmentById(int id2, Class<T> clazz) {
        Fragment f = this.getActivity().getSupportFragmentManager().findFragmentById(id2);
        return (T)f;
    }

    public <T> T findChildFragmentById(int id2, Class<T> clazz) {
        Fragment f = this.getChildFragmentManager().findFragmentById(id2);
        return (T)f;
    }

    public <T> T findFragmentByTag(String tag, Class<T> clazz) {
        Fragment f = this.getActivity().getSupportFragmentManager().findFragmentByTag(tag);
        return (T)f;
    }

    public <T> T getActivity(Class<T> clazz) {
        FragmentActivity f = this.getActivity();
        return (T)f;
    }

    protected Handler getHandler() {
        return this.mHandler;
    }

    public DialogLinkManager getLinkDialogManager() {
        if (this.mDialogManager == null && this.mContext != null) {
            this.mDialogManager = new DialogLinkManager(this.mContext);
        }
        return this.mDialogManager;
    }

    public void setPosition(int position) {
    }

    public void onSelected(int position) {
        this.isSelected = true;
        super.onSelected();
    }

    public void onUnSelected(int position) {
        this.isSelected = false;
        super.onUnSelected();
    }

    public void onPageScrollComplete(int position) {
    }
}

