/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ylink.pluginmanager;

import com.unionyy.coverage_lib.CoverageLogger;
import com.yy.mobile.util.DontProguardClass;
import java.util.HashMap;
import java.util.Map;

@DontProguardClass
public class LinkChannelConstants {
    private static OneToOneHashMap<String, Integer> linkChannelTypeMaps;

    public static int getLinkChannelTypeOrdinalFromTemplateId(String templateId) {
        if (templateId != null && linkChannelTypeMaps.containsKey(templateId)) {
            return linkChannelTypeMaps.get(templateId);
        }
        return LinkChannelType.BASIC.ordinal();
    }

    public static LinkChannelType getLinkChannelTypeFromTemplateId(String templateId) {
        if (templateId != null && linkChannelTypeMaps.containsKey(templateId)) {
            return LinkChannelConstants.getLinkChannelTypeFromOrdinal(linkChannelTypeMaps.get(templateId));
        }
        return LinkChannelType.BASIC;
    }

    public static LinkChannelType getLinkChannelTypeFromOrdinal(int ordinal) {
        if (linkChannelTypeMaps.containsValue(ordinal)) {
            return LinkChannelType.values()[ordinal];
        }
        return LinkChannelType.BASIC;
    }

    public static String getTemplataIdFromLChannelType(LinkChannelType linkChannelType) {
        if (linkChannelTypeMaps.containsValue(linkChannelType.ordinal())) {
            return linkChannelTypeMaps.getKeyFromValue(linkChannelType.ordinal());
        }
        return "0";
    }

    public static String getTemplateIdFromLChannelTypeOrdinal(int ordinal) {
        if (linkChannelTypeMaps.containsValue(ordinal)) {
            return linkChannelTypeMaps.getKeyFromValue(ordinal);
        }
        return "0";
    }

    static {
        CoverageLogger.Log((String)"com/yy/mobile/ylink/pluginmanager/LinkChannelConstants:<clinit>:()V");
        linkChannelTypeMaps = new OneToOneHashMap();
        linkChannelTypeMaps.put("0", LinkChannelType.BASIC.ordinal());
        linkChannelTypeMaps.put("1", LinkChannelType.MOBILE_LIVE.ordinal());
        linkChannelTypeMaps.put("2", LinkChannelType.GAME_VOICE.ordinal());
        linkChannelTypeMaps.put("3", LinkChannelType.MOBILE_LIVE_HOST.ordinal());
        linkChannelTypeMaps.put("16777217", LinkChannelType.ENTERTAINMENT.ordinal());
        linkChannelTypeMaps.put("67108867", LinkChannelType.GAME_LIVE.ordinal());
        linkChannelTypeMaps.put("268435460", LinkChannelType.FRIEND.ordinal());
        linkChannelTypeMaps.put("33554434", LinkChannelType.EDUCATION.ordinal());
        linkChannelTypeMaps.put("33554487", LinkChannelType.RUI_XUE.ordinal());
        linkChannelTypeMaps.put("268435457", LinkChannelType.FINANCE.ordinal());
        linkChannelTypeMaps.put("268435465", LinkChannelType.WO_DI.ordinal());
        linkChannelTypeMaps.put("33554490", LinkChannelType.CONCERT.ordinal());
        linkChannelTypeMaps.put("33554452", LinkChannelType.ENT_1931.ordinal());
        linkChannelTypeMaps.put("33554493", LinkChannelType.NEW_1931.ordinal());
        linkChannelTypeMaps.put("33554494", LinkChannelType.JU_BA.ordinal());
        linkChannelTypeMaps.put("33554514", LinkChannelType.ONE_PIECE.ordinal());
        linkChannelTypeMaps.put("33554519", LinkChannelType.VOICE_ROOM.ordinal());
        linkChannelTypeMaps.put("33554520", LinkChannelType.VOICE_ROOM.ordinal());
    }

    public static class OneToOneHashMap<K, V> {
        Map<K, V> keyValueMaps = new HashMap();
        Map<V, K> valueKeyMaps = new HashMap<V, K>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(K k, V v) {
            Class<OneToOneHashMap> clazz = OneToOneHashMap.class;
            synchronized (OneToOneHashMap.class) {
                this.keyValueMaps.put(k, v);
                this.valueKeyMaps.put(v, k);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        public boolean containsKey(K k) {
            return this.keyValueMaps.containsKey(k);
        }

        public boolean containsValue(V v) {
            return this.keyValueMaps.containsValue(v);
        }

        public V get(K k) {
            return this.getValueFromKey(k);
        }

        public V getValueFromKey(K k) {
            return this.keyValueMaps.get(k);
        }

        public K getKeyFromValue(V v) {
            return this.valueKeyMaps.get(v);
        }

        static {
            CoverageLogger.Log((String)"com/yy/mobile/ylink/pluginmanager/LinkChannelConstants$OneToOneHashMap:<clinit>:");
        }
    }

    public static final class LinkChannelType
    extends Enum<LinkChannelType> {
        public static final /* enum */ LinkChannelType BASIC;
        public static final /* enum */ LinkChannelType MOBILE_LIVE;
        public static final /* enum */ LinkChannelType GAME_VOICE;
        public static final /* enum */ LinkChannelType MOBILE_LIVE_HOST;
        public static final /* enum */ LinkChannelType ENTERTAINMENT;
        public static final /* enum */ LinkChannelType GAME_LIVE;
        public static final /* enum */ LinkChannelType FRIEND;
        public static final /* enum */ LinkChannelType EDUCATION;
        public static final /* enum */ LinkChannelType RUI_XUE;
        public static final /* enum */ LinkChannelType FINANCE;
        public static final /* enum */ LinkChannelType WO_DI;
        public static final /* enum */ LinkChannelType CONCERT;
        public static final /* enum */ LinkChannelType ENT_1931;
        public static final /* enum */ LinkChannelType NEW_1931;
        public static final /* enum */ LinkChannelType JU_BA;
        public static final /* enum */ LinkChannelType ONE_PIECE;
        public static final /* enum */ LinkChannelType VOICE_ROOM;
        private static final /* synthetic */ LinkChannelType[] $VALUES;

        public static LinkChannelType[] values() {
            return (LinkChannelType[])$VALUES.clone();
        }

        public static LinkChannelType valueOf(String name) {
            return Enum.valueOf(LinkChannelType.class, name);
        }

        static {
            CoverageLogger.Log((String)"com/yy/mobile/ylink/pluginmanager/LinkChannelConstants$LinkChannelType:<clinit>:()V");
            BASIC = new LinkChannelType();
            MOBILE_LIVE = new LinkChannelType();
            GAME_VOICE = new LinkChannelType();
            MOBILE_LIVE_HOST = new LinkChannelType();
            ENTERTAINMENT = new LinkChannelType();
            GAME_LIVE = new LinkChannelType();
            FRIEND = new LinkChannelType();
            EDUCATION = new LinkChannelType();
            RUI_XUE = new LinkChannelType();
            FINANCE = new LinkChannelType();
            WO_DI = new LinkChannelType();
            CONCERT = new LinkChannelType();
            ENT_1931 = new LinkChannelType();
            NEW_1931 = new LinkChannelType();
            JU_BA = new LinkChannelType();
            ONE_PIECE = new LinkChannelType();
            VOICE_ROOM = new LinkChannelType();
            $VALUES = new LinkChannelType[]{BASIC, MOBILE_LIVE, GAME_VOICE, MOBILE_LIVE_HOST, ENTERTAINMENT, GAME_LIVE, FRIEND, EDUCATION, RUI_XUE, FINANCE, WO_DI, CONCERT, ENT_1931, NEW_1931, JU_BA, ONE_PIECE, VOICE_ROOM};
        }
    }
}

