/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.mobile.basemedia.watchlive.template;

import android.app.Activity;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import com.duowan.mobile.basemedia.api.template.ViewingRoomApi;
import com.duowan.mobile.basemedia.watchlive.activity.IViewingRoom;
import com.duowan.mobile.basemedia.watchlive.template.ComponentRoot;
import com.duowan.mobile.basemedia.watchlive.template.IChannelBaseParam;
import com.duowan.mobile.basemedia.watchlive.template.IViewScene;
import com.duowan.mobile.basemedia.watchlive.template.generate.ComponentsMaker;
import com.trello.rxlifecycle2.android.ActivityEvent;
import com.unionyy.coverage_lib.CoverageLogger;
import com.yy.mobile.mvp.MvpActivity;
import com.yy.mobile.mvp.MvpPresenter;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import io.reactivex.ObservableTransformer;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;

public abstract class TemplateRoomPresenter<View extends MvpActivity>
extends MvpPresenter<View> {
    public IViewingRoom<IChannelBaseParam> currentRoom;
    private Disposable disposable;
    private Disposable createViewingRoomDisposable;

    protected abstract ComponentsMaker createMaker();

    protected abstract IViewingRoom<IChannelBaseParam> createViewingRoom(@NonNull ComponentRoot var1, @NonNull Bundle var2);

    protected abstract ViewingRoomApi<IChannelBaseParam> getViewingRoomApi();

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        assert (this.getView() != null);
        ComponentsMaker maker = this.createMaker();
        final ComponentRoot root = new ComponentRoot((FragmentActivity)this.getView(), maker);
        Bundle bundle = savedInstanceState != null ? savedInstanceState : this.getArguments();
        this.createViewingRoomDisposable = this.getViewingRoomApi().createViewingRoom(this.createViewingRoom(root, bundle)).compose((ObservableTransformer)((MvpActivity)this.getView()).bindUntilEvent(ActivityEvent.DESTROY)).subscribe((Consumer)new Consumer<IViewingRoom<IChannelBaseParam>>(){

            public void accept(IViewingRoom<IChannelBaseParam> viewingRoom) {
                MLog.info((Object)"LiveTemplatePresenter", (String)("viewingroom:" + viewingRoom), (Object[])new Object[0]);
                TemplateRoomPresenter.this.currentRoom = viewingRoom;
                root.setUpdataChannelParmaProxy(TemplateRoomPresenter.this.currentRoom);
                root.requestReload();
                TemplateRoomPresenter.this.disposable = TemplateRoomPresenter.this.currentRoom.updateChannelInfo(TemplateRoomPresenter.this.currentRoom.getChannelBaseParam()).subscribe((Consumer)new Consumer<IViewScene<IChannelBaseParam>>(){

                    public void accept(IViewScene<IChannelBaseParam> scene) {
                        TemplateRoomPresenter.this.currentRoom.applySceneToRoot(scene);
                    }

                    static {
                        CoverageLogger.Log((String)"com/duowan/mobile/basemedia/watchlive/template/TemplateRoomPresenter$1$1:<clinit>:");
                    }
                }, (Consumer)new Consumer<Throwable>(){

                    public void accept(Throwable throwable) {
                        MLog.error((Object)"LiveTemplatePresenter", (String)"updateChannelInfo error ", (Throwable)throwable, (Object[])new Object[0]);
                    }

                    static {
                        CoverageLogger.Log((String)"com/duowan/mobile/basemedia/watchlive/template/TemplateRoomPresenter$1$2:<clinit>:");
                    }
                });
            }

            static {
                CoverageLogger.Log((String)"com/duowan/mobile/basemedia/watchlive/template/TemplateRoomPresenter$1:<clinit>:");
            }
        });
        this.currentRoom.attach((Activity)this.getView());
        this.currentRoom.onCreate(savedInstanceState);
    }

    protected void onResume() {
        super.onResume();
        this.currentRoom.onResume();
    }

    protected void onStart() {
        super.onStart();
        this.currentRoom.onStart();
    }

    protected void onPause() {
        this.currentRoom.onPause();
        super.onPause();
    }

    protected void onStop() {
        this.currentRoom.onStop();
        super.onStop();
    }

    @NonNull
    public Bundle getArguments() {
        Bundle bundle = super.getArguments();
        return bundle != null ? bundle : new Bundle();
    }

    protected void onDestroy() {
        RxUtils.dispose((Disposable)this.disposable);
        this.getViewingRoomApi().destroyViewingRoom();
        this.currentRoom.onDestroy();
        RxUtils.dispose((Disposable)this.createViewingRoomDisposable);
        this.createViewingRoomDisposable = null;
        super.onDestroy();
    }

    public ComponentRoot getRoot() {
        return this.currentRoom.getRoot();
    }

    public void onNewIntent(Intent intent) {
        this.currentRoom.onNewIntent(intent);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.currentRoom.onActivityResult(requestCode, resultCode, data);
    }

    public boolean interceptFinish() {
        return this.currentRoom.interceptFinish();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        this.currentRoom.onConfigurationChanged(newConfig);
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        this.currentRoom.onWindowFocusChanged(hasFocus);
    }

    public boolean onBackPressed() {
        return this.currentRoom.onBackPressed();
    }

    public Bundle saveInfoToBundle(Bundle outState) {
        return this.currentRoom.getChannelBaseParam().saveInfoToBundle(outState);
    }

    static {
        CoverageLogger.Log((String)"com/duowan/mobile/basemedia/watchlive/template/TemplateRoomPresenter:<clinit>:()V");
    }
}

