/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.mobile.basemedia.watchlive.template;

import android.graphics.Camera;
import android.graphics.Matrix;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.unionyy.coverage_lib.CoverageLogger;

public class Rotate3DAnimation
extends Animation {
    private final float mFromDegrees;
    private final float mToDegrees;
    private final float mCenterX;
    private final float mCenterY;
    private final float mDepthZ;
    private Camera mCamera;
    private boolean mIsEnterView;

    public Rotate3DAnimation(float fromDegrees, float toDegrees, float centerX, float centerY, float depthZ, boolean isEnterView) {
        this.mFromDegrees = fromDegrees;
        this.mToDegrees = toDegrees;
        this.mCenterX = centerX;
        this.mCenterY = centerY;
        this.mDepthZ = depthZ;
        this.mIsEnterView = isEnterView;
    }

    public void initialize(int width, int height, int parentWidth, int parentHeight) {
        super.initialize(width, height, parentWidth, parentHeight);
        this.mCamera = new Camera();
        this.mCamera.setLocation(0.0f, 0.0f, -30.0f);
    }

    protected void applyTransformation(float interpolatedTime, Transformation t) {
        boolean overHalf = interpolatedTime > 0.5f;
        float fromDegrees = this.mFromDegrees;
        float degrees = fromDegrees + (this.mToDegrees - fromDegrees) * interpolatedTime;
        float centerX = this.mCenterX;
        float centerY = this.mCenterY;
        Camera camera = this.mCamera;
        Matrix matrix = t.getMatrix();
        camera.save();
        float depth = (0.5f - Math.abs(interpolatedTime - 0.5f)) * this.mDepthZ;
        camera.translate(0.0f, 0.0f, depth);
        camera.rotateY(degrees);
        camera.getMatrix(matrix);
        camera.restore();
        matrix.preTranslate(-centerX, -centerY);
        matrix.postTranslate(centerX, centerY);
        if (overHalf) {
            if (this.mIsEnterView) {
                t.setAlpha(1.0f);
            } else {
                t.setAlpha(0.0f);
            }
        }
    }

    static {
        CoverageLogger.Log((String)"com/duowan/mobile/basemedia/watchlive/template/Rotate3DAnimation:<clinit>:");
    }
}

