/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.mobile.basemedia.watchlive.template;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.duowan.mobile.basemedia.watchlive.template.IChannelBaseParam;
import com.unionyy.coverage_lib.CoverageLogger;

public class ChannelBaseParam
implements IChannelBaseParam {
    protected final Bundle bundle;

    public ChannelBaseParam(@NonNull Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException();
        }
        this.bundle = bundle;
    }

    @Override
    @NonNull
    public String getFunction() {
        return this.bundle.getString("functionName", "default");
    }

    @Override
    public long getSid() {
        return this.bundle.getLong("channel_sid");
    }

    @Override
    public long getSsid() {
        return this.bundle.getLong("channel_ssid");
    }

    @Override
    public long getAnchorUid() {
        return this.bundle.getLong("channel_anchor_uid");
    }

    @Override
    @Nullable
    public String getTemplateId() {
        return this.bundle.getString("channel_templateId");
    }

    @Override
    @Nullable
    public String getScreenshot() {
        return this.bundle.getString("channel_screenshot_url");
    }

    @Override
    public int getLiveType() {
        return this.bundle.getInt("channel_type", 0);
    }

    @Override
    public void replaceInfo(Bundle newInfo) {
        this.bundle.clear();
        this.bundle.putAll(newInfo);
    }

    @Override
    public void updateInfo(Bundle newInfo) {
        this.bundle.putAll(newInfo);
    }

    @Override
    public void updateTemplateId(String templateId) {
        this.bundle.putString("channel_templateId", templateId);
    }

    @Override
    public void updateLiveType(int type) {
        this.bundle.putInt("channel_type", type);
    }

    @Override
    public void updateSidAndSSid(long sid, long ssid) {
        this.bundle.putLong("channel_sid", sid);
        this.bundle.putLong("channel_ssid", ssid);
    }

    @Override
    public void updateUid(long uid) {
        this.bundle.putLong("channel_anchor_uid", uid);
    }

    @Override
    public void updateFunction(String function) {
        this.bundle.putString("functionName", function);
    }

    @Override
    public Bundle saveInfoToBundle(Bundle outState) {
        outState.putAll(this.bundle);
        return outState;
    }

    public String toString() {
        return "param(sid=" + this.getSid() + ", ssid=" + this.getSsid() + ", templateId=" + this.getTemplateId() + ", anchorUid=" + this.getAnchorUid() + ", function=" + this.getFunction() + ")";
    }

    static {
        CoverageLogger.Log((String)"com/duowan/mobile/basemedia/watchlive/template/ChannelBaseParam:<clinit>:");
    }
}

