/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.mobile.basemedia.watchlive.template.generate;

import android.os.Bundle;
import com.duowan.mobile.basemedia.watchlive.template.AbstractComponentContainer;
import com.duowan.mobile.basemedia.watchlive.template.generate.BranchContainerConfig;
import com.duowan.mobile.basemedia.watchlive.template.generate.ComponentWrapper;
import com.duowan.mobile.basemedia.watchlive.template.generate.PluginComponentWrapper;
import com.duowan.mobile.basemedia.watchlive.template.generate.TrunkContainerConfig;
import com.duowan.mobile.entlive.domain.ContainerConfig;
import com.yy.mobile.ui.basicchanneltemplate.component.IComponent;
import com.yy.mobile.util.FP;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ComponentsFactory {
    protected Map<Class<? extends AbstractComponentContainer>, Class<? extends ContainerConfig>> mContainerToConfigMap = new HashMap<Class<? extends AbstractComponentContainer>, Class<? extends ContainerConfig>>();
    protected Map<Class<? extends ContainerConfig>, List<Class<? extends IComponent>>> mConfigToComponentMap = new HashMap<Class<? extends ContainerConfig>, List<Class<? extends IComponent>>>();
    protected Map<Class<? extends IComponent>, Class<? extends ComponentWrapper>> mComponentWrappers = new HashMap<Class<? extends IComponent>, Class<? extends ComponentWrapper>>();
    protected Map<Class<? extends TrunkContainerConfig>, Class<? extends BranchContainerConfig>> mConfigExtendMap = new HashMap<Class<? extends TrunkContainerConfig>, Class<? extends BranchContainerConfig>>();
    protected Map<Class<? extends IComponent>, ComponentWrapper> mPluginComponentWrappers = new HashMap<Class<? extends IComponent>, ComponentWrapper>();

    public ComponentsFactory() {
        this.initClzMap();
    }

    protected abstract void initClzMap();

    public final <T extends IComponent> ComponentWrapper<T> create(Class<T> clz) {
        Class<? extends ComponentWrapper> wrapperClass = this.mComponentWrappers.get(clz);
        try {
            if (wrapperClass != null) {
                ComponentWrapper instance2 = wrapperClass.newInstance();
                return instance2;
            }
            return this.mPluginComponentWrappers.get(clz);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Set<Class<? extends IComponent>> componentClasses() {
        return this.mComponentWrappers.keySet();
    }

    public List<Class<? extends IComponent>> componentClzsByContainer(Class<? extends AbstractComponentContainer> containerClz) {
        Class<? extends ContainerConfig> configClz = this.mContainerToConfigMap.get(containerClz);
        List<Class<? extends IComponent>> ret = this.mConfigToComponentMap.get(configClz);
        return ret;
    }

    public boolean addPluginComponentInto(Class<? extends AbstractComponentContainer> containerClz, Class<? extends IComponent> componentClz, int resId, Bundle bundle) {
        List<Class<? extends IComponent>> res = this.componentClzsByContainer(containerClz);
        if (FP.empty(res) || res.contains(componentClz)) {
            return false;
        }
        res.add(componentClz);
        ComponentWrapper wrapper = this.mPluginComponentWrappers.get(componentClz);
        if (wrapper instanceof PluginComponentWrapper) {
            PluginComponentWrapper pluginWrapper = (PluginComponentWrapper)wrapper;
            pluginWrapper.addConfigs(this.mContainerToConfigMap.get(containerClz), resId);
        } else {
            PluginComponentWrapper pluginWrapper = new PluginComponentWrapper(componentClz, this.mContainerToConfigMap.get(containerClz), resId, bundle);
            this.mPluginComponentWrappers.put(componentClz, pluginWrapper);
        }
        return true;
    }

    public ContainerConfig getConfig(Class<? extends AbstractComponentContainer> containerClz) throws IllegalAccessException, InstantiationException {
        Class<? extends ContainerConfig> baseConfigClz = this.mContainerToConfigMap.get(containerClz);
        if (baseConfigClz != null) {
            return baseConfigClz.newInstance();
        }
        return null;
    }

    public ContainerConfig getExtendConfig(TrunkContainerConfig baseConfig) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<? extends BranchContainerConfig> found;
        if (!this.mConfigExtendMap.isEmpty() && (found = this.mConfigExtendMap.get(baseConfig.getRootConfigClz())) != null) {
            Constructor<? extends BranchContainerConfig> constructor = found.getDeclaredConstructor(TrunkContainerConfig.class);
            return constructor.newInstance(baseConfig);
        }
        return baseConfig;
    }

    public List<Class<? extends IComponent>> componentClasses(Class<? extends ContainerConfig> config) {
        return this.mConfigToComponentMap.get(config);
    }

    public Class<? extends AbstractComponentContainer> getContainerClz(Class<? extends ContainerConfig> config) {
        Set<Map.Entry<Class<? extends AbstractComponentContainer>, Class<? extends ContainerConfig>>> set = this.mContainerToConfigMap.entrySet();
        for (Map.Entry<Class<? extends AbstractComponentContainer>, Class<? extends ContainerConfig>> entry : set) {
            if (entry.getValue() != config) continue;
            return entry.getKey();
        }
        return null;
    }
}

