/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.mobile.basemedia.watchlive.activity;

import android.os.Handler;
import android.os.Looper;
import com.duowan.mobile.basemedia.api.template.ViewingRoomApi;
import com.duowan.mobile.basemedia.watchlive.activity.DLViewingRoom;
import com.duowan.mobile.basemedia.watchlive.activity.IViewingRoom;
import com.duowan.mobile.basemedia.watchlive.template.IChannelBaseParam;
import com.duowan.mobile.basemedia.watchlive.template.IViewScene;
import com.yy.mobile.util.DontProguardClass;
import com.yy.mobile.util.log.MLog;
import io.reactivex.subjects.BehaviorSubject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DontProguardClass
public class RoomProcessor
implements ViewingRoomApi<IChannelBaseParam> {
    private static final String TAG = "RoomProcessor";
    private Handler handler = new Handler(Looper.getMainLooper());
    @Nullable
    private BehaviorSubject<IViewingRoom<IChannelBaseParam>> viewingRoom;
    private Set<Class<? extends DLViewingRoom>> upgradeRooms = new LinkedHashSet<Class<? extends DLViewingRoom>>();
    private final Lock upgradeRoomLock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BehaviorSubject<IViewingRoom<IChannelBaseParam>> createViewingRoom(@NotNull IViewingRoom<IChannelBaseParam> baseViewingRoom) {
        IViewingRoom<IChannelBaseParam> room = baseViewingRoom;
        this.upgradeRoomLock.lock();
        try {
            MLog.info((Object)TAG, (String)"upgradeRooms = %s", (Object[])new Object[]{this.upgradeRooms});
            for (Class<? extends DLViewingRoom> upgradeRoom : this.upgradeRooms) {
                room = this.createInstance(upgradeRoom, room);
            }
        }
        finally {
            this.upgradeRoomLock.unlock();
        }
        this.viewingRoom = BehaviorSubject.createDefault(room);
        return this.viewingRoom;
    }

    @NotNull
    private IViewingRoom<IChannelBaseParam> createInstance(Class<? extends DLViewingRoom> upgradeRoom, @NotNull IViewingRoom<IChannelBaseParam> baseViewingRoom) {
        try {
            Constructor<? extends DLViewingRoom> constructor = upgradeRoom.getDeclaredConstructor(IViewingRoom.class);
            DLViewingRoom instance2 = constructor.newInstance(baseViewingRoom);
            instance2.init();
            return instance2;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return baseViewingRoom;
    }

    @Override
    public void destroyViewingRoom() {
    }

    @Override
    public void upgradeRoomClz(final Class<? extends DLViewingRoom> dlRoomClz) {
        boolean added;
        this.upgradeRoomLock.lock();
        try {
            added = this.upgradeRooms.add(dlRoomClz);
        }
        finally {
            this.upgradeRoomLock.unlock();
        }
        MLog.info((Object)TAG, (String)("upgradeRoomClz: added = " + added + ", upgradeRooms = %s"), (Object[])new Object[]{this.upgradeRooms});
        final BehaviorSubject<IViewingRoom<IChannelBaseParam>> vr = this.viewingRoom;
        if (added && vr != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    IViewingRoom base = (IViewingRoom)vr.getValue();
                    IViewingRoom room = RoomProcessor.this.createInstance(dlRoomClz, base);
                    MLog.info((Object)RoomProcessor.TAG, (String)("upgrade dlRoomClz = " + dlRoomClz + ", base = " + base), (Object[])new Object[0]);
                    vr.onNext((Object)room);
                }
            });
        }
    }

    @Override
    public void downgradeRoomClz(final Class<? extends DLViewingRoom> dlRoomClz) {
        boolean remove;
        this.upgradeRoomLock.lock();
        try {
            remove = this.upgradeRooms.remove(dlRoomClz);
        }
        finally {
            this.upgradeRoomLock.unlock();
        }
        MLog.info((Object)TAG, (String)("downgradeRoomClz: remove = " + remove + ", upgradeRooms = %s"), (Object[])new Object[]{this.upgradeRooms});
        final BehaviorSubject<IViewingRoom<IChannelBaseParam>> vr = this.viewingRoom;
        if (remove && vr != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    IViewingRoom<IChannelBaseParam> removeRoom = (IViewingRoom<IChannelBaseParam>)vr.getValue();
                    DLViewingRoom preRoom = null;
                    IViewingRoom<IChannelBaseParam> nextRoom = null;
                    boolean find = false;
                    while (removeRoom instanceof DLViewingRoom) {
                        nextRoom = ((DLViewingRoom)removeRoom).getParent();
                        if (removeRoom.getClass() == dlRoomClz) {
                            find = true;
                            break;
                        }
                        preRoom = (DLViewingRoom)removeRoom;
                        removeRoom = nextRoom;
                    }
                    if (find) {
                        ((DLViewingRoom)removeRoom).unInit();
                        if (preRoom != null) {
                            preRoom.setParent(nextRoom);
                            MLog.info((Object)RoomProcessor.TAG, (String)("downgrade: remove = " + removeRoom + ", pre = " + preRoom + ", next = " + nextRoom), (Object[])new Object[0]);
                            vr.onNext((Object)preRoom);
                        } else {
                            MLog.info((Object)RoomProcessor.TAG, (String)("downgrade: remove = " + removeRoom + ", pre = " + preRoom + ", next = " + nextRoom), (Object[])new Object[0]);
                            vr.onNext(nextRoom);
                        }
                    }
                }
            });
        }
    }

    @Override
    public IViewScene<IChannelBaseParam> getCurrentScene() {
        IViewingRoom room;
        if (this.viewingRoom != null && (room = (IViewingRoom)this.viewingRoom.getValue()) != null) {
            return room.getCurrentScene();
        }
        return null;
    }
}

