/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.mobile.entlive.proccessor;

import com.duowan.mobile.entlive.annotation.DefaultInitAttr;
import com.duowan.mobile.entlive.annotation.InitAttrConfig;
import com.duowan.mobile.entlive.domain.InitLevel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;

public class ComponentUnit {
    private String mClassName;
    private List<InitAttrConfig> mConfigs = new ArrayList<InitAttrConfig>();
    private DefaultInitAttr mDefaultInitAttr;
    private List<Element> mBussinessConfig = new ArrayList<Element>();

    public String getClassName() {
        return this.mClassName;
    }

    public String getWrapperClassName() {
        return this.mClassName + "Wrapper";
    }

    public void setClassName(String mClassName) {
        this.mClassName = mClassName;
    }

    public void addConfigs(InitAttrConfig configs, Element config) {
        this.mConfigs.add(configs);
        this.mBussinessConfig.add(config);
    }

    public DefaultInitAttr getDefaultInitAttr() {
        return this.mDefaultInitAttr;
    }

    public void setDefaultInitAttr(DefaultInitAttr defaultInitAttr) {
        this.mDefaultInitAttr = defaultInitAttr;
    }

    public int getDefaultInitLevel() {
        if (this.mDefaultInitAttr != null) {
            return this.mDefaultInitAttr.initLevel().getValue();
        }
        return InitLevel.VERY_LOW.getValue();
    }

    public Element getBussinessId(int index) {
        return this.mBussinessConfig.get(index);
    }

    public TypeMirror getParentClass(InitAttrConfig config) {
        if (config != null) {
            try {
                config.component();
            }
            catch (MirroredTypeException e) {
                return e.getTypeMirror();
            }
            return null;
        }
        return null;
    }

    public List<InitAttrConfig> getInitConfigs() {
        return this.mConfigs;
    }

    private static AnnotationMirror getAnnotationMirror(TypeElement typeElement, Class<?> clazz) {
        String clazzName = clazz.getName();
        for (AnnotationMirror annotationMirror : typeElement.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(clazzName)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static AnnotationValue getAnnotationValue(AnnotationMirror annotationMirror, String key) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
            if (!entry.getKey().getSimpleName().toString().equals(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    private TypeMirror getContainerClass(TypeElement foo) {
        AnnotationMirror am = ComponentUnit.getAnnotationMirror(foo, InitAttrConfig.class);
        if (am == null) {
            return null;
        }
        AnnotationValue av = ComponentUnit.getAnnotationValue(am, "Value");
        if (av == null) {
            return null;
        }
        return (TypeMirror)av.getValue();
    }
}

